/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.DialogBookingFileProductHotelCostTableFine;
import com.gridnine.xtrip.client.fx.model.booking.DialogBookingFileProductHotelCostTableTax;
import com.gridnine.xtrip.client.fx.model.booking.DialogBookingFileProductHotelRoomTableVM;
import com.gridnine.xtrip.client.fx.model.booking.HotelRefundPanelVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.model.booking.HotelRefundFaresSettings;
import com.gridnine.xtrip.common.fx.model.booking.HotelRefundSettings;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.system.Money;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

class RefundHelper {
    RefundHelper() {
    }

    static void toVM(HotelProduct product, HotelRefundPanelVM mainVM, boolean errors) {
        mainVM.setAgent(product.getCashier());
        mainVM.setDate(LocalDateTime.now());
        mainVM.setForceful(product.isForcedRefund());
        mainVM.setErrors(errors ? Messages.Some_Errors : Messages.No_Errors);
        mainVM.getFares().addAll(product.getRooms().stream().map(el -> {
            DialogBookingFileProductHotelRoomTableVM vm = new DialogBookingFileProductHotelRoomTableVM();
            vm.setArrival(DateUtils.asLocalDateTime((Date)el.getCheckInDate()));
            vm.setDeparture(DateUtils.asLocalDateTime((Date)el.getCheckOutDate()));
            vm.setCurrency(el.getBaseRate().getCurrency());
            return vm;
        }).collect(Collectors.toList()));
        mainVM.getTaxes().addAll(product.getTaxes().stream().map(el -> {
            DialogBookingFileProductHotelCostTableTax vm = new DialogBookingFileProductHotelCostTableTax();
            vm.setCode(el.getCode());
            vm.setEqSum(el.getEquivalentAmount());
            vm.setSum(el.getAmount().getValue());
            vm.setCurrency(el.getAmount().getCurrency());
            vm.setTaxUid(el.getUid());
            return vm;
        }).collect(Collectors.toList()));
        mainVM.getPenalties().addAll(product.getPenalties().stream().map(el -> {
            DialogBookingFileProductHotelCostTableFine vm = new DialogBookingFileProductHotelCostTableFine();
            vm.setPenaltyUid(el.getUid());
            vm.setCode(el.getCode());
            vm.setEqSum(el.getEquivalentAmount());
            vm.setName(el.getName());
            return vm;
        }).collect(Collectors.toList()));
    }

    static void fromVM(HotelProduct product, HotelRefundPanelVM vm, HotelRefundSettings params) {
        params.setAgent(vm.getAgent());
        params.setDate(DateUtils.asDate((LocalDateTime)vm.getDate()));
        params.setForced(vm.isForceful());
        Map<String, Room> roomsUid = product.getRooms().stream().collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        vm.getFares().stream().map(el -> {
            HotelRefundFaresSettings settings = new HotelRefundFaresSettings();
            settings.setRoomUid(el.getRoomUid());
            settings.setArrival(el.getArrival());
            settings.setDeparture(el.getDeparture());
            settings.setCurrency(el.getCurrency());
            settings.setEquivalentValue(el.getEquivalentValue());
            settings.setBaseValue(el.getBaseValue());
            Room room = (Room)roomsUid.get(el.getRoomUid());
            if (room != null && room.getBasePrice() != null && room.getEquivalentPrice() != null) {
                settings.setExchangeRate(room.getEquivalentPrice().divide(room.getBasePrice().getValue(), RoundingMode.HALF_UP));
            }
            return settings;
        }).collect(Collectors.toCollection(() -> ((HotelRefundSettings)params).getFares()));
        Map<String, HotelProductTax> taxUid = product.getTaxes().stream().collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        vm.getTaxes().stream().filter(el -> el.isCheck()).map(el -> {
            HotelProductTax tax = taxUid.getOrDefault(el.getTaxUid(), new HotelProductTax());
            tax.setUid(el.getTaxUid());
            tax.setCode(el.getCode());
            tax.setAmount(new Money());
            tax.getAmount().setCurrency(el.getCurrency());
            tax.getAmount().setValue(el.getSum());
            tax.setEquivalentAmount(el.getSum());
            return tax;
        }).collect(Collectors.toCollection(() -> ((HotelRefundSettings)params).getTaxes()));
        Map<String, Penalty> penaltiesUid = product.getPenalties().stream().collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        vm.getPenalties().stream().map(el -> {
            Penalty penalty = penaltiesUid.getOrDefault(el.getPenaltyUid(), new Penalty());
            penalty.setCode(el.getCode());
            penalty.setEquivalentAmount(el.getEqSum());
            penalty.setName(el.getName());
            return penalty;
        }).collect(Collectors.toCollection(() -> ((HotelRefundSettings)params).getPenalties()));
    }
}

