/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAppliedRulesDataViewVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAppliedRulesFullPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAppliedRulesFullPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpace;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractSpace;
import com.gridnine.xtrip.client.fx.standard.rules.FullRulesWidget;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.util.Pair;

public class BookingFileAppliedRulesControllerInterceptor
extends ControllerInterceptor<BookingFileAppliedRulesFullPanelVM, BookingFileAppliedRulesFullPanelController> {
    protected Class<BookingFileAppliedRulesFullPanelController> getControllerClass() {
        return BookingFileAppliedRulesFullPanelController.class;
    }

    protected void onCreate(BookingFileAppliedRulesFullPanelController controller) {
        DataViewWidget dataViewWidget = (DataViewWidget)controller.getView().getContent();
        dataViewWidget.getTableView().setActionHandler((TableActionHandler)new TableActionHandler<BookingFileAppliedRulesDataViewVM>(){

            public void onAction(TableColumn<BookingFileAppliedRulesDataViewVM, ?> column, BookingFileAppliedRulesDataViewVM item) {
                if ("contract".equals(column.getId())) {
                    RootEntityEditingService.navigateTo((EntityReference)item.getContractReference());
                    return;
                }
                if ("rulesContainer".equals(column.getId())) {
                    RootEntityEditingService.navigateTo((EntityReference)item.getRulesContainerReference());
                    return;
                }
                RootEntityEditingService service = RootEntityEditingService.get();
                if (service == null) {
                    return;
                }
                if (item.getRulesContainerReference() != null) {
                    service.open(item.getRulesContainerReference(), false, pane -> {
                        Node editor = pane.getEditor();
                        if (!(editor instanceof ModelContractSpace)) {
                            return;
                        }
                        ModelContractSpace space = (ModelContractSpace)editor;
                        space.expand(space.getRulesTile());
                        FullRulesWidget fullRulesWidget = (FullRulesWidget)space.getRulesTile().getFullNode();
                        fullRulesWidget.selectRule(item.getRuleUid());
                        fullRulesWidget.scrollToSelected();
                    });
                } else if (item.getContractReference() != null) {
                    service.open(item.getContractReference(), false, pane -> {
                        Node editor = pane.getEditor();
                        if (!(editor instanceof ContractSpace)) {
                            return;
                        }
                        ContractSpace space = (ContractSpace)editor;
                        space.expand(space.getRulesTile());
                        FullRulesWidget fullRulesWidget = (FullRulesWidget)space.getRulesTile().getFullNode();
                        fullRulesWidget.selectRule(item.getRuleUid());
                        fullRulesWidget.scrollToSelected();
                    });
                }
            }

            public boolean isActive(TableColumn<BookingFileAppliedRulesDataViewVM, ?> column, BookingFileAppliedRulesDataViewVM item) {
                return "contract".equals(column.getId()) && item != null && item.getContract() != null || "rulesContainer".equals(column.getId()) && item != null && item.getRulesContainer() != null;
            }
        });
    }

    protected void afterReadData(BookingFileAppliedRulesFullPanelController controller, final BookingFileAppliedRulesFullPanelVM model) {
        DataViewWidget dataViewWidget = (DataViewWidget)controller.getView().getContent();
        dataViewWidget.setHandler((DataViewHandler)new DataViewHandler<BookingFileAppliedRulesDataViewVM>(){

            protected int getLimit() {
                return Integer.MAX_VALUE;
            }

            protected int getOffset() {
                return 0;
            }

            protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
                this.getData().setAll((Collection)model.getContent());
            }
        });
        dataViewWidget.reloadData();
    }
}

