/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ActionColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.QueryDataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.PlainGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.BaseNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.NavigatorViewType;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.StandardCompactNavigatorWidgetCoordinator;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.HyperlinkWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ListItemStringConverter;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileDetailedServicesTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileGeneralParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMainFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileOrderDetailing;
import com.gridnine.xtrip.client.fx.model.booking.BookingFilePaymentsDataViewVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFilePaymentsDetails;
import com.gridnine.xtrip.client.fx.model.booking.BookingFilePaymentsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsOverviewPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullContainer;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullProductsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerGeneralPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelerPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelersPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelersPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileTravelersPanelVM;
import com.gridnine.xtrip.client.fx.model.system.RelatedDocumentsPanel;
import com.gridnine.xtrip.client.fx.standard.custom.ReservationViewTypeProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.OverviewTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.TravelersTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BookingFileTravelersTileAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BindingUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BookingFileSpaceControllerInterceptorHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileReservationsHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.BookingFileSpaceHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.DataViewWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.RelatedDocumentsConfiguration;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.fx.rpc.TransactionDataForBookingFile;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;

public class BookingFileSpaceControllerInterceptor
extends ControllerInterceptor<BookingFileSpaceVM, BookingFileSpaceController> {
    private static final String PRODUCT_CREATE_ACL = "product-create-acl";
    private static final String PRODUCT_DELETE_ACL = "product-delete-acl";
    private static final ListItemStringConverter<BookingFileTravelerPanel> TRAVELLER_CONVERTER = (view, index) -> {
        String result = null;
        if (view != null && !TextUtil.isBlank((String)((BookingFileTravelerGeneralPanel)view.getGeneralParametersCard().getContent()).getNameNode().getValue())) {
            result = ((BookingFileTravelerGeneralPanel)view.getGeneralParametersCard().getContent()).getNameNode().getValue();
        }
        if (TextUtil.isBlank(result)) {
            return Integer.toString(index + 1) + Messages.th_element;
        }
        return result;
    };
    private static final ListItemStringConverter<BookingFileReservationsFullContainer> RESERVATION_CONVERTER = (view, index) -> {
        String result = null;
        if (index >= 0) {
            String displayRecordLocator = BookingFileReservationsHelper.getDisplayRecordLocator(view);
            if (!TextUtil.isBlank((String)displayRecordLocator)) {
                result = displayRecordLocator;
            }
            if (result == null || result.isEmpty()) {
                return Integer.toString(index + 1) + Messages.th_element;
            }
        }
        return result;
    };
    private static final Comparator<TileAction<Node, BookingFileProductsFullPanel>> PRODUCT_ACTIONS_COMPARATOR = (action1, action2) -> Double.compare(action1.getWeight(), action2.getWeight());

    protected void onCreate(BookingFileSpaceController controller) {
        this.configureOverview(controller);
        BookingFileSpaceControllerInterceptor.configureTravellersTile(controller);
        BookingFileSpaceControllerInterceptor.configureReservationsTile(controller);
        BookingFileSpaceControllerInterceptor.configureProductsTile(controller);
        this.configurePaymentsTile(controller);
        this.configureTravelersPanel(controller);
        DataViewWidgetHelper.configureRelatedDocumentsTile((Tile<Node, RelatedDocumentsPanel>)controller.getView().getRelatedDocumentsTile(), () -> {
            RootEntityPane rep = RootEntityPane.lookup((Node)controller.getView());
            if (rep == null) {
                return null;
            }
            return rep.getData() == null || rep.getData().getContainer() == null ? null : rep.getData().getContainer().toReference();
        }, (ObservableValue<Boolean>)controller.getView().getRelatedDocumentsTile().expandedProperty(), new RelatedDocumentsConfiguration().setActionsVisible().setFiltersVisible().setSysLogVisible());
    }

    protected void afterReadData(BookingFileSpaceController controller, BookingFileSpaceVM model) {
        EntityContainer<BookingFile> ctr;
        if (controller.getView().getRelatedDocumentsTile().isExpanded() && BookingFileSpaceHelper.lookupBookingFileContainer((Node)controller.getView()) != null) {
            ((DataViewWidget)((RelatedDocumentsPanel)controller.getView().getRelatedDocumentsTile().getFullNode()).getDocumentsCard().getContent()).reloadData();
            ((DataViewWidget)((RelatedDocumentsPanel)controller.getView().getRelatedDocumentsTile().getFullNode()).getSystemLogCard().getContent()).reloadData();
        }
        if ((ctr = BookingFileSpaceHelper.lookupBookingFileContainer((Node)controller.getView())) != null) {
            BookingFileUIData supplement = (BookingFileUIData)Objects.requireNonNull(RootEntityPane.lookup((Node)controller.getView())).getData().getSupplement();
            ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode().getViewState().setNotEditable(supplement.getProducts().stream().anyMatch(BaseProductUIData::isHasClientRelatedShipment));
            ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientCell().setHelp(() -> new QuickHelp(Messages.BokingFileClientFieldDisableHelp));
        }
    }

    private void configureOverview(BookingFileSpaceController controller) {
        BigTableWidget tableWidget = ((BookingFileOrderDetailing)controller.getView().getOverviewNode().getOrderDetailingCard().getContent()).getDetailedServicesTableNode();
        tableWidget.getStyleClass().add((Object)"booking-overview-services-table");
        ActionColumn col = (ActionColumn)tableWidget.getColumn("navigate");
        col.setActionHandler(evt -> {
            CompactNavigatorWidget navigatorWidget = (CompactNavigatorWidget)((BookingFileProductsFullPanel)controller.getView().getProductsTile().getFullNode()).getContent();
            Node node = UiUtil.findViewWithModelUid((Iterable)navigatorWidget.getViews(), (String)((BookingFileDetailedServicesTableVM)evt.getItem()).getProductUid());
            if (node != null) {
                controller.getView().expand(controller.getView().getProductsTile());
                navigatorWidget.selectView(node);
            }
        });
    }

    private void configureTravelersPanel(BookingFileSpaceController controller) {
        Tile travelersTile = controller.getView().getTravelersTile();
        travelersTile.expandedProperty().addListener((obj, o, n) -> {
            if (n.booleanValue()) {
                travelersTile.getActions().setAll((Object[])new TileAction[]{new BookingFileTravelersTileAction()});
            } else {
                travelersTile.getActions().clear();
            }
        });
    }

    private void configurePaymentsTile(final BookingFileSpaceController controller) {
        ((BookingFilePaymentsFullPanel)controller.getView().getPaymentsTile().getFullNode()).getPaymentsCard().setAdaptiveHeight(true);
        final DataViewWidget widget = (DataViewWidget)((BookingFilePaymentsFullPanel)controller.getView().getPaymentsTile().getFullNode()).getPaymentsCard().getContent();
        final Supplier<EntityContainer> supplier = () -> {
            RootEntityPane rep = RootEntityPane.lookup((Node)controller.getView());
            if (rep == null) {
                return null;
            }
            return rep.getData() == null || rep.getData().getContainer() == null ? null : rep.getData().getContainer();
        };
        QueryDataViewHandler<BookingFilePaymentsDataViewVM> handler = new QueryDataViewHandler<BookingFilePaymentsDataViewVM>(){

            protected List<BookingFilePaymentsDataViewVM> executeQuery(SearchQuery query) throws Exception {
                ValueHolder containerHolder = new ValueHolder();
                FxUtil.waitForFxThread(() -> 1.lambda$executeQuery$0(containerHolder, (Supplier)supplier));
                if (containerHolder.get() == null) {
                    return Collections.emptyList();
                }
                ArrayList<BookingFilePaymentsDataViewVM> result = new ArrayList<BookingFilePaymentsDataViewVM>();
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityContainer ctr = (EntityContainer)containerHolder.get();
                FinanceService financeService = (FinanceService)RpcServiceManager.get().getService(FinanceService.class);
                MiscUtil.Pair financeServiceResult = financeService.loadTransactionForBookingFile(sic, ctr.toReference());
                List transactionData = (List)financeServiceResult.getFirst();
                FxUtil.waitForFxThread(() -> {
                    ((BookingFilePaymentsDetails)((BookingFilePaymentsFullPanel)((BookingFileSpace)RootEntityPane.lookup((Node)controller.getView()).getEditor()).getPaymentsTile().getFullNode()).getMainCard().getContent()).getHoldPaymentNode().setValue((Number)financeServiceResult.getSecond());
                    transactionData.forEach(transaction -> {
                        BookingFileDetailedServicesTableVM detailesVM;
                        BookingFileSpaceControllerInterceptor.this.configureColumns((DataViewWidget<BookingFilePaymentsDataViewVM>)widget, (TransactionDataForBookingFile)transaction);
                        BookingFilePaymentsDataViewVM dataViewVM = new BookingFilePaymentsDataViewVM();
                        BookingFileDetailedServicesTableVM bookingFileDetailedServicesTableVM = detailesVM = controller.getOverview().getOrderDetailing().getData() != null ? (BookingFileDetailedServicesTableVM)controller.getOverview().getOrderDetailing().getData().getDetailedServicesTable().stream().filter(element -> element.getProductUid().equals(transaction.getProductUid())).findFirst().orElse(null) : null;
                        if (detailesVM != null) {
                            dataViewVM.setNameProduct(detailesVM.getName());
                        }
                        dataViewVM.setOrganization(transaction.getAgencyRef().getCaption());
                        if (transaction.getDimensionValue1() != null) {
                            BookingFileSpaceControllerInterceptor.this.fillingDataViewVM(transaction.getDimensionType1(), dataViewVM, transaction.getDimensionValue1().toString());
                        }
                        if (transaction.getDimensionValue2() != null) {
                            BookingFileSpaceControllerInterceptor.this.fillingDataViewVM(transaction.getDimensionType2(), dataViewVM, transaction.getDimensionValue2().toString());
                        }
                        if (transaction.getDimensionValue3() != null) {
                            BookingFileSpaceControllerInterceptor.this.fillingDataViewVM(transaction.getDimensionType3(), dataViewVM, transaction.getDimensionValue3().toString());
                        }
                        dataViewVM.setStatus(transaction.getStatus().toString());
                        if (transaction.isCredit()) {
                            dataViewVM.setCreditAmount((String)StandardRenderers.PRICE.apply((Object)transaction.getTransactionSum()));
                        } else {
                            dataViewVM.setDebitAmount((String)StandardRenderers.PRICE.apply((Object)transaction.getTransactionSum()));
                        }
                        dataViewVM.setDescription(transaction.getDescription());
                        if (transaction.getTransactionDate() != null) {
                            dataViewVM.setDate((String)StandardRenderers.DATE.apply((Object)transaction.getTransactionDate()));
                        }
                        result.add(dataViewVM);
                    });
                });
                return result;
            }

            private static /* synthetic */ void lambda$executeQuery$0(ValueHolder containerHolder, Supplier supplier2) throws Exception {
                containerHolder.set(supplier2.get());
            }
        };
        handler.setQuery(new SearchQuery());
        widget.getTableView().setActionHandler((TableActionHandler)new TableActionHandler<BookingFilePaymentsDataViewVM>(){

            public void onAction(TableColumn<BookingFilePaymentsDataViewVM, ?> column, BookingFilePaymentsDataViewVM item) {
                RootEntityEditingService.navigateTo((EntityReference)item.getReference());
            }

            public boolean isActive(TableColumn<BookingFilePaymentsDataViewVM, ?> column, BookingFilePaymentsDataViewVM item) {
                return false;
            }
        });
        widget.setDefaultActionHandler(() -> {
            BookingFilePaymentsDataViewVM selected = (BookingFilePaymentsDataViewVM)widget.getTableView().getSelectionModel().getSelectedItem();
            if (selected != null) {
                RootEntityEditingService.navigateTo((EntityReference)selected.getReference());
            }
        });
        widget.setHandler((DataViewHandler)handler);
        ReadOnlyBooleanProperty expanded = controller.getView().getPaymentsTile().expandedProperty();
        if (expanded != null) {
            FxUtil.addListener((ObservableValue)expanded, (obj, o, n) -> {
                if (n.booleanValue() && !widget.isDataLoaded()) {
                    widget.reloadData();
                }
            });
        }
    }

    void fillingDataViewVM(DimensionType dimensionType, BookingFilePaymentsDataViewVM dataViewVM, String value) {
        switch (dimensionType) {
            case PAYMENT_TYPE: {
                dataViewVM.setPaymentTypeDem1(value);
                break;
            }
            case CONTRACT_TYPE: {
                dataViewVM.setContractTypeDem2(value);
                break;
            }
            case ORGANIZATION: {
                dataViewVM.setOrganizationDem3(value);
                break;
            }
            case SALES_POINT: {
                dataViewVM.setSalesPointDem4(value);
                break;
            }
            case AGENT: {
                dataViewVM.setAgentDem5(value);
                break;
            }
            case CASH: {
                dataViewVM.setCashDem6(value);
                break;
            }
            case CASH_REGISTER: {
                dataViewVM.setCashRegisterDem7(value);
                break;
            }
            case CASH_REGISTER_WORKPLACE: {
                dataViewVM.setCashRegisterWorkplaceDem8(value);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)String.format("For dimension type: %s, not found view", dimensionType), (Object[])new Object[0]);
            }
        }
    }

    void configureColumns(DataViewWidget<BookingFilePaymentsDataViewVM> widget, TransactionDataForBookingFile transaction) {
        int id;
        ((TableColumn)widget.getTableView().getColumns().get(2)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(3)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(4)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(5)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(6)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(7)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(8)).setVisible(false);
        ((TableColumn)widget.getTableView().getColumns().get(9)).setVisible(false);
        if (transaction.getDimensionType1() != null) {
            id = this.getNumberColumns(transaction.getDimensionType1());
            ((TableColumn)widget.getTableView().getColumns().get(id)).setVisible(true);
        }
        if (transaction.getDimensionType2() != null) {
            id = this.getNumberColumns(transaction.getDimensionType2());
            ((TableColumn)widget.getTableView().getColumns().get(id)).setVisible(true);
        }
        if (transaction.getDimensionType3() != null) {
            id = this.getNumberColumns(transaction.getDimensionType3());
            ((TableColumn)widget.getTableView().getColumns().get(id)).setVisible(true);
        }
        widget.getTableView().setColumnResizePolicy(CustomTableView.getConstrainedResizePolicy());
    }

    private int getNumberColumns(DimensionType dimensionType) {
        switch (dimensionType) {
            case PAYMENT_TYPE: {
                return 2;
            }
            case CONTRACT_TYPE: {
                return 3;
            }
            case ORGANIZATION: {
                return 4;
            }
            case SALES_POINT: {
                return 5;
            }
            case AGENT: {
                return 6;
            }
            case CASH: {
                return 7;
            }
            case CASH_REGISTER: {
                return 8;
            }
            case CASH_REGISTER_WORKPLACE: {
                return 9;
            }
        }
        throw Xeption.forDeveloper((String)String.format("For dimension type: %s, not found view", dimensionType), (Object[])new Object[0]);
    }

    private static void configureReservationsTile(BookingFileSpaceController controller) {
        ((PlainGroupsWidget)((BookingFileReservationsFullPanel)controller.getView().getReservationsTile().getFullNode()).getContent()).setConverter(RESERVATION_CONVERTER);
        ((PlainGroupsWidget)((BookingFileReservationsFullPanel)controller.getView().getReservationsTile().getFullNode()).getContent()).getViews().addListener(change -> {
            while (change.next()) {
                for (BookingFileReservationsFullContainer view : change.getAddedSubList()) {
                    BookingFileSpaceControllerInterceptor.configureReservationPane(view, controller);
                }
            }
        });
    }

    private static void configureReservationPane(BookingFileReservationsFullContainer view, BookingFileSpaceController controller) {
        TableWidget productTableWidget = (TableWidget)view.getProductsCard().getContent();
        HyperlinkWidgetColumn productHyperlinkWidgetColumn = (HyperlinkWidgetColumn)productTableWidget.getColumn("product");
        IntStream.range(0, productTableWidget.getRowsCount()).forEach(index -> {
            HyperlinkWidget hyperlinkWidget = (HyperlinkWidget)productHyperlinkWidgetColumn.getWidget(index);
            String productUid = ((BookingFileReservationsFullProductsVM)productTableWidget.getData(index)).getProductUID();
            CompactNavigatorWidget navigatorWidget = (CompactNavigatorWidget)((BookingFileProductsFullPanel)controller.getView().getProductsTile().getFullNode()).getContent();
            hyperlinkWidget.setOnAction(event -> {
                Node node = UiUtil.findViewWithModelUid((Iterable)navigatorWidget.getViews(), (String)productUid);
                if (node != null) {
                    controller.getView().expand(controller.getView().getProductsTile());
                    navigatorWidget.selectView(node);
                }
            });
        });
    }

    private static void configureProductsTile(final BookingFileSpaceController controller) {
        BookingFileSpace bookingFileSpace = controller.getView();
        Tile productsTile = bookingFileSpace.getProductsTile();
        final CompactNavigatorWidget navigatorWidget = (CompactNavigatorWidget)((BookingFileProductsFullPanel)productsTile.getFullNode()).getContent();
        navigatorWidget.setNavigationTooltip(Messages.ProductsNavigator_NavigatorTooltip);
        navigatorWidget.setControlButtonTooltips(bt -> {
            switch (bt) {
                case PREV: {
                    return Messages.ProductsNavigator_Prev;
                }
                case NEXT: {
                    return Messages.ProductsNavigator_Next;
                }
                case REMOVE: {
                    return Messages.ProductsNavigator_Remove;
                }
                case ADD: {
                    return Messages.ProductsNavigator_Add;
                }
            }
            return null;
        });
        productsTile.expandedProperty().addListener((obj, o, n) -> {
            BookingFileSpaceControllerInterceptor.updateProductTileActions((Tile<Node, BookingFileProductsFullPanel>)productsTile);
            if (!n.booleanValue()) {
                ((BookingFileProductsOverviewPanel)controller.getView().getOverviewNode().getOverviewPanelCard().getContent()).getProductsCountNode().setValue((Number)navigatorWidget.getViews().size());
            }
        });
        ((CompactNavigatorWidget)((BookingFileProductsFullPanel)productsTile.getFullNode()).getContent()).selectedElementProperty().addListener((obj, o, n) -> BookingFileSpaceControllerInterceptor.updateProductTileActions((Tile<Node, BookingFileProductsFullPanel>)productsTile));
        navigatorWidget.setConverter((node, idx) -> ((BaseProductVM)ViewController.forView((Node)node).getData()).getProductFullNameWithSpaces());
        navigatorWidget.setViewTypeProvider((Consumer)((Object)new ReservationViewTypeProvider((BaseNavigatorWidget)navigatorWidget){

            protected List<NavigatorViewType> getTypes() {
                Optional.ofNullable(navigatorWidget.getSelectedView()).ifPresent(selectedView -> selectedView.getProperties().put((Object)"select-product", (Object)true));
                return ClientRegistry.get().allOf(ProductFXHandler.TYPE).values().stream().flatMap(item -> BookingFileSpaceControllerInterceptorHelper.createViewType(controller, item).stream()).collect(Collectors.toList());
            }
        }));
        navigatorWidget.setControlButtonsCoordinator((BiPredicate)new StandardCompactNavigatorWidgetCoordinator(navigatorWidget){

            public boolean test(ControlsPane.ButtonType buttonType, Node item) {
                BaseProduct product;
                if (buttonType == ControlsPane.ButtonType.ADD && navigatorWidget.getProperties().get((Object)BookingFileSpaceControllerInterceptor.PRODUCT_CREATE_ACL) != null && !((Boolean)navigatorWidget.getProperties().get((Object)BookingFileSpaceControllerInterceptor.PRODUCT_CREATE_ACL)).booleanValue()) {
                    return false;
                }
                if (buttonType == ControlsPane.ButtonType.REMOVE && (product = BookingFileSpaceControllerInterceptor.getProduct(item, controller)) != null) {
                    String key = AclHelper.createPermission((String)product.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE);
                    if (navigatorWidget.getProperties().get((Object)BookingFileSpaceControllerInterceptor.PRODUCT_DELETE_ACL) != null && ((Map)navigatorWidget.getProperties().get((Object)BookingFileSpaceControllerInterceptor.PRODUCT_DELETE_ACL)).get(key) != null && !((Boolean)((Map)navigatorWidget.getProperties().get((Object)BookingFileSpaceControllerInterceptor.PRODUCT_DELETE_ACL)).get(key)).booleanValue()) {
                        return false;
                    }
                    ProductFXHandler<BaseProduct, ?, ?, ?> handler = ProductFXHandler.forProduct(product);
                    if (!handler.isDeletable(product)) {
                        return false;
                    }
                }
                return super.test(buttonType, item);
            }
        });
        navigatorWidget.setCallbackOnDelete(item -> {
            BaseProduct baseProduct = BookingFileSpaceControllerInterceptor.getProduct(item, controller);
            if (baseProduct != null) {
                ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler = ProductFXHandler.forProduct(baseProduct);
                if (productFXHandler != null) {
                    if (productFXHandler.getNextProduct(baseProduct) == null) {
                        List<BaseProduct> productsToDelete = BookingFileSpaceControllerInterceptor.getProductsToDelete(controller, baseProduct, productFXHandler);
                        BookingFileSpaceControllerInterceptor.removeProducts(controller, productsToDelete);
                        BookingFileSpaceControllerInterceptor.removeRelatedViews(navigatorWidget, productsToDelete);
                    } else {
                        Notifications.get().showFlashNotification(Messages.First_remove, null);
                    }
                }
            } else {
                navigatorWidget.getViews().remove(item);
            }
        });
        navigatorWidget.getViews().addListener(change -> {
            while (change.next()) {
                for (Node view : change.getAddedSubList()) {
                    BindingUtil.configureProductView(view, controller);
                }
            }
        });
        navigatorWidget.setEmptyPaneControlButtonsCoordinator(buttonType -> buttonType != ControlsPane.ButtonType.ADD || navigatorWidget.getProperties().get((Object)PRODUCT_CREATE_ACL) == null || (Boolean)navigatorWidget.getProperties().get((Object)PRODUCT_CREATE_ACL) != false);
    }

    private static void updateProductTileActions(Tile<Node, BookingFileProductsFullPanel> productsTile) {
        Node selectedView = ((CompactNavigatorWidget)((BookingFileProductsFullPanel)productsTile.getFullNode()).getContent()).getSelectedView();
        if (selectedView == null || !productsTile.isExpanded()) {
            productsTile.getActions().clear();
            return;
        }
        ArrayList<TileAction<Node, BookingFileProductsFullPanel>> actions = new ArrayList<TileAction<Node, BookingFileProductsFullPanel>>();
        for (ProductActionsProvider provider : ClientRegistry.get().allOf(ProductActionsProvider.TYPE).values()) {
            if (!provider.isApplicableTo(selectedView)) continue;
            actions.addAll(provider.getAvailableActions());
        }
        actions.sort(PRODUCT_ACTIONS_COMPARATOR);
        productsTile.getActions().setAll(actions);
    }

    private static void removeProducts(BookingFileSpaceController controller, List<BaseProduct> productsToDelete) {
        productsToDelete.forEach(baseProduct -> baseProduct.getReservation().getProducts().remove(baseProduct));
        EntityContainer<BookingFile> ctr = BookingFileSpaceHelper.lookupBookingFileContainer((Node)controller.getView());
        productsToDelete.forEach(baseProduct -> {
            ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler = ProductFXHandler.forProduct(baseProduct);
            productFXHandler.remove((BaseProduct)baseProduct);
            if (ctr != null) {
                BookingFileSpaceControllerInterceptor.removeProductFromOtherProductsRelations((BookingFile)ctr.getEntity(), baseProduct);
            }
        });
        if (ctr == null) {
            return;
        }
        ((BookingFile)ctr.getEntity()).getReservations().stream().filter(reservation -> reservation.getProducts().isEmpty()).collect(Collectors.toList()).forEach(emptyReservation -> ((BookingFile)ctr.getEntity()).getReservations().remove(emptyReservation));
    }

    private static void removeProductFromOtherProductsRelations(BookingFile bookingFile, BaseProduct baseProduct) {
        bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).forEach(product -> {
            ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler = ProductFXHandler.forProduct(product);
            if (productFXHandler != null) {
                productFXHandler.removeRelatedProduct((BaseProduct)product, baseProduct);
            }
        });
    }

    static BaseProduct getProduct(Node item, BookingFileSpaceController controller) {
        if (item == null) {
            return null;
        }
        EntityContainer<BookingFile> bookingFileContainer = BookingFileSpaceHelper.lookupBookingFileContainer((Node)controller.getView());
        if (bookingFileContainer == null) {
            return null;
        }
        return ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> TextUtil.isSame((String)product.getUid(), (String)((String)item.getProperties().get((Object)"model-uid")))).findFirst().orElse(null);
    }

    private static void removeRelatedViews(CompactNavigatorWidget productsWidget, List<BaseProduct> deletedProductList) {
        Map<String, Node> viewUID = productsWidget.getViews().stream().collect(Collectors.toMap(el -> (String)el.getProperties().get((Object)"model-uid"), el -> el));
        deletedProductList.forEach(pr -> {
            Node view = viewUID.getOrDefault(pr.getUid(), null);
            if (view != null) {
                productsWidget.getViews().remove((Object)view);
            }
        });
    }

    private static List<BaseProduct> getProductsToDelete(BookingFileSpaceController controller, BaseProduct baseProduct, ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        result.add(baseProduct);
        result.add(BookingFileSpaceControllerInterceptor.getPreviousProductToDelete(baseProduct, productFXHandler));
        EntityContainer<BookingFile> ctr = BookingFileSpaceHelper.lookupBookingFileContainer((Node)controller.getView());
        if (ctr != null) {
            result.addAll(BookingFileSpaceControllerInterceptor.getRelatedProductsToDelete(baseProduct, (BookingFile)ctr.getEntity()));
        }
        return result.stream().filter(product -> !Objects.isNull(product)).collect(Collectors.toList());
    }

    private static BaseProduct getPreviousProductToDelete(BaseProduct baseProduct, ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler) {
        BaseProduct previousProduct = productFXHandler.getPreviousProduct(baseProduct);
        return previousProduct != null && ProductStatus.EXCHANGE.equals((Object)productFXHandler.getProductStatus(previousProduct)) ? previousProduct : null;
    }

    private static List<BaseProduct> getRelatedProductsToDelete(BaseProduct baseProduct, BookingFile bookingFile) {
        return bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(potentialMCOProduct -> {
            ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler = ProductFXHandler.forProduct(potentialMCOProduct);
            List<BaseProduct> relatedProducts = productFXHandler.getRelatedProducts((BaseProduct)potentialMCOProduct);
            return productFXHandler.isEMDOrExcessBagage((BaseProduct)potentialMCOProduct) && relatedProducts.contains(baseProduct) && productFXHandler.getNextProduct((BaseProduct)potentialMCOProduct) == null && relatedProducts.size() == 1;
        }).collect(Collectors.toList());
    }

    private static void configureTravellersTile(BookingFileSpaceController controller) {
        Tile travelersTile = controller.getView().getTravelersTile();
        BookingFileTravelersPanel travelersPanel = (BookingFileTravelersPanel)travelersTile.getFullNode();
        ((PlainGroupsWidget)travelersPanel.getContent()).setConverter(TRAVELLER_CONVERTER);
        ((PlainGroupsWidget)travelersPanel.getContent()).getViews().addListener(c -> {
            c.next();
            List addedSubList = c.getAddedSubList();
            addedSubList.forEach(panel -> {
                GridCell travellerCell = ((BookingFileTravelerGeneralPanel)panel.getGeneralParametersCard().getContent()).getTravellerCell();
                ComboBoxWidget travellerNode = ((BookingFileTravelerGeneralPanel)panel.getGeneralParametersCard().getContent()).getTravellerNode();
                travellerCell.setHidden(true);
                if (travellerNode.getValue() == null) {
                    Traveller traveller = new Traveller();
                    travellerNode.setValue((Object)traveller);
                    panel.getProperties().put((Object)"model-uid", (Object)traveller.getUid());
                }
            });
        });
        travelersTile.expandedProperty().addListener((obj, o, n) -> {
            if (n != null && n.booleanValue()) {
                return;
            }
            BookingFileTravelersPanelVM travelersPanelVM = new BookingFileTravelersPanelVM();
            BookingFileTravelersPanelController tmpController = new BookingFileTravelersPanelController(travelersPanel, true);
            tmpController.writeData(travelersPanelVM);
            BookingFile tmpBooking = new BookingFile();
            TravelersTileHelper.fromVM(travelersPanelVM, tmpBooking);
            ((BookingFileProductsOverviewPanel)controller.getView().getOverviewNode().getOverviewPanelCard().getContent()).getTravellersCountNode().setValue((Number)OverviewTileHelper.calcUniqueTravellersCount(tmpBooking.getTravellers()));
        });
    }

    protected Class<BookingFileSpaceController> getControllerClass() {
        return BookingFileSpaceController.class;
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileSpaceController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        EntityContainer bookingFileContainer = ((DataTransferPackage)rootController.getData()).getContainer();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        boolean bookingEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)bookingFile.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.setAclNotEditable(!bookingEditGranted);
        String clientUid = AclHelper.createCompoundId((String)bookingFile.getUid(), (String)ModelRestrictionEntityResources.ENTITY_BOOKING_FILE_CLIENT.getId());
        boolean clientViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)clientUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean clientEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)clientUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientCell().setHidden(!clientViewGranted);
        ((BookingFileProductsOverviewPanel)controller.getView().getOverviewNode().getOverviewPanelCard().getContent()).getClientCell().setHidden(!clientViewGranted);
        ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)controller.getView().getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode().getViewState().setAclNotEditable(!clientEditGranted);
        ((CompactNavigatorWidget)((BookingFileProductsFullPanel)controller.getView().getProductsTile().getFullNode()).getContent()).getProperties().put((Object)PRODUCT_CREATE_ACL, (Object)(!deniedPermissions.contains(AclHelper.createPermission((String)ModelRestrictionEntityResources.ENTITY_PRODUCT.getId(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.CREATE)) ? 1 : 0));
        HashMap productDeleteAclData = (HashMap)((CompactNavigatorWidget)((BookingFileProductsFullPanel)controller.getView().getProductsTile().getFullNode()).getContent()).getProperties().computeIfAbsent((Object)PRODUCT_DELETE_ACL, key -> new HashMap());
        productDeleteAclData.clear();
        for (BaseProduct product : bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).collect(Collectors.toList())) {
            String key2 = AclHelper.createPermission((String)product.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE);
            productDeleteAclData.put(key2, !deniedPermissions.contains(AclHelper.createPermission((String)product.getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE)));
        }
        ((CompactNavigatorWidget)((BookingFileProductsFullPanel)controller.getView().getProductsTile().getFullNode()).getContent()).revalidateEmptyPaneControlButtons();
        ((CompactNavigatorWidget)((BookingFileProductsFullPanel)controller.getView().getProductsTile().getFullNode()).getContent()).revalidateControlButtons();
    }
}

