/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.additionalservice;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.HyperlinkWidgetColumn;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServicePanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServicePanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServicePanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceParametersOwner;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAdditionalServiceRelatedProductsTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.AddProductsDialog;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BindingUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.BookingFileSpaceHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class BookingFileProductAdditionalServicePanelControllerInterceptor
extends ControllerInterceptor<BookingFileProductAdditionalServicePanelVM, BookingFileProductAdditionalServicePanelController> {
    private static final String ACCESS_DENIED_CELL_ID = "access-denied-cell";

    protected Class<BookingFileProductAdditionalServicePanelController> getControllerClass() {
        return BookingFileProductAdditionalServicePanelController.class;
    }

    protected void beforeWriteData(BookingFileProductAdditionalServicePanelController controller, BookingFileProductAdditionalServicePanelVM model) {
        model.setProductType(AdditionalServiceProduct.class);
    }

    protected void onCreate(BookingFileProductAdditionalServicePanelController controller) {
        super.onCreate((ViewController)controller);
        BookingFileProductAdditionalServicePanel view = controller.getView();
        view.getStatusesNode().getCheckedNode().setConverter(Converters.boolConverter((String)Messages.Checked, (String)Messages.Unchecked));
        view.getStatusesNode().getFinishedNode().setConverter(Converters.boolConverter((String)Messages.Finished, (String)Messages.Not_finished));
        view.getStatusesNode().getHasErrorsNode().setConverter(Converters.boolConverter((String)Messages.Has_errors, (String)Messages.Has_not_errors));
        view.getStatusesNode().getHasWarningsNode().setConverter(Converters.boolConverter((String)Messages.Has_warnings, (String)Messages.Has_not_warnings));
        view.getStatusesNode().getRulesAppliedNode().setConverter(Converters.boolConverter((String)Messages.Rules_applied, (String)Messages.Rules_not_applied));
        BindingUtil.addYearValidationListener(view.getGeneralNode().getBaseInformationParametersNode().getOperationDateValueNode());
        GeneralProductFXHelper.configureStatusWidget(view.getGeneralNode().getBaseInformationParametersNode().getStatusValueNode(), () -> ((BookingFileProductAdditionalServicePanelController)controller).getData());
        BookingFileProductAdditionalServiceParametersOwner ownerNode = view.getGeneralNode().getOwnerParametersNode();
        ownerNode.getAgencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ownerNode.getSubagencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ownerNode.getAgentValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgents);
        if (!Prefetched.getData().isFindocsEnabled()) {
            ownerNode.getShipmentsDateCaptionCell().setHidden(true);
            ownerNode.getShipmentsDateValueCell().setHidden(true);
        }
        TableWidget productTableWidget = view.getRelatedProductsNode().getRelatedTicketsNode();
        productTableWidget.setItemsProvider(this.createItemsProvider(controller, null));
        this.setOnRowsAction((TableWidget<BookingFileProductAdditionalServiceRelatedProductsTableVM>)productTableWidget);
        view.getGeneralNode().getBaseInformationParametersNode().getTicketTypeValueNode().valueProperty().addListener((s, o, n) -> {
            view.getGeneralNode().getBaseInformationParametersNode().getCorrectionDateCaptionCell().setHidden(n != TicketType.CORRECTION);
            view.getGeneralNode().getBaseInformationParametersNode().getCorrectionDateValueCell().setHidden(n != TicketType.CORRECTION);
        });
    }

    private void setOnRowsAction(TableWidget<BookingFileProductAdditionalServiceRelatedProductsTableVM> productTableWidget) {
        productTableWidget.setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int idx = event.getRowIndex();
                BookingFileProductAdditionalServicePanelControllerInterceptor.setActionLink(productTableWidget, idx);
            }
        });
    }

    private static void setActionLink(TableWidget<BookingFileProductAdditionalServiceRelatedProductsTableVM> productTableWidget, int ind) {
        HyperlinkWidgetColumn productHyperlinkWidgetColumn = (HyperlinkWidgetColumn)productTableWidget.getColumn("product");
        HyperlinkWidget hyperlinkWidget = (HyperlinkWidget)productHyperlinkWidgetColumn.getWidget(ind);
        String productUID = ((BookingFileProductAdditionalServiceRelatedProductsTableVM)productTableWidget.getData(ind)).getProductUID();
        hyperlinkWidget.setOnAction(evt -> {
            BookingFileSpace bookingFileSpace = BookingFileSpaceHelper.lookupBookingFileSpace((Node)productTableWidget);
            CompactNavigatorWidget widget = (CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingFileSpace.getProductsTile().getFullNode()).getContent();
            Node node = UiUtil.findViewWithModelUid((Iterable)widget.getViews(), (String)productUID);
            if (node != null) {
                widget.selectView(node);
            }
        });
    }

    private MultiProvider<BookingFileProductAdditionalServiceRelatedProductsTableVM> createItemsProvider(final BookingFileProductAdditionalServicePanelController controller, final BookingFileProductAdditionalServiceRelatedProductsTableVM model) {
        return new MultiProvider<BookingFileProductAdditionalServiceRelatedProductsTableVM>(){

            public BookingFileProductAdditionalServiceRelatedProductsTableVM createOne() {
                return new BookingFileProductAdditionalServiceRelatedProductsTableVM();
            }

            public void createAny(Consumer<Collection<BookingFileProductAdditionalServiceRelatedProductsTableVM>> consumer) {
                ArrayList alreadySelected = new ArrayList();
                controller.getRelatedProducts().getRelatedTickets().writeData(alreadySelected);
                ArrayList<String> usedUids = new ArrayList<String>();
                if (model != null) {
                    usedUids.add(model.getProductUID());
                }
                usedUids.addAll(alreadySelected.stream().map(BookingFileProductAdditionalServiceRelatedProductsTableVM::getProductUID).collect(Collectors.toList()));
                RootEntityPane rootEntityPane = Objects.requireNonNull(RootEntityPane.lookup((Node)controller.getView()));
                BookingFile bookingFile = (BookingFile)rootEntityPane.getData().getContainer().getEntity();
                List<Product> products = bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(p -> !usedUids.contains(p.getUid()) && p instanceof Product).map(bp -> (Product)bp).collect(Collectors.toList());
                AddProductsDialog dialog = new AddProductsDialog(rootEntityPane.getEditor(), products);
                dialog.showDialog(() -> {
                    List rows = dialog.getSelectedProducts().stream().map(selectedProduct -> {
                        Product product = (Product)bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(arg_0 -> ((Product)selectedProduct).equals(arg_0)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)("Unknown product with uid " + selectedProduct.getUid()), (Object[])new Object[0]));
                        BookingFileProductAdditionalServiceRelatedProductsTableVM productVM = new BookingFileProductAdditionalServiceRelatedProductsTableVM();
                        productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)product));
                        productVM.setProductUID(product.getUid());
                        return productVM;
                    }).collect(Collectors.toList());
                    consumer.accept(rows);
                });
            }
        };
    }

    protected void afterReadData(BookingFileProductAdditionalServicePanelController controller, BookingFileProductAdditionalServicePanelVM model) {
        Optional<BaseProductUIData> productUIData = Optional.ofNullable(model.getProductUiData());
        controller.getView().getGeneralNode().getOwnerParametersNode().getAgencyValueNode().getViewState().setNotEditable(productUIData.map(BaseProductUIData::isHasSubagentRelatedShipment).orElse(false).booleanValue());
        controller.getView().getGeneralNode().getOwnerParametersNode().getSubagencyValueNode().getViewState().setNotEditable(productUIData.map(productData -> productData.isHasClientRelatedShipment() || productData.isHasSubagentRelatedShipment()).orElse(false).booleanValue());
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileProductAdditionalServicePanelController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        GridCell accessDeniedCell;
        boolean editGranted;
        String uid = controller.getView().getProperties().get((Object)"model-uid").toString();
        boolean viewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean bl = editGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        if (!viewGranted) {
            for (GridCell cells : controller.getView().getCells()) {
                cells.setHidden(true);
            }
        }
        if ((accessDeniedCell = (GridCell)controller.getView().getCells().stream().filter(item -> TextUtil.isSame((String)item.getPayload().getId(), (String)ACCESS_DENIED_CELL_ID)).findFirst().orElse(null)) != null) {
            controller.getView().getCells().remove((Object)accessDeniedCell);
        }
        if (!viewGranted) {
            Node node = ContentError.ACCESS_DENIED.createNode(String.format("<p>Entity UID: <code>%s</code></p>", uid));
            node.setId(ACCESS_DENIED_CELL_ID);
            accessDeniedCell = new GridCell(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Access_denied1, node);
            controller.getView().getCells().add((Object)accessDeniedCell);
        }
        controller.setAclNotEditable(!editGranted);
        String productSalesPointUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SALES_POINT.getId());
        boolean productSalesPointViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSalesPointEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getSalesPointCaptionCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSalesPointValueCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSalesPointValueNode().getViewState().setAclNotEditable(!productSalesPointEditGranted);
        String productAgentUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId());
        boolean productAgentViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productAgentEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getAgentCaptionCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getAgentValueCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getAgentValueNode().getViewState().setAclNotEditable(!productAgentEditGranted);
        String productSubagencyUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENCY.getId());
        boolean productSubagencyViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSubagencyEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getSubagencyCaptionCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSubagencyValueCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getOwnerParameters().getView().getSubagencyValueNode().getViewState().setAclNotEditable(!productSubagencyEditGranted);
        String productClientShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId());
        boolean productClientShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productClientShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getShipmentsDateValueNode().getViewState().setAclNotEditable(!productClientShipmentsDateEditGranted);
        String productSubagentShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId());
        boolean productSubagentShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagentShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getOwnerParameters().getView().getShipmentsDateSubagentValueNode().getViewState().setAclNotEditable(!productSubagentShipmentsDateEditGranted);
    }
}

