/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.avia;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.DictBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAirSegmentVM;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictQueryPseudoProperties;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class BookingFileProductSegmentsHelper {
    private static final List<CodeSystem> CODE_SYSTEMS = Arrays.asList(CodeSystem.IATA, CodeSystem.ISO, CodeSystem.CRT);
    private static final Supplier<DictListParameters> AIRPORTS_LIST_PARAMS_SUPPLIER = () -> {
        DictListParameters params = new DictListParameters();
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.type.name(), Messages.Point_type, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.country.name(), Messages.Country, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.parent.name(), Messages.Affiliation, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.timeZoneId.name(), Messages.Timezone, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, BaseDictionary.Property.code.name(), Messages.ID, (Renderer)StandardRenderers.GENERIC));
        TableColumnSettings col = new TableColumnSettings();
        col.setId(DictQueryPseudoProperties.CODE_SYSTEM);
        col.setType(CodeSystem.class.getName());
        col.setDisplayName(Messages.Code_system);
        params.getFilters().add(col);
        params.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, BaseDictionary.Property.codeVariants.name(), Messages.Code, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.type.name(), Messages.Point_type, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.country.name(), Messages.Country, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.parent.name(), Messages.Affiliation, (Renderer)StandardRenderers.GENERIC));
        params.getSortings().put(BaseDictionary.Property.translations.name(), SortOrder.ASC);
        params.getSearchCriterions().add(new DictQuery.SearchCriterion(GeoLocation.Property.type.name(), new Object[]{LocationType.AIRPORT}));
        return params;
    };
    private static final Function<DictItem<GeoLocation>, DictionaryReference<GeoLocation>> GEO_LOCATION_REF_BUILDER = dictItem -> {
        DictionaryReference result = dictItem.getReference();
        String code = BookingFileProductSegmentsHelper.getCode((Map)dictItem.getFields().get(BaseDictionary.Property.codeVariants.name()));
        if (code != null) {
            DictionaryReference country;
            String caption = code;
            DictionaryReference parent = (DictionaryReference)dictItem.getFields().get(GeoLocation.Property.parent.name());
            if (parent != null) {
                caption = caption + ',' + parent.getCode();
            }
            if ((country = (DictionaryReference)dictItem.getFields().get(GeoLocation.Property.country.name())) != null) {
                caption = caption + ',' + country.getCode();
            }
            result.setCaption(caption);
        }
        return result;
    };
    private static final Function<DictItem<Airline>, DictionaryReference<Airline>> AIRLINE_REF_BUILDER = dictItem -> {
        String codes;
        DictionaryReference result = dictItem.getReference();
        Map codeVariants = (Map)dictItem.getFields().get(BaseDictionary.Property.codeVariants.name());
        if (codeVariants != null && !TextUtil.isBlank((String)(codes = CODE_SYSTEMS.stream().map(cs -> (String)codeVariants.get(cs.name())).filter(code -> !TextUtil.isBlank((String)code)).collect(Collectors.joining(","))))) {
            result.setCaption(codes);
        }
        return result;
    };

    private static String getCode(Map<String, String> codeVariants) {
        if (codeVariants == null) {
            return null;
        }
        for (CodeSystem sys : CODE_SYSTEMS) {
            String code = codeVariants.get(sys.name());
            if (code == null) continue;
            return code;
        }
        return null;
    }

    static void configureSegmentsTable(TableWidget<BookingFileAirSegmentVM> tableWidget) {
        DictBoxWidgetColumn departureColumn = (DictBoxWidgetColumn)tableWidget.getColumn("departurePoint");
        departureColumn.setValueBuilder(GEO_LOCATION_REF_BUILDER);
        departureColumn.setListParametersSupplier(AIRPORTS_LIST_PARAMS_SUPPLIER);
        DictBoxWidgetColumn arrivalColumn = (DictBoxWidgetColumn)tableWidget.getColumn("arrivalPoint");
        arrivalColumn.setValueBuilder(GEO_LOCATION_REF_BUILDER);
        arrivalColumn.setListParametersSupplier(AIRPORTS_LIST_PARAMS_SUPPLIER);
        DictBoxWidgetColumn carrierColumn = (DictBoxWidgetColumn)tableWidget.getColumn("carrier");
        carrierColumn.setValueBuilder(AIRLINE_REF_BUILDER);
        tableWidget.setOnRowsAction(event -> {
            boolean readingData = tableWidget.getProperties().containsKey((Object)"readingData");
            TableWidgetColumn numberColumn = tableWidget.getColumn("number");
            int rowsCount = tableWidget.getRowsCount();
            IntStream.range(0, rowsCount).forEach(i -> ((DictBoxWidget)carrierColumn.getWidget(i)).setSuggestionsLimit(200));
            if (readingData) {
                return;
            }
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                Integer curRowIndex = event.getRowIndex();
                if (curRowIndex != 0) {
                    int curVal;
                    int nextVal;
                    int prevVal = (Integer)((IntValueWidget)numberColumn.getWidget(curRowIndex - 1)).getValue();
                    ((IntValueWidget)numberColumn.getWidget(curRowIndex.intValue())).setValue((Number)(prevVal + 1));
                    if (curRowIndex < rowsCount - 1 && (nextVal = ((Integer)((IntValueWidget)numberColumn.getWidget(curRowIndex + 1)).getValue()).intValue()) == (curVal = ((Integer)((IntValueWidget)numberColumn.getWidget(curRowIndex.intValue())).getValue()).intValue())) {
                        IntStream.range(curRowIndex + 1, rowsCount).forEach(i -> {
                            int val = (Integer)((IntValueWidget)numberColumn.getWidget(i)).getValue();
                            ((IntValueWidget)numberColumn.getWidget(i)).setValue((Number)(val + 1));
                        });
                    }
                } else {
                    ((IntValueWidget)numberColumn.getWidget(0)).setValue((Number)1);
                }
            }
        });
    }

    private BookingFileProductSegmentsHelper() {
    }
}

