/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.delivery;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCellAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ComboBoxColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.KeyValueColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.PriceColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.KeyValueWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersContentsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersGeneral;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersTotalController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.DeliveryFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.renderer.StandardNodeRenderer;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.DeliveryService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.FinanceDocumentsService;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.util.Pair;

public class BookingFileProductDeliveryDeliveryParametersControllerInterceptor
extends ControllerInterceptor<BookingFileProductDeliveryDeliveryParametersVM, BookingFileProductDeliveryDeliveryParametersController> {
    protected void onCreate(BookingFileProductDeliveryDeliveryParametersController controller) {
        BookingFileProductDeliveryDeliveryParametersGeneral view = controller.getAddress().getGeneral().getView();
        BookingFileProductDeliveryDeliveryParametersTotalController total = controller.getAddress().getTotal();
        final BigTableWidget table = (BigTableWidget)controller.getContents().getView();
        KeyValueColumn objectColumn = (KeyValueColumn)table.getColumn("object");
        PriceColumn sumColumn = (PriceColumn)table.getColumn("sum");
        ComboBoxColumn fopColumn = (ComboBoxColumn)table.getColumn("fop");
        ComboBoxColumn currencyColumn = (ComboBoxColumn)table.getColumn("currency");
        table.getViewState().stateProperty().addListener((observable, oldValue, newValue) -> controller.getView().getContentsCell().revalidateActions());
        controller.getView().getContentsCell().getActions().add((Object)new GridCellAction<BigTableWidget<BookingFileProductDeliveryDeliveryParametersContentsVM>>(){

            public String getName(GridCell<BigTableWidget<BookingFileProductDeliveryDeliveryParametersContentsVM>> cell) {
                return Messages.financeDocumentsSelect;
            }

            public String getDescription(GridCell<BigTableWidget<BookingFileProductDeliveryDeliveryParametersContentsVM>> cell) {
                return Messages.financeDocumentsSelect;
            }

            public double getWeight() {
                return 0.0;
            }

            public boolean isEnabled(GridCell<BigTableWidget<BookingFileProductDeliveryDeliveryParametersContentsVM>> cell) {
                return !((BigTableWidget)cell.getPayload()).getViewState().isImmutable();
            }

            public void execute(GridCell<BigTableWidget<BookingFileProductDeliveryDeliveryParametersContentsVM>> cell, boolean alt) {
                IndexListParameters parameters = EntityIndexHandler.forId((String)FinanceDocumentRecordIndex.class.getName()).createListParameters();
                parameters.getSearchCriterions().add(SearchCriterion.eq((String)FinanceDocumentRecordIndex.Property.includedToDelivery.name(), (Object)Boolean.FALSE));
                parameters.getSearchCriterions().addAll(table.getRowsData().stream().filter(item -> item.getObject() != null && item.getObject().getKey() == DeliveryItemType.FINANCE_DOCUMENT && item.getObject().getValue() != null).map(item -> SearchCriterion.ne((String)"containerUid", (Object)item.getObject().getValue())).collect(Collectors.toList()));
                IndexListPane<FinanceDocument, FinanceDocumentRecordIndex> financeDcoumentsListPane = new IndexListPane<FinanceDocument, FinanceDocumentRecordIndex>(new ObservableMutex(), parameters, SelectionMode.MULTIPLE, false){

                    protected void newConfigurationPopulated() {
                        super.newConfigurationPopulated();
                        this.getTableView().getColumns().add((Object)TableColumnSettings.createActionColumn(item -> RootEntityEditingService.navigateTo((EntityReference)item.getSource())));
                    }
                };
                new Dialog().setTitle(Messages.financeDocumentsSelect).setBody((Node)financeDcoumentsListPane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Cancel).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Select, () -> 1.lambda$execute$8((IndexListPane)financeDcoumentsListPane, table), (BooleanExpression)Bindings.createBooleanBinding(() -> 1.lambda$execute$9((IndexListPane)financeDcoumentsListPane), (Observable[])new Observable[]{financeDcoumentsListPane.selectionPresentProperty()})).show(cell.getPayload());
            }

            private static /* synthetic */ Boolean lambda$execute$9(IndexListPane financeDcoumentsListPane) throws Exception {
                return financeDcoumentsListPane.selectionPresentProperty().get();
            }

            private static /* synthetic */ void lambda$execute$8(IndexListPane financeDcoumentsListPane, BigTableWidget table2) {
                List financeDocuments = financeDcoumentsListPane.getSelectedItems().stream().map(item -> item.getSource()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(financeDocuments)) {
                    Notifications.get().submitTask(() -> {
                        for (EntityReference financeDocument : financeDocuments) {
                            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                            FinanceDocumentsService financeDocumentsService = (FinanceDocumentsService)RpcServiceManager.get().getService(FinanceDocumentsService.class);
                            Optional<EntityContainer> financeDocumentContainer = Optional.ofNullable(entityService.load(ServiceInvocationContext.get(), financeDocument));
                            FxUtil.waitForFxThread(() -> {
                                List billingItems;
                                BookingFileProductDeliveryDeliveryParametersContentsVM vm = new BookingFileProductDeliveryDeliveryParametersContentsVM();
                                ArrayList billingItemsRefs = new ArrayList();
                                financeDocumentContainer.ifPresent(financeDocumentEntityContainer -> {
                                    FinanceDocument entity = (FinanceDocument)financeDocumentEntityContainer.getEntity();
                                    billingItemsRefs.addAll(entity.getBillingItems());
                                    Optional.ofNullable(entity.getCurrency()).ifPresent(currency -> vm.setCurrency(currency.getCode()));
                                });
                                try {
                                    billingItems = financeDocumentsService.getBillingItems(ServiceInvocationContext.get(), billingItemsRefs);
                                }
                                catch (ServiceException e) {
                                    throw new RuntimeException(e);
                                }
                                BigDecimal totalAmount = billingItems.stream().map(BillingItem::getAmount).filter(Objects::nonNull).map(VatAmount::getTotal).filter(Objects::nonNull).reduce(BigDecimal.ZERO, (xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1}));
                                vm.setSum(totalAmount);
                                vm.setObject(new Pair((Object)DeliveryItemType.FINANCE_DOCUMENT, (Object)financeDocument));
                                table2.addRow((Object)vm);
                            });
                        }
                    }, "Loading finance documents data");
                }
            }
        });
        objectColumn.setKeysSupplier(Suppliers.createEnumSupplier(DeliveryItemType.class));
        objectColumn.setRendererSupplier(key -> {
            if (key == DeliveryItemType.SIMPLE) {
                return StandardNodeRenderer.TEXTFIELD;
            }
            if (key == DeliveryItemType.PRODUCT) {
                return NodeRenderer.wrap((NodeRenderer)StandardNodeRenderer.ENTITYBOX_PRODUCT, node -> ((NestedEntityBoxWidget)node).setListParametersSupplier(() -> {
                    IndexListParameters parameters = EntityIndexHandler.forId((String)CommonProductIndex.class.getName()).createListParameters();
                    parameters.getSearchCriterions().add(SearchCriterion.eq((String)String.valueOf(CommonProductIndex.Property.client), (Object)view.getAddresseeValueNode().getValue().getValue()));
                    parameters.getSearchCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.inDelivery.name(), (Object)Boolean.FALSE));
                    return parameters;
                }));
            }
            if (key == DeliveryItemType.DOCUMENT) {
                return NodeRenderer.wrap((NodeRenderer)StandardNodeRenderer.ENTITYBOX_DOCUMENT, node -> ((EntityBoxWidget)node).setListParametersSupplier(() -> {
                    IndexListParameters parameters = EntityIndexHandler.forId((String)BasicDocumentIndex.class.getName()).createListParameters();
                    SearchCriterion[] searchCriterionArray = (SearchCriterion[])((EnumType)MetaRegistry.get().getEnums().get(DocumentType.class.getName())).getItems().values().stream().filter(item -> Boolean.parseBoolean((String)item.getParameters().get("isDeliveryAllowed"))).map(item -> SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.valueOf(DocumentType.class, (String)item.getId()))).toArray(SearchCriterion[]::new);
                    if (searchCriterionArray != null) {
                        parameters.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])searchCriterionArray));
                    }
                    return parameters;
                }));
            }
            if (key == DeliveryItemType.FINANCE_DOCUMENT) {
                return NodeRenderer.wrap((NodeRenderer)StandardNodeRenderer.ENTITYBOX_FINANCE_DOCUMENT, node -> ((EntityBoxWidget)node).setListParametersSupplier(() -> {
                    IndexListParameters parameters = EntityIndexHandler.forId((String)FinanceDocumentRecordIndex.class.getName()).createListParameters();
                    parameters.getSearchCriterions().add(SearchCriterion.eq((String)FinanceDocumentRecordIndex.Property.includedToDelivery.name(), (Object)Boolean.FALSE));
                    parameters.getSearchCriterions().addAll(table.getRowsData().stream().filter(item -> item.getObject() != null && item.getObject().getKey() == DeliveryItemType.FINANCE_DOCUMENT && item.getObject().getValue() != null).map(item -> SearchCriterion.ne((String)"containerUid", (Object)item.getObject().getValue())).collect(Collectors.toList()));
                    return parameters;
                }));
            }
            return null;
        });
        fopColumn.setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
        currencyColumn.setItemsSupplier(() -> Arrays.asList("RUB", "KZT", "UAH"));
        ValueHolder organizationContactDataHolder = new ValueHolder();
        KeyValueWidget addresseeValueNode = view.getAddresseeValueNode();
        TextFieldWidget addressValueNode = view.getAddressValueNode();
        DictBoxWidget regionValueNode = view.getRegionValueNode();
        DictBoxWidget metroValueNode = view.getMetroValueNode();
        KeyValueWidget contactValueNode = view.getContactValueNode();
        TextFieldWidget phoneValueNode = view.getPhoneValueNode();
        addresseeValueNode.setKeysSupplier(() -> Arrays.asList(DeliveryFXHelper.ENTITY, DeliveryFXHelper.TEXT));
        addresseeValueNode.setRendererSupplier(key -> {
            if (TextUtil.isSame((String)key, (String)DeliveryFXHelper.TEXT)) {
                return StandardNodeRenderer.TEXTFIELD;
            }
            if (TextUtil.isSame((String)key, (String)DeliveryFXHelper.ENTITY)) {
                return NodeRenderer.wrap((NodeRenderer)StandardNodeRenderer.ENTITYBOX_ORGANIZATION, node -> ((EntityBoxWidget)node).setListParametersSupplier(() -> {
                    IndexListParameters parameters = EntityIndexHandler.forId((String)OrganizationIndex.class.getName()).createListParameters();
                    parameters.getSearchCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT));
                    return parameters;
                }));
            }
            return null;
        });
        addresseeValueNode.valueProperty().addListener((observable, oldValue, newValue) -> {
            String oldKey = Optional.ofNullable(oldValue).map(item -> (String)item.getKey()).orElse(null);
            String newKey = Optional.ofNullable(newValue).map(item -> (String)item.getKey()).orElse(null);
            Object oldObject = Optional.ofNullable(oldValue).map(item -> item.getValue()).orElse(null);
            Object newObject = Optional.ofNullable(newValue).map(item -> item.getValue()).orElse(null);
            if (!TextUtil.isSame((String)oldKey, (String)newKey) || TextUtil.isSame((String)newKey, (String)DeliveryFXHelper.ENTITY) && !MiscUtil.equals(oldObject, newObject)) {
                addressValueNode.setValue(null);
                regionValueNode.setValue(null);
                metroValueNode.setValue(null);
                contactValueNode.setValue(new Pair((Object)newKey, null));
                phoneValueNode.setValue(null);
            }
            if (TextUtil.isSame((String)newKey, (String)DeliveryFXHelper.ENTITY) && newObject != null) {
                EntityReference organizationReference = newObject;
                Notifications.get().submitTask(() -> {
                    DeliveryHelper.OrganizationContactData organizationContactData = ((DeliveryService)RpcServiceManager.get().getService(DeliveryService.class)).getOrganizationContactData(ServiceInvocationContext.get(), organizationReference);
                    organizationContactDataHolder.set((Object)organizationContactData);
                    if (organizationContactData != null) {
                        FxUtil.submitToFxThread(() -> {
                            EntityReference person;
                            Address address = organizationContactData.getAddress();
                            if (address != null) {
                                String addressValue = ProfileHelper.buildFullAddress((Address)address, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
                                addressValue = !TextUtil.isBlank((String)addressValue) ? addressValue.trim() : null;
                                addressValueNode.setValue(addressValue);
                                regionValueNode.setValue(address.getDeliveryRegion());
                                metroValueNode.setValue(address.getMetroStation());
                            }
                            if ((person = (EntityReference)Optional.ofNullable(organizationContactData.getPersonContactDatas()).filter(item -> item.size() > 0).map(item -> (EntityReference)item.keySet().iterator().next()).orElse(null)) != null) {
                                contactValueNode.setValue(new Pair((Object)DeliveryFXHelper.ENTITY, (Object)person));
                            } else {
                                contactValueNode.setValue(new Pair((Object)DeliveryFXHelper.TEXT, null));
                            }
                        });
                    }
                }, Messages.Loading_data);
            } else {
                organizationContactDataHolder.set(null);
                contactValueNode.setValue(new Pair((Object)DeliveryFXHelper.TEXT, null));
            }
        });
        contactValueNode.setKeysSupplier(() -> Arrays.asList(DeliveryFXHelper.ENTITY, DeliveryFXHelper.TEXT));
        contactValueNode.setRendererSupplier(key -> {
            if (TextUtil.isSame((String)key, (String)DeliveryFXHelper.TEXT)) {
                return StandardNodeRenderer.TEXTFIELD;
            }
            if (TextUtil.isSame((String)key, (String)DeliveryFXHelper.ENTITY)) {
                return NodeRenderer.wrap((NodeRenderer)StandardNodeRenderer.ENTITYBOX_PERSON, node -> ((EntityBoxWidget)node).setListParametersSupplier(() -> {
                    IndexListParameters parameters = EntityIndexHandler.forId((String)PersonIndex.class.getName()).createListParameters();
                    DeliveryHelper.OrganizationContactData organizationContactData = (DeliveryHelper.OrganizationContactData)organizationContactDataHolder.get();
                    if (organizationContactData != null) {
                        parameters.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])organizationContactData.getPersonContactDatas().keySet().stream().map(item -> SearchCriterion.eq((String)"containerUid", (Object)item.getUid())).toArray(SearchCriterion[]::new))));
                    }
                    return parameters;
                }));
            }
            return null;
        });
        contactValueNode.valueProperty().addListener((observable, oldValue, newValue) -> {
            String oldKey = Optional.ofNullable(oldValue).map(item -> (String)item.getKey()).orElse(null);
            String newKey = Optional.ofNullable(newValue).map(item -> (String)item.getKey()).orElse(null);
            Object oldObject = Optional.ofNullable(oldValue).map(item -> item.getValue()).orElse(null);
            Object newObject = Optional.ofNullable(newValue).map(item -> item.getValue()).orElse(null);
            if (!TextUtil.isSame((String)oldKey, (String)newKey) || TextUtil.isSame((String)newKey, (String)DeliveryFXHelper.ENTITY) && !MiscUtil.equals(oldObject, newObject)) {
                phoneValueNode.setValue(null);
            }
            ArrayList communications = new ArrayList();
            if (TextUtil.isSame((String)newKey, (String)DeliveryFXHelper.ENTITY) && newObject != null) {
                EntityReference personReference = (EntityReference)newValue.getValue();
                DeliveryHelper.OrganizationContactData organizationContactData = (DeliveryHelper.OrganizationContactData)organizationContactDataHolder.get();
                if (organizationContactData != null) {
                    DeliveryHelper.PersonContactData personContactData = (DeliveryHelper.PersonContactData)organizationContactData.getPersonContactDatas().get(personReference);
                    if (personContactData != null) {
                        communications.addAll(personContactData.getCommunications());
                    }
                    communications.addAll(organizationContactData.getCommunications());
                }
            } else {
                DeliveryHelper.OrganizationContactData organizationContactData = (DeliveryHelper.OrganizationContactData)organizationContactDataHolder.get();
                if (organizationContactData != null) {
                    communications.addAll(organizationContactData.getCommunications());
                }
            }
            if (!TextUtil.isSame((String)oldKey, (String)newKey) || TextUtil.isSame((String)newKey, (String)DeliveryFXHelper.ENTITY) && !MiscUtil.equals(oldObject, newObject)) {
                List phoneValues = communications.stream().map(item -> ProfileHelper.buildFullPhoneNumber((Communication)item)).map(item -> !TextUtil.isBlank((String)item) ? item.trim() : null).filter(item -> item != null).collect(Collectors.toList());
                phoneValueNode.setItemsSupplier(phoneValues.size() > 0 ? () -> phoneValues : null);
                phoneValueNode.setValue(phoneValues.size() > 0 ? (String)phoneValues.get(0) : null);
            }
        });
        view.getMetroValueNode().valueProperty().addListener((obj, o, newValue) -> Notifications.get().submitTask(() -> {
            DictionaryReference metroLineDictionaryReference = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getMetroLine(ServiceInvocationContext.get(), newValue);
            FxUtil.submitToFxThread(() -> controller.getAddress().getGeneral().setLineValue(metroLineDictionaryReference));
        }, "delivery-get-metro-line-mutex"));
        sumColumn.getListeners().add((s, o, n) -> BookingFileProductDeliveryDeliveryParametersControllerInterceptor.recalculateTotal(total, (BigTableWidget<BookingFileProductDeliveryDeliveryParametersContentsVM>)table));
        fopColumn.getListeners().add((s, o, n) -> BookingFileProductDeliveryDeliveryParametersControllerInterceptor.recalculateTotal(total, (BigTableWidget<BookingFileProductDeliveryDeliveryParametersContentsVM>)table));
    }

    protected Class<BookingFileProductDeliveryDeliveryParametersController> getControllerClass() {
        return BookingFileProductDeliveryDeliveryParametersController.class;
    }

    private static void recalculateTotal(BookingFileProductDeliveryDeliveryParametersTotalController total, BigTableWidget<BookingFileProductDeliveryDeliveryParametersContentsVM> table) {
        Map<Optional, BigDecimal> fopSumMap = table.getRowsData().stream().collect(Collectors.groupingBy(contents -> Optional.ofNullable(contents.getFop()), Collectors.reducing(BigDecimal.ZERO, parametersContentsVM -> Optional.ofNullable(parametersContentsVM.getSum()).orElse(BigDecimal.ZERO), BigDecimal::add)));
        BigDecimal cashValue = fopSumMap.get(Optional.of(PaymentType.CASH));
        total.setTotalValue(fopSumMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add));
        total.setCashValue(cashValue != null ? cashValue : BigDecimal.ZERO);
    }
}

