/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.StandardTableWidgetCoordinator;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticReasonCodesVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticUdidsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticVM;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeDisplayType;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.util.StringConverter;

public class BookingFileProductStatisticsHelper {
    public static void updateReasonCodesTable(TableWidget<BookingFileProductStatisticReasonCodesVM> reasonCodesWidget, BookingFileProductStatisticVM model) {
        TableWidgetColumn reasonCodeColumn = reasonCodesWidget.getColumn("reasonCode");
        reasonCodesWidget.setOnRowsAction(event -> {
            if (event.getTarget() == reasonCodesWidget && TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                int idx = event.getRowIndex();
                ComboBoxWidget reasonCodeWidget = (ComboBoxWidget)reasonCodeColumn.getWidget(idx);
                BookingFileProductStatisticsHelper.setupReasonCodeWidget((ComboBoxWidget<ReasonCode>)reasonCodeWidget, model);
            }
        });
        for (int i = 0; i < reasonCodesWidget.getRowsCount(); ++i) {
            ComboBoxWidget reasonCodeWidget = (ComboBoxWidget)reasonCodeColumn.getWidget(i);
            BookingFileProductStatisticsHelper.setupReasonCodeWidget((ComboBoxWidget<ReasonCode>)reasonCodeWidget, model);
        }
    }

    private static void setupReasonCodeWidget(ComboBoxWidget<ReasonCode> reasonCodeWidget, BookingFileProductStatisticVM model) {
        reasonCodeWidget.setConverter((StringConverter)new StringConverter<ReasonCode>(){

            public String toString(ReasonCode reasonCode) {
                if (reasonCode == null) {
                    return null;
                }
                String result = reasonCode.getType() + " - " + reasonCode.getName();
                String localizedContent = L10nStringHelper.getValue((L10nString)reasonCode.getRemarks(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
                if (!TextUtil.isBlank((String)localizedContent)) {
                    result = result + " - " + localizedContent;
                } else if (!TextUtil.isBlank((String)reasonCode.getSabreName())) {
                    result = result + " - " + reasonCode.getSabreName();
                }
                return result;
            }

            public ReasonCode fromString(String string) {
                return null;
            }
        });
        if (CollectionUtil.isNotEmpty((Collection)model.getProfileReasonCodes())) {
            reasonCodeWidget.setItemsSupplier(() -> ((BookingFileProductStatisticVM)model).getProfileReasonCodes());
        }
    }

    public static void updateUdidsTable(TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, BookingFileProductStatisticVM model) {
        ComboBoxWidgetColumn nameColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("name");
        TextWidgetColumn valueColumn = (TextWidgetColumn)udidsWidget.getColumn("value");
        udidsWidget.setOnRowsAction(event -> {
            if (event.getTarget() == udidsWidget && TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                int idx = event.getRowIndex();
                ComboBoxWidget nameWidget = (ComboBoxWidget)nameColumn.getWidget(idx);
                TextFieldWidget valueWidget = (TextFieldWidget)valueColumn.getWidget(idx);
                BookingFileProductStatisticsHelper.setupUdidsWidgets(udidsWidget, (ComboBoxWidget<CostCodeProperties>)nameWidget, valueWidget, model);
            }
        });
        for (int i = 0; i < udidsWidget.getRowsCount(); ++i) {
            List costCodeValues;
            ComboBoxWidget nameWidget = (ComboBoxWidget)nameColumn.getWidget(i);
            TextFieldWidget valueWidget = (TextFieldWidget)valueColumn.getWidget(i);
            if (nameWidget.getValue() != null && !(costCodeValues = model.getProfileCostCodes().stream().filter(costCode -> ((CostCodeProperties)nameWidget.getValue()).getCategory() != null && costCode.getCostCodeProperties() != null && ((CostCodeProperties)nameWidget.getValue()).getCategory().equals((Object)costCode.getCostCodeProperties().getCategory())).map(cc -> ProfileHelper.getCostCodeValue((CostCode)cc, (CostCodeDisplayType)cc.getCostCodeProperties().getDisplayType())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
                valueWidget.setItemsSupplier(() -> costCodeValues);
            }
            BookingFileProductStatisticsHelper.setupUdidsWidgets(udidsWidget, (ComboBoxWidget<CostCodeProperties>)nameWidget, valueWidget, model);
        }
    }

    public static void setupUdidsWidgets(TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, ComboBoxWidget<CostCodeProperties> nameWidget, TextFieldWidget valueWidget, BookingFileProductStatisticVM model) {
        BookingFileProductStatisticsHelper.setupNameWidget(udidsWidget, nameWidget, model);
        BookingFileProductStatisticsHelper.setupValueWidget(nameWidget, valueWidget, model);
    }

    public static void setupNameWidget(TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, ComboBoxWidget<CostCodeProperties> nameWidget, BookingFileProductStatisticVM model) {
        nameWidget.setConverter((StringConverter)new StringConverter<CostCodeProperties>(){

            public String toString(CostCodeProperties prop) {
                return prop == null ? null : prop.getName();
            }

            public CostCodeProperties fromString(String string) {
                return null;
            }
        });
        if (CollectionUtil.isNotEmpty((Collection)model.getProfileCostCodeProperties())) {
            nameWidget.setItemsSupplier(() -> model.getProfileCostCodeProperties().stream().filter(ccp -> !ccp.isDependant() || BookingFileProductStatisticsHelper.getValidDependants(model, udidsWidget).contains(ccp)).collect(Collectors.toList()));
        }
    }

    public static List<CostCodeProperties> getValidDependants(BookingFileProductStatisticVM model, TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget) {
        return BookingFileProductStatisticsHelper.getValidDependants(model, udidsWidget, -1, null);
    }

    public static List<CostCodeProperties> getValidDependants(BookingFileProductStatisticVM model, TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, Traveller traveller) {
        return BookingFileProductStatisticsHelper.getValidDependants(model, udidsWidget, traveller, -1, null);
    }

    public static List<CostCodeProperties> getValidDependants(BookingFileProductStatisticVM model, TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, int row, String value) {
        return BookingFileProductStatisticsHelper.getValidDependants(model, udidsWidget, null, row, value);
    }

    public static List<CostCodeProperties> getValidDependants(BookingFileProductStatisticVM model, TableWidget<BookingFileProductStatisticUdidsVM> udidsWidget, Traveller traveller, int row, String value) {
        ComboBoxWidgetColumn nameColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("name");
        TextWidgetColumn valueColumn = (TextWidgetColumn)udidsWidget.getColumn("value");
        ComboBoxWidgetColumn travellerIbeColumn = (ComboBoxWidgetColumn)udidsWidget.getColumn("travellerIbe");
        return model.getProfileCostCodeProperties().stream().filter(CostCodeProperties::isDependant).filter(ccp -> IntStream.range(0, udidsWidget.getRowsCount()).filter(i -> ((ComboBoxWidget)nameColumn.getWidget(i)).getValue() != null && !((CostCodeProperties)((ComboBoxWidget)nameColumn.getWidget(i)).getValue()).isDependant()).anyMatch(i -> model.getProfileCostCodes().stream().filter(cc -> !(!MiscUtil.equals((Object)cc.getCostCodeProperties(), (Object)((ComboBoxWidget)nameColumn.getWidget(i)).getValue()) || traveller != null && !MiscUtil.equals((Object)traveller, (Object)((ComboBoxWidget)travellerIbeColumn.getWidget(i)).getValue()) || !TextUtil.equals((String)cc.getLocalValue(), (String)(i == row ? value : ((TextFieldWidget)valueColumn.getWidget(i)).getValue()), (boolean)false) && !TextUtil.equals((String)cc.getEnglishValue(), (String)(i == row ? value : ((TextFieldWidget)valueColumn.getWidget(i)).getValue()), (boolean)false) && !TextUtil.equals((String)cc.getValue(), (String)(i == row ? value : ((TextFieldWidget)valueColumn.getWidget(i)).getValue()), (boolean)false))).anyMatch(cc -> cc.getRelatedCostCodeProperties().contains(ccp)))).collect(Collectors.toList());
    }

    public static void setupValueWidget(ComboBoxWidget<CostCodeProperties> nameWidget, TextFieldWidget valueWidget, BookingFileProductStatisticVM model) {
        nameWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                List costCodeValues = model.getProfileCostCodes().stream().filter(costCode -> newValue.getCategory() != null && costCode.getCostCodeProperties() != null && newValue.getCategory().equals((Object)costCode.getCostCodeProperties().getCategory())).map(cc -> ProfileHelper.getCostCodeValue((CostCode)cc, (CostCodeDisplayType)cc.getCostCodeProperties().getDisplayType())).filter(Objects::nonNull).collect(Collectors.toList());
                if (costCodeValues.isEmpty()) {
                    valueWidget.setItemsSupplier(null);
                } else {
                    valueWidget.setItemsSupplier(() -> costCodeValues);
                }
            }
        });
    }

    public static void setupUdidsWidgetButtons(BookingFileProductStatisticController controller, final BookingFileProductStatisticVM model) {
        TableWidget udidsWidget = (TableWidget)controller.getStatistic().getView().getUdidsCard().getContent();
        udidsWidget.setControlButtonsCoordinator((BiPredicate)new StandardTableWidgetCoordinator(udidsWidget){

            public boolean test(ControlsPane.ButtonType buttonType, Integer rowNumber) {
                if (model.getProfileCostCodeProperties() == null) {
                    return false;
                }
                if (model.getProfileCostCodeProperties().isEmpty()) {
                    if (rowNumber == null) {
                        return false;
                    }
                    if (buttonType == ControlsPane.ButtonType.ADD) {
                        return false;
                    }
                }
                return super.test(buttonType, rowNumber);
            }
        });
        controller.getStatistic().getUdids().readData((Object)model.getStatistic().getUdids());
    }
}

