/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AgencyMemoProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.AgencyMemoProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class AgencyMemoProductFXHandler
implements ProductFXHandler<AgencyMemoProduct, AgencyMemoProductIndex, AgencyMemoProductUIData, Void> {
    @Override
    public Class<AgencyMemoProduct> getProductClass() {
        return AgencyMemoProduct.class;
    }

    @Override
    public Class<AgencyMemoProductIndex> getProductIndexClass() {
        return AgencyMemoProductIndex.class;
    }

    @Override
    public AgencyMemoProductUIData createUiData() {
        return new AgencyMemoProductUIData();
    }

    @Override
    public AgencyMemoProduct createProduct() {
        return new AgencyMemoProduct();
    }

    @Override
    public BaseProductVM createVM(AgencyMemoProduct product) {
        return new BookingFileAgencyMemoProductPanelVM();
    }

    @Override
    public void toVM(AgencyMemoProduct product, AgencyMemoProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        BookingFileAgencyMemoProductPanelVM parentVM = (BookingFileAgencyMemoProductPanelVM)vm;
        parentVM.setReservationUid(product.getReservation().getUid());
        AgencyMemoProductFXHelper.toVMParentParameters(product, parentVM);
        AgencyMemoProductFXHelper.toVMParameters(parentVM.getGeneral(), parentVM.getStatuses(), product, productData);
        parentVM.getRelatedAgencyMemoProducts().setSupplierAgencyMemo(product.getSupplierAgencyMemo());
        parentVM.getRelatedAgencyMemoProducts().setCustomerAgencyMemo(product.getCustomerAgencyMemo());
        AgencyMemoProductFXHelper.toVMItemGroups(parentVM.getOtherParameters().getComponents(), product);
        AgencyMemoProductFXHelper.toVMRelatedProducts(parentVM.getOtherParameters().getComponents(), product);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, parentVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, parentVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, parentVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, parentVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), parentVM.getOtherParameters().getValidation());
        parentVM.getOtherParameters().getPopups().setComments(product.getComments());
    }

    @Override
    public void fromVM(BaseProductVM vm, AgencyMemoProduct product, AgencyMemoProductUIData productData) {
        BookingFileAgencyMemoProductPanelVM parentVM = (BookingFileAgencyMemoProductPanelVM)vm;
        AgencyMemoProductFXHelper.fromVMParameters(parentVM.getGeneral(), parentVM.getStatuses(), product, productData);
        product.setSupplierAgencyMemo(parentVM.getRelatedAgencyMemoProducts().getSupplierAgencyMemo());
        product.setCustomerAgencyMemo(parentVM.getRelatedAgencyMemoProducts().getCustomerAgencyMemo());
        AgencyMemoProductFXHelper.fromVMItemGroups(parentVM.getOtherParameters().getComponents(), product);
        AgencyMemoProductFXHelper.fromVMRelatedProducts(parentVM.getOtherParameters().getComponents(), product);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, parentVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(parentVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(parentVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        product.setComments(parentVM.getOtherParameters().getPopups().getComments());
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileAgencyMemoProductPanelVM)vm).getReservationUid();
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileAgencyMemoProductPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileAgencyMemoProductPanelVM productVM = new BookingFileAgencyMemoProductPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.AGENCY_MEMO_PRODUCT.toString());
        MiscUtil.Pair<AgencyMemoProduct, AgencyMemoProductUIData> prototypeData = AgencyMemoProductFXHelper.getPrototypeData();
        AgencyMemoProduct product = (AgencyMemoProduct)prototypeData.getFirst();
        AgencyMemoProductUIData productSupplementData = (AgencyMemoProductUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileAgencyMemoProductPanel node = new BookingFileAgencyMemoProductPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            AgencyMemoProductFXHelper.updateNode(node, bookingFileVM);
            BookingFileAgencyMemoProductPanelController controller = new BookingFileAgencyMemoProductPanelController(node, false);
            controller.readData(productVM);
            BookingFileAgencyMemoProductPanel bookingFileAgencyMemoProductPanel = node;
            return bookingFileAgencyMemoProductPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileAgencyMemoProductPanel node = new BookingFileAgencyMemoProductPanel(false);
        AgencyMemoProductFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public AgencyMemoProduct getPreviousProduct(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public AgencyMemoProduct getNextProduct(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public ProductStatus getProductStatus(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public void remove(AgencyMemoProduct product) {
        product.getReservation().getProducts().remove(product);
    }

    @Override
    public StatisticalData getStatisticalData(AgencyMemoProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(AgencyMemoProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public Collection<Traveller> getTravellers(AgencyMemoProduct product) {
        return Collections.emptyList();
    }

    @Override
    public void setAgent(AgencyMemoProduct product, EntityReference<Person> agent) {
    }

    @Override
    public ProductType getProductType(AgencyMemoProduct product) {
        return ProductType.AGENCY_MEMO_PRODUCT;
    }

    @Override
    public String getDisplayName() {
        return ProductType.AGENCY_MEMO_PRODUCT.toString();
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        return Collections.emptySet();
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        if (node instanceof BookingFileAgencyMemoProductPanel) {
            BookingFileAgencyMemoProductPanel panel = (BookingFileAgencyMemoProductPanel)node;
            String systemNumber = panel.getGeneralNode().getBaseInformationParametersNode().getNumberValueNode().getSystemNumberNode().getValue();
            boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
            if (emptyPaymentType) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
            }
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
    }
}

