/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirFeesAndChargesPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagageGeneralPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagagePanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagagePanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagagePanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagageSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDGeneralPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDTicketInfoPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticUdidsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStubParent;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStubParentController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStubParentVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AirProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.uidata.AirProductUIData;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class AirProductFXHandler
implements ProductFXHandler<Product, ProductIndex, AirProductUIData, Void> {
    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public Class<ProductIndex> getProductIndexClass() {
        return ProductIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.AIR_TICKET.toString();
    }

    @Override
    public boolean isEMDOrExcessBagage(Product product) {
        return product.getProductCategory() == ProductCategory.MCO || product.getProductCategory() == ProductCategory.EXCESS_BAGAGE;
    }

    @Override
    public StatisticalData getStatisticalData(Product product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(Product product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public List<BaseProduct> getRelatedProducts(Product product) {
        return new ArrayList<BaseProduct>(product.getRelatedProducts());
    }

    @Override
    public boolean removeRelatedProduct(Product product, BaseProduct removedProduct) {
        return product.getRelatedProducts().removeIf(p -> MiscUtil.equals((Object)p, (Object)removedProduct));
    }

    @Override
    public boolean isDeletable(Product product) {
        return Objects.isNull(product.getNextProduct()) && AirProductHelper.getDuplicateByRelatedProduct((Product)product).isEmpty();
    }

    @Override
    public Product getPreviousProduct(Product product) {
        return product.getPreviousProduct();
    }

    @Override
    public Product getNextProduct(Product product) {
        return product.getNextProduct();
    }

    @Override
    public ProductStatus getProductStatus(Product product) {
        return product.getStatus();
    }

    @Override
    public Collection<Traveller> getTravellers(Product product) {
        return product.getTraveller() == null ? new ArrayList() : Collections.singletonList(product.getTraveller());
    }

    @Override
    public void setAgent(Product product, EntityReference<Person> agent) {
        product.setCashier(agent);
    }

    @Override
    public void remove(Product product) {
        Product nextProduct;
        product.getReservation().getProducts().remove(product);
        Product previousProduct = product.getPreviousProduct();
        if (previousProduct != null) {
            previousProduct.setNextProduct(null);
        }
        if ((nextProduct = product.getNextProduct()) != null) {
            nextProduct.setPreviousProduct(null);
        }
    }

    @Override
    public AirProductUIData createUiData() {
        return new AirProductUIData();
    }

    @Override
    public Product createProduct() {
        return new Product();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        if (vm instanceof BookingFileProductAirPanelVM) {
            BookingFileProductAirPanelVM productVM = (BookingFileProductAirPanelVM)vm;
            return productVM.getGeneral().getTravelerInfo().getBookingValue();
        }
        if (vm instanceof BookingFileProductEMDPanelVM) {
            BookingFileProductEMDPanelVM productVM = (BookingFileProductEMDPanelVM)vm;
            return productVM.getGeneral().getTravelerInfo().getBookingValue();
        }
        if (vm instanceof BookingFileProductBagagePanelVM) {
            BookingFileProductBagagePanelVM productVM = (BookingFileProductBagagePanelVM)vm;
            return productVM.getGeneral().getTravelerInfo().getBookingValue();
        }
        return null;
    }

    @Override
    public BaseProductVM createVM(Product product) {
        ProductCategory category = product.getProductCategory();
        if (category == ProductCategory.AIR || category == null) {
            return new BookingFileProductAirPanelVM();
        }
        if (category == ProductCategory.MCO) {
            return new BookingFileProductEMDPanelVM();
        }
        if (category == ProductCategory.EXCESS_BAGAGE) {
            return new BookingFileProductBagagePanelVM();
        }
        return new BookingFileProductStubParentVM();
    }

    @Override
    public void toVM(Product product, AirProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        String recordLocator = product.getReservation().getUid();
        List<ReasonCodeType> reasonCodeAirTypes = Arrays.asList(ReasonCodeType.REASON_CODE_AIR, ReasonCodeType.REASON_CODE_NO_HOTEL, ReasonCodeType.REASON_CODE_DECLINED);
        if (vm instanceof BookingFileProductAirPanelVM) {
            BookingFileProductAirPanelVM productPaneVM = (BookingFileProductAirPanelVM)vm;
            productPaneVM.getFops().setProductType(Product.class);
            GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, productPaneVM.getFops());
            GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, productPaneVM.getFops().getContract());
            GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, productPaneVM.getFops().getPrepaymentDocuments());
            GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, productPaneVM.getFops().getVendorFinanceDocumentsData());
            AirProductFXHelper.toVMAirCost(product, productData, productPaneVM.getCost());
            GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, productPaneVM.getCommissions());
            productPaneVM.getCommissions().setEnableSegmentsColumn(true);
            productPaneVM.getCommissions().setSegmentTariffs(product.getSegmentTariffs());
            GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodeAirTypes, Product.class, productPaneVM.getOtherParameters().getStatistic(), customerProfile);
            GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), productPaneVM.getOtherParameters().getValidation());
            AirProductFXHelper.toVMAirMainParameters(product, productData, recordLocator, productPaneVM);
            AirProductFXHelper.toVMAirSegments(product, productData, productPaneVM.getSegments().getContent());
            AirProductFXHelper.toVMAirAdditionalParameters(product, productData, productPaneVM.getOtherParameters());
        } else if (vm instanceof BookingFileProductEMDPanelVM) {
            BookingFileProductEMDPanelVM productPaneVM = (BookingFileProductEMDPanelVM)vm;
            productPaneVM.getFops().setProductType(Product.class);
            AirProductFXHelper.toVMAirCost(product, productData, productPaneVM.getCost());
            GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, productPaneVM.getFops());
            GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, productPaneVM.getFops().getContract());
            GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, productPaneVM.getFops().getPrepaymentDocuments());
            GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, productPaneVM.getFops().getVendorFinanceDocumentsData());
            GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, productPaneVM.getCommissions());
            productPaneVM.getCommissions().setEnableSegmentsColumn(true);
            productPaneVM.getCommissions().setSegmentTariffs(product.getSegmentTariffs());
            GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodeAirTypes, Product.class, productPaneVM.getOtherParameters().getStatistic(), customerProfile);
            GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), productPaneVM.getOtherParameters().getValidation());
            AirProductFXHelper.toVMEMDRelatedProducts(product, productData, productPaneVM.getRelated());
            AirProductFXHelper.toVMEMDGeneralParameters(product, productData, recordLocator, productPaneVM);
            AirProductFXHelper.toVMAirSegments(product, productData, productPaneVM.getSegments().getContent());
            AirProductFXHelper.toVMEMDAdditionalParameters(product, productData, productPaneVM.getOtherParameters());
        } else if (vm instanceof BookingFileProductBagagePanelVM) {
            BookingFileProductBagagePanelVM productPaneVM = (BookingFileProductBagagePanelVM)vm;
            productPaneVM.getFops().setProductType(Product.class);
            AirProductFXHelper.toVMAirCost(product, productData, productPaneVM.getCost());
            GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, productPaneVM.getFops());
            GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, productPaneVM.getFops().getContract());
            GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, productPaneVM.getFops().getPrepaymentDocuments());
            GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, productPaneVM.getFops().getVendorFinanceDocumentsData());
            GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, productPaneVM.getCommissions());
            productPaneVM.getCommissions().setEnableSegmentsColumn(true);
            productPaneVM.getCommissions().setSegmentTariffs(product.getSegmentTariffs());
            GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodeAirTypes, Product.class, productPaneVM.getOtherParameters().getStatistic(), customerProfile);
            GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), productPaneVM.getOtherParameters().getValidation());
            AirProductFXHelper.toVMBagageRelatedProducts(product, productData, productPaneVM.getRelated());
            AirProductFXHelper.toVMBagageGeneralParameters(product, productData, recordLocator, productPaneVM);
            AirProductFXHelper.toVMAirSegments(product, productData, productPaneVM.getSegments().getContent());
            AirProductFXHelper.toVMBagageAdditionalParameters(product, productData, productPaneVM.getOtherParameters());
        }
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductAirPanel || node instanceof BookingFileProductEMDPanel || node instanceof BookingFileProductBagagePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        ProductCategory productCategory = (ProductCategory)parameters.get("productCategory");
        if (productCategory == ProductCategory.AIR) {
            BookingFileProductAirPanelVM productVM = new BookingFileProductAirPanelVM();
            productVM.setBookingFile(bookingFile);
            productVM.setProductFullNameWithSpaces(ProductType.AIR_TICKET.toString());
            MiscUtil.Pair<Product, AirProductUIData> prototypeData = AirProductFXHelper.getPrototypeData(ProductCategory.AIR);
            Product product = (Product)prototypeData.getFirst();
            AirProductUIData productSupplementData = (AirProductUIData)prototypeData.getSecond();
            productVM.setProductUiData((BaseProductUIData)productSupplementData);
            String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
            if (reservation == null) {
                reservation = new Reservation(reservationUid);
            }
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().add(reservation);
                reservation.setBookingFile(bookingFile);
            }
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
            try {
                this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
                BookingFileProductAirPanel node = new BookingFileProductAirPanel(false);
                node.getProperties().put((Object)"model-uid", (Object)product.getUid());
                AirProductFXHelper.updateNode(node, bookingFileVM);
                BookingFileProductAirPanelController controller = new BookingFileProductAirPanelController(node, false);
                controller.readData(productVM);
                BookingFileProductAirPanel bookingFileProductAirPanel = node;
                return bookingFileProductAirPanel;
            }
            finally {
                reservation.getProducts().remove(product);
                product.setReservation(null);
                if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                    bookingFile.getReservations().remove(reservation);
                    reservation.setBookingFile(null);
                }
            }
        }
        if (productCategory == ProductCategory.MCO) {
            BookingFileProductEMDPanelVM productVM = new BookingFileProductEMDPanelVM();
            productVM.setBookingFile(bookingFile);
            productVM.setProductFullNameWithSpaces(ProductCategory.MCO.toString());
            MiscUtil.Pair<Product, AirProductUIData> prototypeData = AirProductFXHelper.getPrototypeData(productCategory);
            Product product = (Product)prototypeData.getFirst();
            AirProductUIData productSupplementData = (AirProductUIData)prototypeData.getSecond();
            productVM.setProductUiData((BaseProductUIData)productSupplementData);
            String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
            if (reservation == null) {
                reservation = new Reservation(reservationUid);
            }
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().add(reservation);
                reservation.setBookingFile(bookingFile);
            }
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            try {
                this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
                BookingFileProductEMDPanel node = new BookingFileProductEMDPanel(false);
                node.getProperties().put((Object)"model-uid", (Object)product.getUid());
                AirProductFXHelper.updateNode(node, bookingFileVM);
                BookingFileProductEMDPanelController controller = new BookingFileProductEMDPanelController(node, false);
                controller.readData(productVM);
                BookingFileProductEMDPanel bookingFileProductEMDPanel = node;
                return bookingFileProductEMDPanel;
            }
            finally {
                reservation.getProducts().remove(product);
                product.setReservation(null);
                if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                    bookingFile.getReservations().remove(reservation);
                    reservation.setBookingFile(null);
                }
            }
        }
        if (productCategory == ProductCategory.EXCESS_BAGAGE) {
            BookingFileProductBagagePanelVM productVM = new BookingFileProductBagagePanelVM();
            productVM.setBookingFile(bookingFile);
            productVM.setProductFullNameWithSpaces(ProductType.EXCESS_BAGAGE.toString());
            MiscUtil.Pair<Product, AirProductUIData> prototypeData = AirProductFXHelper.getPrototypeData(productCategory);
            Product product = (Product)prototypeData.getFirst();
            AirProductUIData productSupplementData = (AirProductUIData)prototypeData.getSecond();
            productVM.setProductUiData((BaseProductUIData)productSupplementData);
            String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
            if (reservation == null) {
                reservation = new Reservation(reservationUid);
            }
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().add(reservation);
                reservation.setBookingFile(bookingFile);
            }
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            try {
                this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
                BookingFileProductBagagePanel node = new BookingFileProductBagagePanel(false);
                node.getProperties().put((Object)"model-uid", (Object)product.getUid());
                AirProductFXHelper.updateNode(node, bookingFileVM);
                BookingFileProductBagagePanelController controller = new BookingFileProductBagagePanelController(node, false);
                controller.readData(productVM);
                BookingFileProductBagagePanel bookingFileProductBagagePanel = node;
                return bookingFileProductBagagePanel;
            }
            finally {
                reservation.getProducts().remove(product);
                product.setReservation(null);
                if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                    bookingFile.getReservations().remove(reservation);
                    reservation.setBookingFile(null);
                }
            }
        }
        BookingFileProductStubParentVM productVM = new BookingFileProductStubParentVM();
        BookingFileProductStubParent node = new BookingFileProductStubParent(false);
        BookingFileProductStubParentController controller = new BookingFileProductStubParentController(node, false);
        controller.readData(productVM);
        return node;
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        ProductCategory productCategory = (ProductCategory)parameters.get("productCategory");
        if (productCategory == ProductCategory.AIR) {
            BookingFileProductAirPanel node = new BookingFileProductAirPanel(false);
            AirProductFXHelper.updateNode(node, bookingFileVM);
            return node;
        }
        if (productCategory == ProductCategory.MCO) {
            BookingFileProductEMDPanel node = new BookingFileProductEMDPanel(false);
            AirProductFXHelper.updateNode(node, bookingFileVM);
            return node;
        }
        if (productCategory == ProductCategory.EXCESS_BAGAGE) {
            BookingFileProductBagagePanel node = new BookingFileProductBagagePanel(false);
            AirProductFXHelper.updateNode(node, bookingFileVM);
            return node;
        }
        BookingFileProductStubParent node = new BookingFileProductStubParent(false);
        return node;
    }

    @Override
    public void fromVM(BaseProductVM vm, Product product, AirProductUIData productData) {
        BookingFile bookingFile = product.getReservation() != null && product.getReservation().getBookingFile() != null ? product.getReservation().getBookingFile() : vm.getBookingFile();
        AirProductFXHelper.fillBasicProductFields(product);
        if (vm instanceof BookingFileProductAirPanelVM) {
            BookingFileProductAirPanelVM productPaneVM = (BookingFileProductAirPanelVM)vm;
            AirProductFXHelper.fromVMAirMainParameters(productPaneVM, bookingFile, product, productData, product.getStatus().equals((Object)ProductStatus.EXCHANGE) || product.getStatus().equals((Object)ProductStatus.REFUND));
            AirProductFXHelper.fromVMAirAdditionalParameters(productPaneVM.getOtherParameters(), product);
            AirProductFXHelper.fromVMAirCost(productPaneVM.getCost(), product, productData);
            AirProductFXHelper.fromVMAirSegmentsAndFares(productPaneVM.getCost(), productPaneVM.getSegments().getContent(), product);
            StatisticalData data = product.getStatisticalData();
            if (data == null) {
                data = new StatisticalData();
                product.setStatisticalData(data);
            }
            GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), productPaneVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMFop((BaseProduct)product, productPaneVM.getFops(), (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMProductContract(productPaneVM.getFops().getContract(), (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, productPaneVM.getCommissions(), (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(productPaneVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        } else if (vm instanceof BookingFileProductEMDPanelVM) {
            BookingFileProductEMDPanelVM productPaneVM = (BookingFileProductEMDPanelVM)vm;
            AirProductFXHelper.fromVMEMDGeneralParameters(productPaneVM, bookingFile, product, productData, ProductStatus.REFUND.equals((Object)product.getStatus()) || ProductStatus.EXCHANGE.equals((Object)product.getStatus()));
            AirProductFXHelper.fromVMEMDAdditionalParameters(productPaneVM.getOtherParameters(), product);
            AirProductFXHelper.fromVMEMDRelatedProducts(productPaneVM.getRelated(), product);
            AirProductFXHelper.fromVMAirSegmentsAndFares(productPaneVM.getCost(), productPaneVM.getSegments().getContent(), product);
            AirProductFXHelper.fromVMAirCost(productPaneVM.getCost(), product, productData);
            StatisticalData data = product.getStatisticalData();
            if (data == null) {
                data = new StatisticalData();
                product.setStatisticalData(data);
            }
            GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), productPaneVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMFop((BaseProduct)product, productPaneVM.getFops(), (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMProductContract(productPaneVM.getFops().getContract(), (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, productPaneVM.getCommissions(), (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(productPaneVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        } else if (vm instanceof BookingFileProductBagagePanelVM) {
            BookingFileProductBagagePanelVM productPaneVM = (BookingFileProductBagagePanelVM)vm;
            AirProductFXHelper.fromVMBagageGeneralParameters(productPaneVM, bookingFile, product, productData, ProductStatus.REFUND.equals((Object)product.getStatus()) || ProductStatus.EXCHANGE.equals((Object)product.getStatus()));
            AirProductFXHelper.fromVMBagageAdditionalParameters(productPaneVM.getOtherParameters(), product);
            AirProductFXHelper.fromVMBagageRelatedProducts(productPaneVM.getRelated(), product);
            AirProductFXHelper.fromVMAirSegmentsAndFares(productPaneVM.getCost(), productPaneVM.getSegments().getContent(), product);
            AirProductFXHelper.fromVMAirCost(productPaneVM.getCost(), product, productData);
            StatisticalData data = product.getStatisticalData();
            if (data == null) {
                data = new StatisticalData();
                product.setStatisticalData(data);
            }
            GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), productPaneVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMFop((BaseProduct)product, productPaneVM.getFops(), (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMProductContract(productPaneVM.getFops().getContract(), (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, productPaneVM.getCommissions(), (BaseProductUIData)productData);
            GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(productPaneVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        }
    }

    @Override
    public ProductType getProductType(Product product) {
        return AirProductHelper.getProductType((Product)product);
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        if (node instanceof BookingFileProductEMDPanel) {
            BookingFileProductEMDSalesChainPane paramsPane = ((BookingFileProductEMDPanel)node).getGeneralNode().getSalesChainNode();
            return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)paramsPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)paramsPane.getSubagencyValueNode().getValue());
        }
        if (node instanceof BookingFileProductBagagePanel) {
            BookingFileProductBagageSalesChainPane paramsPane = ((BookingFileProductBagagePanel)node).getGeneralNode().getSalesChainNode();
            return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)paramsPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)paramsPane.getSubagencyValueNode().getValue());
        }
        BookingFileProductAirSalesChainPane paramsPane = ((BookingFileProductAirPanel)node).getGeneralNode().getSalesChainNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)paramsPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)paramsPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileProductAirPanel) {
            boolean emptyPaymentType;
            BookingFileProductAirPanel panel = (BookingFileProductAirPanel)node;
            String systemNumber = panel.getGeneralNode().getTicketInfoNode().getTicketNumberValueNode().getValue();
            List taxeCodes = ((TableWidget)((BookingFileProductAirFeesAndChargesPane)((PopupWidget)panel.getCostNode().getCell1Cell().getPayload()).getView()).getContent()).getRowsData().stream().map(el -> el.getCode()).collect(Collectors.toList());
            ProductCategory category = (ProductCategory)panel.getProperties().get((Object)"category");
            MCOCategory mcoCategory = (MCOCategory)panel.getProperties().get((Object)"mcoCategory");
            if (!"S7".equals(AirProductFXHandler.findOrganizationCode((EntityReference<Organization>)panel.getGeneralNode().getSalesChainNode().getBlankOwnerValueNode().getBlankOwnerCodeNode().getValue())) && category == ProductCategory.MCO) {
                return;
            }
            if (mcoCategory == MCOCategory.REBOOKING || mcoCategory == MCOCategory.SEAT_RESERVATION || mcoCategory == MCOCategory.DUPLICATE_TICKET) {
                for (String code : taxeCodes) {
                    if (!code.equalsIgnoreCase("RU")) continue;
                    String message = String.format(Messages.AirProductHandler_msoRuSa, systemNumber);
                    errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (L10nMessage)L10nResourcesManager.createL10nMessage((String)message, (Object[])new Object[0]), null));
                    break;
                }
            } else if (mcoCategory == MCOCategory.PENALTY) {
                for (String code : taxeCodes) {
                    if (!code.equalsIgnoreCase("SA")) continue;
                    String message = String.format(Messages.AirProductHandler_mcoSaRu, systemNumber);
                    errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (L10nMessage)L10nResourcesManager.createL10nMessage((String)message, (Object[])new Object[0]), null));
                    break;
                }
            }
            if (emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null)) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
            }
        } else if (node instanceof BookingFileProductEMDPanel) {
            boolean emptyPaymentType;
            BookingFileProductEMDPanel panel = (BookingFileProductEMDPanel)node;
            String systemNumber = ((BookingFileProductEMDGeneralPanel)panel.getGeneralCell().getPayload()).getTicketInfoNode().getTicketNumberValueNode().getValue();
            MCOCategory mcoCategory = (MCOCategory)((BookingFileProductEMDTicketInfoPane)((BookingFileProductEMDGeneralPanel)panel.getGeneralCell().getPayload()).getTicketInfoCell().getPayload()).getEmdCategoryValueNode().valueProperty().getValue();
            if (mcoCategory == null) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.EmdCategoryIsEmpty, (Object[])new Object[]{systemNumber}));
            }
            if (emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null)) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
            }
        } else if (node instanceof BookingFileProductBagagePanel) {
            BookingFileProductBagagePanel panel = (BookingFileProductBagagePanel)node;
            String systemNumber = ((BookingFileProductBagageGeneralPanel)panel.getGeneralCell().getPayload()).getTicketInfoNode().getTicketNumberValueNode().getValue();
            boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
            if (emptyPaymentType) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
            }
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        ArrayList<BookingFileProductStatisticUdidsVM> statisticUdidsVMS = new ArrayList<BookingFileProductStatisticUdidsVM>();
        if (node instanceof BookingFileProductAirPanel) {
            BookingFileProductAirPanel panel = (BookingFileProductAirPanel)node;
            statisticUdidsVMS.addAll(((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData());
        } else if (node instanceof BookingFileProductEMDPanel) {
            BookingFileProductEMDPanel panel = (BookingFileProductEMDPanel)node;
            statisticUdidsVMS.addAll(((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData());
        } else if (node instanceof BookingFileProductBagagePanel) {
            BookingFileProductBagagePanel panel = (BookingFileProductBagagePanel)node;
            statisticUdidsVMS.addAll(((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData());
        }
        GeneralProductFXHelper.validateStatisticalData(space, uid, statisticUdidsVMS, errors);
    }

    public static String findOrganizationCode(EntityReference<Organization> ref) throws Exception {
        EntityContainer ctr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).loadBypassingAcl(ServiceInvocationContext.get(), ref);
        return ctr != null ? ((Organization)ctr.getEntity()).getCode() : null;
    }
}

