/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCarRentalPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCarRentalPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCarRentalPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCarRentalParametersOwner;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.CarRentalProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductIndex;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CarRentalProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class CarRentalProductFXHandler
implements ProductFXHandler<CarRentalProduct, CarRentalProductIndex, CarRentalProductUIData, Void> {
    @Override
    public CarRentalProduct getPreviousProduct(CarRentalProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public CarRentalProduct getNextProduct(CarRentalProduct product) {
        return product.getNextProduct();
    }

    @Override
    public Class<CarRentalProduct> getProductClass() {
        return CarRentalProduct.class;
    }

    @Override
    public Class<CarRentalProductIndex> getProductIndexClass() {
        return CarRentalProductIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.CAR_RENTAL.toString();
    }

    @Override
    public ProductStatus getProductStatus(CarRentalProduct product) {
        return product.getStatus();
    }

    @Override
    public StatisticalData getStatisticalData(CarRentalProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(CarRentalProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public Collection<Traveller> getTravellers(CarRentalProduct product) {
        return product.getTravellers();
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public void setAgent(CarRentalProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void remove(CarRentalProduct product) {
        CarRentalProduct nextProduct;
        product.getReservation().getProducts().remove(product);
        CarRentalProduct previousProduct = product.getPreviousProduct();
        if (previousProduct != null) {
            previousProduct.setNextProduct(null);
        }
        if ((nextProduct = product.getNextProduct()) != null) {
            nextProduct.setPreviousProduct(null);
        }
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileCarRentalPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileCarRentalPanelVM productVM = new BookingFileCarRentalPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.CAR_RENTAL.toString());
        MiscUtil.Pair<CarRentalProduct, CarRentalProductUIData> prototypeData = CarRentalProductFXHelper.getPrototypeData();
        CarRentalProduct product = (CarRentalProduct)prototypeData.getFirst();
        CarRentalProductUIData productSupplementData = (CarRentalProductUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileCarRentalPanel node = new BookingFileCarRentalPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            CarRentalProductFXHelper.updateNode(node, bookingFileVM);
            BookingFileCarRentalPanelController controller = new BookingFileCarRentalPanelController(node, false);
            controller.readData(productVM);
            BookingFileCarRentalPanel bookingFileCarRentalPanel = node;
            return bookingFileCarRentalPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileCarRentalPanel node = new BookingFileCarRentalPanel(false);
        CarRentalProductFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public CarRentalProduct createProduct() {
        return new CarRentalProduct();
    }

    @Override
    public CarRentalProductUIData createUiData() {
        return new CarRentalProductUIData();
    }

    @Override
    public BaseProductVM createVM(CarRentalProduct product) {
        return new BookingFileCarRentalPanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileCarRentalPanelVM)vm).getReservationUid();
    }

    @Override
    public void toVM(CarRentalProduct product, CarRentalProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodes = Arrays.asList(ReasonCodeType.REASON_CODE_CAR, ReasonCodeType.REASON_CODE_DECLINED, ReasonCodeType.REASON_CODE_NO_HOTEL);
        BookingFileCarRentalPanelVM parentVM = (BookingFileCarRentalPanelVM)vm;
        parentVM.setReservationUid(product.getReservation().getUid());
        parentVM.setStatus(product.getStatus());
        CarRentalProductFXHelper.toVMParentParameters(product, parentVM);
        CarRentalProductFXHelper.toVMParameters(parentVM.getGeneral(), product, productData, parentVM.getStatuses());
        CarRentalProductFXHelper.toVMCost(parentVM.getCost(), product, productData);
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodes, CarRentalProduct.class, parentVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, parentVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, parentVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, parentVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, parentVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, parentVM.getCommissions());
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), parentVM.getOtherParameters().getValidation());
        CarRentalProductFXHelper.toVMComments(parentVM, product);
    }

    @Override
    public void fromVM(BaseProductVM vm, CarRentalProduct product, CarRentalProductUIData productData) {
        BookingFileCarRentalPanelVM parentVM = (BookingFileCarRentalPanelVM)vm;
        CarRentalProductFXHelper.fillBasicProductFields(product);
        CarRentalProductFXHelper.fromVMParameters(parentVM.getGeneral(), product, productData, parentVM.getStatuses());
        CarRentalProductFXHelper.fromVMCost(parentVM.getCost(), product);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, parentVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(parentVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, parentVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(parentVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), parentVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
        CarRentalProductFXHelper.fromVMComments(parentVM, product);
    }

    @Override
    public ProductType getProductType(CarRentalProduct product) {
        return ProductType.CAR_RENTAL;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductCarRentalParametersOwner paramsPane = ((BookingFileCarRentalPanel)node).getGeneralNode().getOwnerParametersNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)paramsPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)paramsPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        BookingFileCarRentalPanel panel = (BookingFileCarRentalPanel)node;
        String systemNumber = panel.getGeneralNode().getBaseInformationParametersNode().getTicketNumberValueNode().getValue();
        boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
        if (emptyPaymentType) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileCarRentalPanel) {
            BookingFileCarRentalPanel panel = (BookingFileCarRentalPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData(space, uid, statisticUdidsVMS, errors);
        }
    }
}

