/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCreateParametersPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.DeliveryFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.DeliveryUIData;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class DeliveryFXHandler
implements ProductFXHandler<Delivery, DeliveryIndex, DeliveryUIData, Void> {
    @Override
    public Class<Delivery> getProductClass() {
        return Delivery.class;
    }

    @Override
    public Class<DeliveryIndex> getProductIndexClass() {
        return DeliveryIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.DELIVERY.toString();
    }

    @Override
    public Delivery createProduct() {
        return new Delivery();
    }

    @Override
    public DeliveryUIData createUiData() {
        return new DeliveryUIData();
    }

    @Override
    public BaseProductVM createVM(Delivery product) {
        return new BookingFileProductDeliveryPanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductDeliveryPanelVM)vm).getReservationUid();
    }

    @Override
    public StatisticalData getStatisticalData(Delivery product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(Delivery product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public Collection<Traveller> getTravellers(Delivery product) {
        return Collections.emptyList();
    }

    @Override
    public void setAgent(Delivery product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void updateNewBookingFile(BookingFile bookingFile, BookingFileUIData bookingFileSupplementData, BookingFileCreateParametersPaneVM parameters) {
        MiscUtil.Pair<Delivery, DeliveryUIData> prototypeData = DeliveryFXHelper.getPrototypeData();
        Delivery product = (Delivery)prototypeData.getFirst();
        DeliveryUIData productSupplementData = (DeliveryUIData)prototypeData.getSecond();
        Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        product.setAddressee(reservation.getBookingFile().getCustomerProfile());
        bookingFileSupplementData.getProducts().add(productSupplementData);
    }

    @Override
    public boolean isShowCreateDialog() {
        return true;
    }

    @Override
    public void toVM(Delivery product, DeliveryUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodes = Arrays.asList(ReasonCodeType.REASON_CODE_DECLINED, ReasonCodeType.REASON_CODE_NO_HOTEL);
        BookingFileProductDeliveryPanelVM parentVM = (BookingFileProductDeliveryPanelVM)vm;
        parentVM.setReservationUid(product.getReservation().getUid());
        parentVM.setStatus(product.getStatus());
        parentVM.getFops().setProductType(Delivery.class);
        DeliveryFXHelper.toVMDeliveryOverviewParameters(parentVM, product, productData);
        DeliveryFXHelper.toVMDeliveryGeneralParameters(parentVM.getGeneral(), product, productData, parentVM.getStatuses());
        DeliveryFXHelper.toVMDeliveryContents(parentVM.getParameters(), product, productData);
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodes, Delivery.class, parentVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), parentVM.getOtherParameters().getValidation());
        DeliveryFXHelper.toVMDeliveryComments(parentVM, product);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, parentVM.getFops());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, parentVM.getCommissions());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, parentVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, parentVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, parentVM.getFops().getVendorFinanceDocumentsData());
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductDeliveryPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileProductDeliveryPanelVM productVM = new BookingFileProductDeliveryPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.DELIVERY.toString());
        MiscUtil.Pair<Delivery, DeliveryUIData> prototypeData = DeliveryFXHelper.getPrototypeData();
        Delivery product = (Delivery)prototypeData.getFirst();
        DeliveryUIData productSupplementData = (DeliveryUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        product.setAddressee(reservation.getBookingFile().getCustomerProfile());
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileProductDeliveryPanel node = new BookingFileProductDeliveryPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            DeliveryFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductDeliveryPanelController controller = new BookingFileProductDeliveryPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductDeliveryPanel bookingFileProductDeliveryPanel = node;
            return bookingFileProductDeliveryPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductDeliveryPanel node = new BookingFileProductDeliveryPanel(false);
        DeliveryFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public void remove(Delivery product) {
        product.getReservation().getProducts().remove(product);
        if (product.getStatus() == DeliveryStatus.RETURNED) {
            product.getPreviousProduct().setNextProduct(null);
            product.setPreviousProduct(null);
        }
    }

    @Override
    public Delivery getPreviousProduct(Delivery product) {
        return product.getPreviousProduct();
    }

    @Override
    public Delivery getNextProduct(Delivery product) {
        return product.getNextProduct();
    }

    @Override
    public ProductStatus getProductStatus(Delivery baseProduct) {
        return null;
    }

    @Override
    public void fromVM(BaseProductVM vm, Delivery product, DeliveryUIData productData) {
        if (product.getReservation() == null) {
            Reservation reservation = DeliveryFXHelper.findReservationForDelivery(vm.getBookingFile());
            product.setReservation(reservation);
            reservation.getProducts().add(product);
        }
        BookingFileProductDeliveryPanelVM fullVM = (BookingFileProductDeliveryPanelVM)vm;
        DeliveryFXHelper.fromVMDeliveryGeneralParameters(fullVM.getGeneral(), product, fullVM.getStatuses());
        DeliveryFXHelper.fromVMDeliveryContents(fullVM.getParameters(), product);
        product.setComments(fullVM.getOtherParameters().getPopups().getComments());
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, fullVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(fullVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(fullVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, fullVM.getCommissions(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), fullVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
        product.setStatisticalData(data);
    }

    @Override
    public ProductType getProductType(Delivery product) {
        return ProductType.DELIVERY;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        return Collections.singleton(ContractType.SUBAGENCY);
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        BookingFileProductDeliveryPanel panel = (BookingFileProductDeliveryPanel)node;
        String systemNumber = panel.getGeneralNode().getGeneralNode().getNumberValueNode().getValue();
        boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
        if (emptyPaymentType) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileProductDeliveryPanel) {
            BookingFileProductDeliveryPanel panel = (BookingFileProductDeliveryPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData(space, uid, statisticUdidsVMS, errors);
        }
    }

    public static ProductStatus getProductStatus(DeliveryStatus status) {
        if (status == null) {
            return ProductStatus.VOID;
        }
        switch (status) {
            case VOID: {
                return ProductStatus.VOID;
            }
            case PLANNED: 
            case COMPLETED: {
                return ProductStatus.SELL;
            }
            case RETURNED: {
                return ProductStatus.REFUND;
            }
        }
        return ProductStatus.VOID;
    }
}

