/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVoidingPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVoidingPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVoidingPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.ProductVoidingFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.VoidingProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class ProductVoidingFXHandler
implements ProductFXHandler<ProductVoiding, CommonProductIndex, VoidingProductUIData, Void> {
    @Override
    public Class<ProductVoiding> getProductClass() {
        return ProductVoiding.class;
    }

    @Override
    public Class<CommonProductIndex> getProductIndexClass() {
        return CommonProductIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.PRODUCT_VOIDING.toString();
    }

    @Override
    public ProductStatus getProductStatus(ProductVoiding product) {
        return ProductStatus.SELL;
    }

    @Override
    public void remove(ProductVoiding product) {
        product.getReservation().getProducts().remove(product);
    }

    @Override
    public ProductVoiding createProduct() {
        return new ProductVoiding();
    }

    @Override
    public VoidingProductUIData createUiData() {
        return new VoidingProductUIData();
    }

    @Override
    public BaseProductVM createVM(ProductVoiding product) {
        return new BookingFileProductVoidingPanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductVoidingPanelVM)vm).getReservationUid();
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductVoidingPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileProductVoidingPanelVM productVM = new BookingFileProductVoidingPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.PRODUCT_VOIDING.toString());
        MiscUtil.Pair<ProductVoiding, VoidingProductUIData> prototypeData = ProductVoidingFXHelper.getPrototypeData();
        ProductVoiding product = (ProductVoiding)prototypeData.getFirst();
        VoidingProductUIData productSupplementData = (VoidingProductUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileProductVoidingPanel node = new BookingFileProductVoidingPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            ProductVoidingFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductVoidingPanelController controller = new BookingFileProductVoidingPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductVoidingPanel bookingFileProductVoidingPanel = node;
            return bookingFileProductVoidingPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductVoidingPanel node = new BookingFileProductVoidingPanel(false);
        ProductVoidingFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public boolean canCreateNewProduct() {
        return false;
    }

    @Override
    public ProductVoiding getPreviousProduct(ProductVoiding product) {
        return null;
    }

    @Override
    public ProductVoiding getNextProduct(ProductVoiding product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(ProductVoiding product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(ProductVoiding product) {
    }

    @Override
    public Collection<Traveller> getTravellers(ProductVoiding product) {
        throw new UnsupportedOperationException("getTravellers(final ProductVoiding product) is not implemented");
    }

    @Override
    public void setAgent(ProductVoiding product, EntityReference<Person> agent) {
    }

    @Override
    public void toVM(ProductVoiding product, VoidingProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodeTypes = Arrays.asList(ReasonCodeType.REASON_CODE_AIR, ReasonCodeType.REASON_CODE_NO_HOTEL, ReasonCodeType.REASON_CODE_DECLINED);
        BookingFileProductVoidingPanelVM parentVM = (BookingFileProductVoidingPanelVM)vm;
        parentVM.setReservationUid(product.getReservation().getUid());
        ProductVoidingFXHelper.toVMParameters(product, parentVM.getGeneral());
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, parentVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, parentVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, parentVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, parentVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, parentVM.getCommissions());
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodeTypes, ProductVoiding.class, parentVM.getOtherParameters().getStatistic(), customerProfile);
    }

    @Override
    public void fromVM(BaseProductVM vm, ProductVoiding product, VoidingProductUIData productData) {
        BookingFileProductVoidingPanelVM parentVM = (BookingFileProductVoidingPanelVM)vm;
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)parentVM.getGeneral().getTicketInfo().getTicketInformation().getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)parentVM.getGeneral().getTicketInfo().getTicketInformation().getShipmentsDateSubagentValue()));
        product.setType(parentVM.getGeneral().getTicketInfo().getTicketInformation().getTypeValue());
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, parentVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(parentVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(parentVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, parentVM.getCommissions(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), parentVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
    }

    @Override
    public ProductType getProductType(ProductVoiding product) {
        return null;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        return Collections.emptySet();
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        if (node instanceof BookingFileProductVoidingPanel) {
            BookingFileProductVoidingPanel panel = (BookingFileProductVoidingPanel)node;
            String systemNumber = ProductType.PRODUCT_VOIDING + " " + panel.getGeneralNode().getTicketInfoNode().getTicketInformationNode().getProductValueNode().getText();
            boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
            if (emptyPaymentType) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
            }
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
    }
}

