/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.TransferFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndex;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.TransferProductXtripUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class TransferFXHandler
implements ProductFXHandler<Transfer, TransferIndex, TransferProductXtripUIData, Void> {
    @Override
    public Transfer getPreviousProduct(Transfer product) {
        return product.getPreviousProduct();
    }

    @Override
    public Transfer getNextProduct(Transfer product) {
        return product.getNextProduct();
    }

    @Override
    public Class<Transfer> getProductClass() {
        return Transfer.class;
    }

    @Override
    public Class<TransferIndex> getProductIndexClass() {
        return TransferIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.TRANSFER.toString();
    }

    @Override
    public ProductStatus getProductStatus(Transfer product) {
        return product.getStatus();
    }

    @Override
    public StatisticalData getStatisticalData(Transfer product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(Transfer product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public Collection<Traveller> getTravellers(Transfer product) {
        return product.getTravellers();
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public void setAgent(Transfer product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void remove(Transfer product) {
        Transfer nextProduct;
        product.getReservation().getProducts().remove(product);
        Transfer previousProduct = product.getPreviousProduct();
        if (previousProduct != null) {
            previousProduct.setNextProduct(null);
        }
        if ((nextProduct = product.getNextProduct()) != null) {
            nextProduct.setPreviousProduct(null);
        }
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductTransferXtripPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileProductTransferXtripPanelVM productVM = new BookingFileProductTransferXtripPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.TRANSFER.toString());
        MiscUtil.Pair<Transfer, TransferProductXtripUIData> prototypeData = TransferFXHelper.getPrototypeData();
        Transfer product = (Transfer)prototypeData.getFirst();
        TransferProductXtripUIData productSupplementData = (TransferProductXtripUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileProductTransferXtripPanel node = new BookingFileProductTransferXtripPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            TransferFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductTransferXtripPanelController controller = new BookingFileProductTransferXtripPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductTransferXtripPanel bookingFileProductTransferXtripPanel = node;
            return bookingFileProductTransferXtripPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductTransferXtripPanel node = new BookingFileProductTransferXtripPanel(false);
        TransferFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public Transfer createProduct() {
        return new Transfer();
    }

    @Override
    public TransferProductXtripUIData createUiData() {
        return new TransferProductXtripUIData();
    }

    @Override
    public BaseProductVM createVM(Transfer product) {
        return new BookingFileProductTransferXtripPanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductTransferXtripPanelVM)vm).getGeneral().getTicketInfo().getBookingNumberValue();
    }

    @Override
    public void toVM(Transfer product, TransferProductXtripUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodes = Arrays.asList(ReasonCodeType.REASON_CODE_CAR, ReasonCodeType.REASON_CODE_DECLINED, ReasonCodeType.REASON_CODE_NO_HOTEL);
        BookingFileProductTransferXtripPanelVM productVM = (BookingFileProductTransferXtripPanelVM)vm;
        productVM.setReservationUid(product.getReservation().getUid());
        TransferFXHelper.toVM(product, productData, productVM);
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodes, Transfer.class, productVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, productVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, productVM.getFops().getContract());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, productVM.getCommissions());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, productVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, productVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), productVM.getOtherParameters().getValidation());
    }

    @Override
    public void fromVM(BaseProductVM vm, Transfer product, TransferProductXtripUIData productData) {
        BookingFileProductTransferXtripPanelVM productVM = (BookingFileProductTransferXtripPanelVM)vm;
        TransferFXHelper.fromVM(productVM, product, productData);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, productVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(productVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, productVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(productVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), productVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
    }

    @Override
    public ProductType getProductType(Transfer product) {
        return ProductType.TRANSFER;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductTransferXtripSalesChainPane paramsPane = ((BookingFileProductTransferXtripPanel)node).getGeneralNode().getSalesChainNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)paramsPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)paramsPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        if (node instanceof BookingFileProductTransferXtripPanel) {
            BookingFileProductTransferXtripPanel panel = (BookingFileProductTransferXtripPanel)node;
            String systemNumber = panel.getGeneralNode().getTicketInfoNode().getTicketNumberValueNode().getValue();
            boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
            if (emptyPaymentType) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
            }
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileProductTransferXtripPanel) {
            BookingFileProductTransferXtripPanel panel = (BookingFileProductTransferXtripPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData(space, uid, statisticUdidsVMS, errors);
        }
    }
}

