/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileUniversalProductParametersOwner;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.UniversalProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.UniversalProductDescriptionData;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.UniversalProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class UniversalProductFXHandler
implements ProductFXHandler<UniversalProduct, UniversalProductIndex, UniversalProductUIData, Void> {
    @Override
    public UniversalProduct getPreviousProduct(UniversalProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public UniversalProduct getNextProduct(UniversalProduct product) {
        return product.getNextProduct();
    }

    @Override
    public Class<UniversalProduct> getProductClass() {
        return UniversalProduct.class;
    }

    @Override
    public Class<UniversalProductIndex> getProductIndexClass() {
        return UniversalProductIndex.class;
    }

    @Override
    public String getDisplayName() {
        return L10nResourcesManager.getStr((String)"UNIVERSAL_PRODUCT_NAME", (Object[])new Object[0]);
    }

    @Override
    public ProductStatus getProductStatus(UniversalProduct product) {
        return product.getStatus();
    }

    @Override
    public void remove(UniversalProduct product) {
        UniversalProduct nextProduct;
        product.getReservation().getProducts().remove(product);
        UniversalProduct previousProduct = product.getPreviousProduct();
        if (previousProduct != null) {
            previousProduct.setNextProduct(null);
        }
        if ((nextProduct = product.getNextProduct()) != null) {
            nextProduct.setPreviousProduct(null);
        }
    }

    @Override
    public StatisticalData getStatisticalData(UniversalProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(UniversalProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public Collection<Traveller> getTravellers(UniversalProduct product) {
        return product.getReservation().getBookingFile().getTravellers();
    }

    @Override
    public void setAgent(UniversalProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public ProductType getProductType(UniversalProduct product) {
        return null;
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileUniversalProductPanelVM)vm).getReservationUid();
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileUniversalProductPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        UniversalProductDescriptionData descriptionData = (UniversalProductDescriptionData)parameters.get("universalProductDescriptionData");
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileUniversalProductPanelVM productVM = new BookingFileUniversalProductPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(descriptionData.getReference().toString() + " " + ProductStatus.SELL.toString());
        MiscUtil.Pair<UniversalProduct, UniversalProductUIData> prototypeData = UniversalProductFXHelper.getPrototypeData((EntityReference<UniversalProductDescription>)descriptionData.getReference());
        UniversalProduct product = (UniversalProduct)prototypeData.getFirst();
        UniversalProductUIData productSupplementData = (UniversalProductUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileUniversalProductPanel node = new BookingFileUniversalProductPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            UniversalProductFXHelper.updateNode(node, bookingFileVM);
            BookingFileUniversalProductPanelController controller = new BookingFileUniversalProductPanelController(node, false);
            controller.getView().getProperties().put((Object)"universalProductDescriptionData", (Object)descriptionData);
            controller.readData(productVM);
            BookingFileUniversalProductPanel bookingFileUniversalProductPanel = node;
            return bookingFileUniversalProductPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileUniversalProductPanel node = new BookingFileUniversalProductPanel(false);
        UniversalProductFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public UniversalProductUIData createUiData() {
        return new UniversalProductUIData();
    }

    @Override
    public UniversalProduct createProduct() {
        return new UniversalProduct();
    }

    @Override
    public BaseProductVM createVM(UniversalProduct product) {
        return new BookingFileUniversalProductPanelVM();
    }

    @Override
    public void toVM(UniversalProduct product, UniversalProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        ArrayList<ReasonCodeType> reasonCodes = new ArrayList<ReasonCodeType>();
        BookingFileUniversalProductPanelVM parentVM = (BookingFileUniversalProductPanelVM)vm;
        parentVM.setReservationUid(product.getReservation().getUid());
        parentVM.setRefDescription(product.getDescription());
        parentVM.setStatus(product.getStatus());
        UniversalProductFXHelper.toVMParentParameters(product, parentVM);
        UniversalProductFXHelper.toVMParameters(parentVM.getGeneral(), product, productData, parentVM.getStatuses());
        UniversalProductFXHelper.toVMCost(parentVM, product, productData.getVatAmount(), UniversalProductFXHelper.getDescription(product).isBaseFareSupported());
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodes, UniversalProduct.class, parentVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, parentVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, parentVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, parentVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, parentVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, parentVM.getCommissions());
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), parentVM.getOtherParameters().getValidation());
        UniversalProductFXHelper.toVMComments(parentVM.getOtherParameters().getPopups(), product);
        UniversalProductFXHelper.toVMDetailingParameters(parentVM.getDetailing(), product);
        parentVM.getOtherParameters().setInfo(product.getNotes());
    }

    @Override
    public void fromVM(BaseProductVM vm, UniversalProduct product, UniversalProductUIData productData) {
        BookingFileUniversalProductPanelVM parentVM = (BookingFileUniversalProductPanelVM)vm;
        product.setDescription(parentVM.getRefDescription());
        UniversalProductFXHelper.fillBasicProductFields(product);
        UniversalProductFXHelper.fromVMParameters(parentVM.getGeneral(), product, productData, parentVM.getStatuses());
        UniversalProductFXHelper.fromVMCost(parentVM.getCost(), product);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, parentVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(parentVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, parentVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(parentVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), parentVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
        UniversalProductFXHelper.fromVMComments(parentVM.getOtherParameters().getPopups(), product);
        UniversalProductFXHelper.fromVMDetailingParameters(parentVM.getDetailing(), product);
        product.setNotes(parentVM.getOtherParameters().getInfo());
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileUniversalProductParametersOwner paramsPane = ((BookingFileUniversalProductPanel)node).getGeneralNode().getOwnerParametersNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)paramsPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)paramsPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        BookingFileUniversalProductPanel panel = (BookingFileUniversalProductPanel)node;
        String systemNumber = panel.getGeneralNode().getBaseInformationParametersNode().getTicketNumberValueNode().getValue();
        boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
        if (emptyPaymentType) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileUniversalProductPanel) {
            BookingFileUniversalProductPanel panel = (BookingFileUniversalProductPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData(space, uid, statisticUdidsVMS, errors);
        }
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public boolean isNeedReloadPrefetched(UniversalProduct product) {
        return product.getDescription() != null && Prefetched.getData().getUniversalProductDescriptionData().stream().noneMatch(descriptionData -> product.getDescription().equals((Object)descriptionData.getReference()));
    }
}

