/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductVisaParametersOwner;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.VisaProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.VisaProductUIData;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductIndex;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class VisaProductFXHandler
implements ProductFXHandler<VisaProduct, VisaProductIndex, VisaProductUIData, Void> {
    @Override
    public VisaProduct getPreviousProduct(VisaProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public VisaProduct getNextProduct(VisaProduct product) {
        return product.getNextProduct();
    }

    @Override
    public Class<VisaProduct> getProductClass() {
        return VisaProduct.class;
    }

    @Override
    public Class<VisaProductIndex> getProductIndexClass() {
        return VisaProductIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.VISA_PRODUCT.toString();
    }

    @Override
    public StatisticalData getStatisticalData(VisaProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(VisaProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public Collection<Traveller> getTravellers(VisaProduct product) {
        return product.getTravellers();
    }

    @Override
    public void setAgent(VisaProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public ProductStatus getProductStatus(VisaProduct product) {
        return product.getStatus();
    }

    @Override
    public void remove(VisaProduct product) {
        VisaProduct nextProduct;
        product.getReservation().getProducts().remove(product);
        VisaProduct previousProduct = product.getPreviousProduct();
        if (previousProduct != null) {
            previousProduct.setNextProduct(null);
        }
        if ((nextProduct = product.getNextProduct()) != null) {
            nextProduct.setPreviousProduct(null);
        }
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductVisaPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileProductVisaPanelVM productVM = new BookingFileProductVisaPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.VISA_PRODUCT.toString());
        MiscUtil.Pair<VisaProduct, VisaProductUIData> prototypeData = VisaProductFXHelper.getPrototypeData();
        VisaProduct product = (VisaProduct)prototypeData.getFirst();
        VisaProductUIData productSupplementData = (VisaProductUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileProductVisaPanel node = new BookingFileProductVisaPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            VisaProductFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductVisaPanelController controller = new BookingFileProductVisaPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductVisaPanel bookingFileProductVisaPanel = node;
            return bookingFileProductVisaPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductVisaPanel node = new BookingFileProductVisaPanel(false);
        VisaProductFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public VisaProduct createProduct() {
        return new VisaProduct();
    }

    @Override
    public VisaProductUIData createUiData() {
        return new VisaProductUIData();
    }

    @Override
    public BaseProductVM createVM(VisaProduct product) {
        return new BookingFileProductVisaPanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductVisaPanelVM)vm).getReservationUid();
    }

    @Override
    public void toVM(VisaProduct product, VisaProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodes = Arrays.asList(ReasonCodeType.REASON_CODE_VISA, ReasonCodeType.REASON_CODE_DECLINED, ReasonCodeType.REASON_CODE_NO_HOTEL);
        BookingFileProductVisaPanelVM parentVM = (BookingFileProductVisaPanelVM)vm;
        parentVM.setReservationUid(product.getReservation().getUid());
        VisaProductFXHelper.toVMParentParameters(product, parentVM);
        VisaProductFXHelper.toVMParameters(parentVM.getGeneral(), product, productData, parentVM.getStatuses());
        VisaProductFXHelper.toVMCost(parentVM.getCost(), product);
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodes, VisaProduct.class, parentVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, parentVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, parentVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, parentVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, parentVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, parentVM.getCommissions());
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), parentVM.getOtherParameters().getValidation());
        VisaProductFXHelper.toVMComments(parentVM, product);
    }

    @Override
    public void fromVM(BaseProductVM vm, VisaProduct product, VisaProductUIData productData) {
        BookingFileProductVisaPanelVM productVM = (BookingFileProductVisaPanelVM)vm;
        VisaProductFXHelper.fillBasicProductFields(product);
        VisaProductFXHelper.fromVMParameters(productVM.getGeneral(), product, productData, productVM.getStatuses());
        VisaProductFXHelper.fromVMCost(productVM.getCost(), product);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, productVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(productVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, productVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(productVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), productVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
        VisaProductFXHelper.fromVMComments(productVM, product);
    }

    @Override
    public ProductType getProductType(VisaProduct product) {
        return ProductType.VISA_PRODUCT;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductVisaParametersOwner paramsPane = ((BookingFileProductVisaPanel)node).getGeneralNode().getOwnerParametersNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)paramsPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)paramsPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        BookingFileProductVisaPanel panel = (BookingFileProductVisaPanel)node;
        String systemNumber = panel.getGeneralNode().getBaseInformationParametersNode().getVisaNumberValueNode().getValue();
        boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
        if (emptyPaymentType) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileProductVisaPanel) {
            BookingFileProductVisaPanel panel = (BookingFileProductVisaPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData(space, uid, statisticUdidsVMS, errors);
        }
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }
}

