/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductComponentsItemGroupVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductComponentsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductParametersBaseInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductParametersNumberVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductParametersOwnerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgencyMemoProductStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryAssociationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.uidata.AgencyMemoProductUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.stream.Collectors;

public class AgencyMemoProductFXHelper {
    public static void toVMParentParameters(AgencyMemoProduct product, BookingFileAgencyMemoProductPanelVM vm) {
        vm.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        vm.setUid(product.getUid());
        vm.setBookingFile(product.getReservation().getBookingFile());
    }

    public static void toVMParameters(BookingFileAgencyMemoGeneralPanelVM view, BookingFileAgencyMemoProductStatusesPaneVM statuses, AgencyMemoProduct product, AgencyMemoProductUIData productData) {
        AgencyMemoProductFXHelper.toVMInformationParameters(view.getBaseInformationParameters(), product);
        AgencyMemoProductFXHelper.toVMOwnerParameters(view.getOwnerParameters(), product);
        AgencyMemoProductFXHelper.toVMControlStatusParameters(statuses, product, productData);
    }

    private static void toVMControlStatusParameters(BookingFileAgencyMemoProductStatusesPaneVM statusesVM, AgencyMemoProduct product, AgencyMemoProductUIData productData) {
        statusesVM.setChecked(product.isChecked());
        statusesVM.setFinished(product.isCompleted());
        statusesVM.setHasErrors(productData.isHasErrors());
        statusesVM.setRulesApplied(productData.isHasWarnings());
    }

    private static void toVMOwnerParameters(BookingFileAgencyMemoProductParametersOwnerVM ownerParameters, AgencyMemoProduct product) {
        ownerParameters.setAcceptDateValue(DateUtils.asLocalDate((Date)product.getAcceptDate()));
        ownerParameters.setIssueDateValue(DateUtils.asLocalDate((Date)product.getIssueDate()));
        ownerParameters.setSourceReportDateValue(DateUtils.asLocalDate((Date)product.getSourceReportDate()));
        ownerParameters.setTargetReportDateValue(DateUtils.asLocalDate((Date)product.getTargetReportDate()));
        ownerParameters.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        ownerParameters.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        ownerParameters.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        ownerParameters.setIncludeToReport(product.isIncludeToReport());
    }

    private static void toVMInformationParameters(BookingFileAgencyMemoProductParametersBaseInfoVM infoVM, AgencyMemoProduct product) {
        infoVM.setAgencyValue(product.getAgency());
        infoVM.setSupplierValue(product.getSupplier());
        infoVM.setTypeValue(product.getType());
        infoVM.setTicketTypeValue(product.getTicketType());
        infoVM.setBlankOwnerValue(product.getBlankOwner());
        BookingFileAgencyMemoProductParametersNumberVM numberVM = infoVM.getNumberValue();
        numberVM.setAirlineNumber(product.getAirlineCode());
        numberVM.setSystemNumber(product.getSystemNumber());
        infoVM.setContractValue(product.getContract());
    }

    public static void toVMItemGroups(BookingFileAgencyMemoProductComponentsVM components, AgencyMemoProduct product) {
        VMHelper.transfer(product.getItemGroups(), components.getItemGroup(), vm -> new BookingFileAgencyMemoProductComponentsItemGroupVM(), (itemGroup, vm) -> {
            vm.setType(itemGroup.getType());
            vm.setMoney(itemGroup.getAmount());
            vm.setEquivalentAmount(itemGroup.getEquivalentAmount());
            StringBuffer numberRelatedProducts = new StringBuffer();
            product.getEntries().forEach(entry -> {
                if (itemGroup.getType().equals((Object)entry.getType())) {
                    if (AgencyMemoProductEntryAssociationType.REPORT.equals((Object)entry.getAssociationType())) {
                        vm.setIsReport(true);
                    } else {
                        if (numberRelatedProducts.length() != 0) {
                            numberRelatedProducts.append(", ");
                        }
                        numberRelatedProducts.append(entry.getRelatedProductNumber());
                    }
                }
            });
            vm.setNumberRelatedProducts(numberRelatedProducts.toString());
            vm.setDescription(itemGroup.getDescription());
            VMHelper.transfer(itemGroup.getEntries(), vm.getEntriesGroup());
        });
    }

    public static void toVMRelatedProducts(BookingFileAgencyMemoProductComponentsVM components, AgencyMemoProduct product) {
        VMHelper.transfer(product.getRelatedProductGroups(), components.getRelatedGroups());
        VMHelper.transfer(product.getEntries(), components.getEntries());
    }

    public static void fromVMItemGroups(BookingFileAgencyMemoProductComponentsVM components, AgencyMemoProduct product) {
        ArrayList temp = new ArrayList();
        components.getItemGroup().stream().collect(Collectors.groupingBy(BookingFileAgencyMemoProductComponentsItemGroupVM::getType)).forEach((type, listItemGroupVM) -> {
            BookingFileAgencyMemoProductComponentsItemGroupVM itemGroupVM = (BookingFileAgencyMemoProductComponentsItemGroupVM)listItemGroupVM.get(0);
            listItemGroupVM.stream().filter(el -> !itemGroupVM.getUid().equals(el.getUid())).forEach(element -> itemGroupVM.getEntriesGroup().addAll(element.getEntriesGroup()));
            temp.add(itemGroupVM);
        });
        VMHelper.transfer(temp, product.getItemGroups(), item -> new AgencyMemoProductItemGroup(), (itemVM, item) -> {
            item.setType(itemVM.getType());
            item.setDescription(itemVM.getDescription());
            item.setAmount(itemVM.getMoney());
            item.setEquivalentAmount(itemVM.getEquivalentAmount());
            item.getEntries().clear();
            item.getEntries().addAll(components.getEntries().stream().filter(entry -> entry.getType().equals((Object)itemVM.getType())).collect(Collectors.toList()));
        });
    }

    public static void fromVMRelatedProducts(BookingFileAgencyMemoProductComponentsVM components, AgencyMemoProduct product) {
        components.getEntries().forEach(entry -> entry.setProduct(product));
        components.getRelatedGroups().forEach(group -> group.getEntries().forEach(entry -> entry.setProduct(product)));
        VMHelper.transfer(components.getEntries(), product.getEntries());
        VMHelper.transfer(components.getRelatedGroups(), product.getRelatedProductGroups());
    }

    public static void fromVMParameters(BookingFileAgencyMemoGeneralPanelVM view, BookingFileAgencyMemoProductStatusesPaneVM statuses, AgencyMemoProduct product, AgencyMemoProductUIData productData) {
        AgencyMemoProductFXHelper.fromVMInformationParameters(view.getBaseInformationParameters(), product);
        AgencyMemoProductFXHelper.fromVMOwnerParameters(view.getOwnerParameters(), product);
        AgencyMemoProductFXHelper.fromVMControlStatusParameters(statuses, product, productData);
    }

    private static void fromVMControlStatusParameters(BookingFileAgencyMemoProductStatusesPaneVM statusesVM, AgencyMemoProduct product, AgencyMemoProductUIData productData) {
        product.setChecked(statusesVM.isChecked());
        product.setCompleted(statusesVM.isFinished());
        productData.setHasErrors(statusesVM.isHasErrors());
    }

    private static void fromVMOwnerParameters(BookingFileAgencyMemoProductParametersOwnerVM ownerVM, AgencyMemoProduct product) {
        product.setAcceptDate(DateUtils.asDate((LocalDate)ownerVM.getAcceptDateValue()));
        product.setIssueDate(DateUtils.asDate((LocalDate)ownerVM.getIssueDateValue()));
        product.setSourceReportDate(DateUtils.asDate((LocalDate)ownerVM.getSourceReportDateValue()));
        product.setTargetReportDate(DateUtils.asDate((LocalDate)ownerVM.getTargetReportDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)ownerVM.getCorrectionDateValue()));
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)ownerVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)ownerVM.getShipmentsDateSubagentValue()));
        product.setIncludeToReport(ownerVM.isIncludeToReport());
    }

    private static void fromVMInformationParameters(BookingFileAgencyMemoProductParametersBaseInfoVM infoVM, AgencyMemoProduct product) {
        product.setAgency(infoVM.getAgencyValue());
        product.setContract(infoVM.getContractValue());
        product.setBlankOwner(infoVM.getBlankOwnerValue());
        product.setType(infoVM.getTypeValue());
        product.setTicketType(infoVM.getTicketTypeValue());
        product.setSupplier(infoVM.getSupplierValue());
        BookingFileAgencyMemoProductParametersNumberVM numberValue = infoVM.getNumberValue();
        product.setAirlineCode(numberValue.getAirlineNumber());
        product.setSystemNumber(numberValue.getSystemNumber());
    }

    public static MiscUtil.Pair<AgencyMemoProduct, AgencyMemoProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        AgencyMemoProduct product = new AgencyMemoProduct();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new AgencyMemoProduct(), (Object)new AgencyMemoProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileAgencyMemoProductPanel node, BookingFileSpaceVM bookingFileVM) {
    }
}

