/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgentTouchGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgentTouchPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAgentTouchStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAgentTouchMainTicketInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAgentTouchOwnerParametersVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouch;
import com.gridnine.xtrip.common.model.booking.uidata.AgentTouchProductUIData;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

public class AgentTouchFXHelper {
    public static void toVMParameters(AgentTouch product, BookingFileAgentTouchGeneralPanelVM vm, BookingFileAgentTouchStatusesPaneVM statuses, AgentTouchProductUIData productData) {
        AgentTouchFXHelper.toVMTicketParameters(product, vm.getTicketInfo());
        AgentTouchFXHelper.toVMOwnerParameters(product, vm.getOwnerParameters(), productData);
        AgentTouchFXHelper.toVMControlStatusParameters(statuses, product, productData);
    }

    public static void fromVMParameters(AgentTouch product, BookingFileAgentTouchGeneralPanelVM vm, BookingFileAgentTouchStatusesPaneVM statuses, AgentTouchProductUIData productData) {
        AgentTouchFXHelper.fromVMTicketParameters(product, vm.getTicketInfo());
        AgentTouchFXHelper.fromVMOwnerParameters(product, vm.getOwnerParameters(), productData);
        AgentTouchFXHelper.fromVMControlStatusParameters(statuses, product, productData);
    }

    private static void toVMTicketParameters(AgentTouch product, BookingFileProductAgentTouchMainTicketInfoVM vm) {
        vm.setAgentSignatureValue(product.getAgentSignature());
        vm.setDateValue(DateUtils.asLocalDate((Date)product.getIssueDate()));
        vm.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        vm.setDescriptionValue(product.getDescription());
        vm.setTypeValue(product.getType());
        vm.setTicketTypeValue(product.getTicketType());
    }

    private static void toVMOwnerParameters(AgentTouch product, BookingFileProductAgentTouchOwnerParametersVM vm, AgentTouchProductUIData productData) {
        vm.setSupplierValue(productData.getSupplier());
        vm.setAgencyValue(productData.getAgency());
        vm.setSubagencyValue(productData.getSubagency());
        vm.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        vm.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
    }

    private static void toVMControlStatusParameters(BookingFileAgentTouchStatusesPaneVM statusesVM, AgentTouch product, AgentTouchProductUIData productData) {
        statusesVM.setChecked(product.isChecked());
        statusesVM.setFinished(product.isCompleted());
        statusesVM.setHasErrors(productData.isHasErrors());
        statusesVM.setHasWarnings(productData.isHasWarnings());
        statusesVM.setRulesApplied(product.isContractRulesApplied());
    }

    private static void fromVMTicketParameters(AgentTouch product, BookingFileProductAgentTouchMainTicketInfoVM vm) {
        product.setAgentSignature(vm.getAgentSignatureValue());
        product.setIssueDate(DateUtils.asDate((LocalDate)vm.getDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)vm.getCorrectionDateValue()));
        product.setDescription(vm.getDescriptionValue());
        product.setType(vm.getTypeValue());
        product.setTicketType(vm.getTicketTypeValue());
    }

    private static void fromVMOwnerParameters(AgentTouch product, BookingFileProductAgentTouchOwnerParametersVM vm, AgentTouchProductUIData productData) {
        productData.setSupplier(vm.getSupplierValue());
        productData.setAgency(vm.getAgencyValue());
        productData.setSubagency(vm.getSubagencyValue());
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)vm.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)vm.getShipmentsDateSubagentValue()));
    }

    private static void fromVMControlStatusParameters(BookingFileAgentTouchStatusesPaneVM statusesVM, AgentTouch product, AgentTouchProductUIData productData) {
        product.setChecked(statusesVM.isChecked());
        product.setCompleted(statusesVM.isFinished());
        productData.setHasErrors(statusesVM.isHasErrors());
        product.setContractRulesApplied(statusesVM.isRulesApplied());
    }

    public static MiscUtil.Pair<AgentTouch, AgentTouchProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        AgentTouch product = new AgentTouch();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new AgentTouch(), (Object)new AgentTouchProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileAgentTouchPanel node, BookingFileSpaceVM bookingFileVM) {
    }
}

