/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCarRentalGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCarRentalPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCarRentalPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileCarRentalStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCarRentalParametersBaseInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCarRentalParametersCostSumVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCarRentalParametersCostVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCarRentalParametersOwnerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.CustomVatContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductHelper;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.CarRentalProductUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

public class CarRentalProductFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVMParentParameters(CarRentalProduct product, BookingFileCarRentalPanelVM view) {
        view.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        view.setUid(product.getUid());
    }

    public static void toVMParameters(BookingFileCarRentalGeneralPanelVM view, CarRentalProduct product, CarRentalProductUIData productData, BookingFileCarRentalStatusesPaneVM statuses) {
        CarRentalProductFXHelper.toVMInformationParameters(view.getBaseInformationParameters(), productData, product);
        CarRentalProductFXHelper.toVMOwnerParameters(view.getOwnerParameters(), product, productData);
        CarRentalProductFXHelper.toVMControlStatusParameters(statuses, product, productData);
    }

    public static void fromVMParameters(BookingFileCarRentalGeneralPanelVM view, CarRentalProduct product, CarRentalProductUIData productData, BookingFileCarRentalStatusesPaneVM statuses) {
        CarRentalProductFXHelper.fromVMInformationParameters(view.getBaseInformationParameters(), product);
        CarRentalProductFXHelper.fromVMOwnerParameters(view.getOwnerParameters(), product, productData);
        CarRentalProductFXHelper.fromVMControlStatusParameters(statuses, product, productData);
    }

    public static void fillBasicProductFields(CarRentalProduct product) {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
    }

    private static void toVMInformationParameters(BookingFileProductCarRentalParametersBaseInfoVM infoVM, CarRentalProductUIData productData, CarRentalProduct product) {
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        infoVM.setProductValue(ProductType.CAR_RENTAL.toString());
        infoVM.setStatusValue(productStatus != null ? productStatus.toString() : null);
        infoVM.setTicketTypeValue(product.getTicketType());
        infoVM.setTicketNumberValue(product.getSystemNumber());
        infoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        infoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        infoVM.setCarsSupplierValue(product.getCarsSupplier());
        infoVM.setCarClassValue(product.getCarClass());
        infoVM.setNumberOfCarsValue(product.getNumberOfCars());
        infoVM.setStartLocationValue(product.getStartLocation());
        infoVM.setStartLocationCountry(productData.getStartLocationCountry());
        infoVM.setStartOfficeValue(product.getStartOffice());
        infoVM.setStartDateValue(DateUtils.asLocalDate((Date)product.getStartDate()));
        infoVM.setEndLocationValue(product.getEndLocation());
        infoVM.setEndLocationCountry(productData.getEndLocationCountry());
        infoVM.setEndOfficeValue(product.getEndOffice());
        infoVM.setEndDateValue(DateUtils.asLocalDate((Date)product.getEndDate()));
        infoVM.setWithDriverValue(product.isWithDriver());
        infoVM.setCarCategoryCodeValue(product.getCarCategoryCode());
    }

    private static void toVMOwnerParameters(BookingFileProductCarRentalParametersOwnerVM ownerVM, CarRentalProduct product, CarRentalProductUIData productData) {
        ownerVM.setBlankOwnerValue(product.getBlankOwner());
        ownerVM.setSupplierValue(productData.getSupplier());
        ownerVM.setAgencyValue(productData.getAgency());
        ownerVM.setSubagencyValue(productData.getSubagency());
        ownerVM.setSalesPointValue(product.getSalesPoint());
        ownerVM.setPrescribeAgentValue(product.getAgent());
        ownerVM.getTravellersValue().addAll(product.getTravellers());
        ownerVM.setInfo(product.getNotes());
        ownerVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        ownerVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
    }

    private static void toVMControlStatusParameters(BookingFileCarRentalStatusesPaneVM statusesVM, CarRentalProduct product, CarRentalProductUIData productData) {
        statusesVM.setChecked(product.isChecked());
        statusesVM.setFinished(product.isCompleted());
        statusesVM.setHasErrors(productData.isHasErrors());
        statusesVM.setHasWarnings(productData.isHasWarnings());
        statusesVM.setRulesApplied(product.isContractRulesApplied());
    }

    public static void toVMCost(BookingFileProductCarRentalParametersCostVM costVM, CarRentalProduct product, CarRentalProductUIData productData) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductCarRentalParametersCostSumVM sumVM = costVM.getSumCell();
        BigDecimal ndsValue = null;
        String currency = null;
        if (product.getFare() != null) {
            currency = product.getFare().getCurrency();
            sumVM.setTariffSum(CarRentalProductFXHelper.getValue(product.getFare().getValue(), negate));
            sumVM.setTariffCurrency(currency);
        }
        if (product.getEquivalentFare() != null) {
            currency = product.getEquivalentFare().getCurrency();
            sumVM.setEqTariffSum(CarRentalProductFXHelper.getValue(product.getEquivalentFare().getValue(), negate));
            sumVM.setEqTariffCurrency(currency);
        }
        if (product.getEquivalentFareVatValue() != null) {
            VatValue vatValue = product.getEquivalentFareVatValue();
            ndsValue = vatValue.getAmount();
            sumVM.getVatIncludedEqTariff().setVatAmount(CarRentalProductFXHelper.getValue(vatValue.getAmount(), negate));
            sumVM.getVatIncludedEqTariff().setVatRate(vatValue.getRate());
        }
        sumVM.setPenaltySum(product.getPenalty());
        sumVM.setPenaltyCurrency(currency);
        sumVM.setTotalSum(CarRentalProductHelper.getTotalPrice((CarRentalProduct)product));
        sumVM.setVatIncludedTotal(CarRentalProductFXHelper.getValue(ndsValue, negate));
        sumVM.setTotalCurrency(currency);
        costVM.getRates().setRateValue(productData.getRate());
        costVM.getRates().setEqCurrencyValue(productData.getEqCurrency() == null ? null : productData.getEqCurrency());
        costVM.getRates().setBaseCurrencyValue(productData.getBaseCurrency() == null ? null : productData.getBaseCurrency());
    }

    public static void toVMComments(BookingFileCarRentalPanelVM view, CarRentalProduct product) {
        view.getOtherParameters().getPopups().setComments(product.getComments());
    }

    private static void fromVMInformationParameters(BookingFileProductCarRentalParametersBaseInfoVM infoVM, CarRentalProduct product) {
        product.setTicketType(infoVM.getTicketTypeValue());
        product.setSystemNumber(infoVM.getTicketNumberValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)infoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)infoVM.getCorrectionDateValue()));
        product.setCarsSupplier(infoVM.getCarsSupplierValue());
        product.setCarClass(infoVM.getCarClassValue());
        product.setNumberOfCars(infoVM.getNumberOfCarsValue());
        product.setStartLocation(infoVM.getStartLocationValue());
        product.setStartOffice(infoVM.getStartOfficeValue());
        product.setStartDate(DateUtils.asDate((LocalDate)infoVM.getStartDateValue()));
        product.setEndLocation(infoVM.getEndLocationValue());
        product.setEndOffice(infoVM.getEndOfficeValue());
        product.setEndDate(DateUtils.asDate((LocalDate)infoVM.getEndDateValue()));
        product.setWithDriver(infoVM.isWithDriverValue());
        product.setCarCategoryCode(infoVM.getCarCategoryCodeValue());
    }

    private static void fromVMOwnerParameters(BookingFileProductCarRentalParametersOwnerVM ownerVM, CarRentalProduct product, CarRentalProductUIData productData) {
        product.setBlankOwner(ownerVM.getBlankOwnerValue());
        productData.setSupplier(ownerVM.getSupplierValue());
        productData.setAgency(ownerVM.getAgencyValue());
        productData.setSubagency(ownerVM.getSubagencyValue());
        product.setSalesPoint(ownerVM.getSalesPointValue());
        product.setAgent(ownerVM.getPrescribeAgentValue());
        product.getTravellers().clear();
        ownerVM.getTravellersValue().forEach(tr -> {
            Traveller traveller;
            if (tr != null && (traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), tr.getUid())) != null) {
                product.getTravellers().add(traveller);
            }
        });
        product.setNotes(ownerVM.getInfo());
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)ownerVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)ownerVM.getShipmentsDateSubagentValue()));
    }

    private static void fromVMControlStatusParameters(BookingFileCarRentalStatusesPaneVM statusesVM, CarRentalProduct product, CarRentalProductUIData productData) {
        product.setChecked(statusesVM.isChecked());
        product.setCompleted(statusesVM.isFinished());
        productData.setHasErrors(statusesVM.isHasErrors());
        product.setContractRulesApplied(statusesVM.isRulesApplied());
    }

    public static void fromVMCost(BookingFileProductCarRentalParametersCostVM costVM, CarRentalProduct product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductCarRentalParametersCostSumVM sumVM = costVM.getSumCell();
        if (product.getFare() == null) {
            product.setFare(new Money());
        }
        product.getFare().setValue(CarRentalProductFXHelper.getValue(sumVM.getTariffSum(), negate));
        product.getFare().setCurrency(sumVM.getTariffCurrency());
        if (product.getEquivalentFare() == null) {
            product.setEquivalentFare(new Money());
        }
        product.getEquivalentFare().setValue(CarRentalProductFXHelper.getValue(sumVM.getEqTariffSum(), negate));
        product.getEquivalentFare().setCurrency(sumVM.getEqTariffCurrency());
        if (product.getEquivalentFareVatValue() == null) {
            product.setEquivalentFareVatValue(new VatValue());
        }
        CustomVatContainerVM vatEq = sumVM.getVatIncludedEqTariff();
        product.getEquivalentFareVatValue().setRate(vatEq.getVatRate());
        product.getEquivalentFareVatValue().setAmount(CarRentalProductFXHelper.getValue(vatEq.getVatAmount(), negate));
        product.setPenalty(sumVM.getPenaltySum());
    }

    public static void fromVMComments(BookingFileCarRentalPanelVM view, CarRentalProduct product) {
        product.setComments(view.getOtherParameters().getPopups().getComments());
    }

    public static MiscUtil.Pair<CarRentalProduct, CarRentalProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        CarRentalProduct product = new CarRentalProduct();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new CarRentalProduct(), (Object)new CarRentalProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileCarRentalPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(CarRentalProduct.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

