/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.ComplexCell;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.SimpleCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileContractPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileContractTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileGeneralParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMainFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCommissionsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopCard6GridVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopCardsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticPricesVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticReasonCodesVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticUdidsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductValidationMessagesTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductValidationMessagesVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileVendorFinanceDocumentsDataPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileVendorFinanceDocumentsDataTableVM;
import com.gridnine.xtrip.client.fx.model.booking.ContractCurrencyVM;
import com.gridnine.xtrip.client.fx.model.booking.FopComponentVM;
import com.gridnine.xtrip.client.fx.model.booking.FopDiscountsVM;
import com.gridnine.xtrip.client.fx.model.booking.FopFeesVM;
import com.gridnine.xtrip.client.fx.model.booking.PrepaymentDocumentTableVM;
import com.gridnine.xtrip.client.fx.model.booking.ProductStatusHistoryDialogContainer;
import com.gridnine.xtrip.client.fx.model.booking.ProductStatusHistoryDialogContainerController;
import com.gridnine.xtrip.client.fx.model.booking.ProductStatusHistoryDialogEntryVM;
import com.gridnine.xtrip.client.fx.model.booking.SabrePassiveSegmentsPaneVM;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionItemVM;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionsEntryVM;
import com.gridnine.xtrip.client.fx.model.system.BaseVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.MoneyCalculationFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.statistic.FXAfsStatisticalField;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsResult;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsDiscountsFeesUIDataHandler;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.DiscountsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.FeesUIData;
import com.gridnine.xtrip.common.model.booking.uidata.PersonCostCodesUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductContractUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductPrepaymentDocumentUIData;
import com.gridnine.xtrip.common.model.booking.uidata.VendorFinanceDocumentDataUIData;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CurrencyRateData;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ObjectUtils;

public class GeneralProductFXHelper {
    private static Map<AFSType, FXAfsStatisticalField> afs2fields = new LinkedHashMap<AFSType, FXAfsStatisticalField>(){
        private static final long serialVersionUID = -1475914617496704617L;
        {
            this.put(AFSType.HBF1, new FXAfsStatisticalField(AFSType.HBF1, "hbf1Bkg", "hbf1Tkt"));
            this.put(AFSType.HBF2, new FXAfsStatisticalField(AFSType.HBF2, "hbf2Bkg", "hbf2Tkt"));
            this.put(AFSType.LAF1, new FXAfsStatisticalField(AFSType.LAF1, "laf1Bkg", "laf1Tkt"));
            this.put(AFSType.LAF2, new FXAfsStatisticalField(AFSType.LAF2, "laf2Bkg", "laf2Tkt"));
            this.put(AFSType.LAF3, new FXAfsStatisticalField(AFSType.LAF3, "laf3Bkg", "laf3Tkt"));
            this.put(AFSType.ATF1, new FXAfsStatisticalField(AFSType.ATF1, "atf1Bkg", "atf1Tkt"));
            this.put(AFSType.ATF2, new FXAfsStatisticalField(AFSType.ATF2, "atf2Bkg", "atf2Tkt"));
            this.put(AFSType.LPF1, new FXAfsStatisticalField(AFSType.LPF1, "lpf1Bkg", "lpf1Tkt"));
            this.put(AFSType.LPF2, new FXAfsStatisticalField(AFSType.LPF2, "lpf2Bkg", "lpf2Tkt"));
            this.put(AFSType.LPF3, new FXAfsStatisticalField(AFSType.LPF3, "lpf3Bkg", "lpf3Tkt"));
            this.put(AFSType.P3D, new FXAfsStatisticalField(AFSType.P3D, "p3dBkg", "p3dTkt"));
            this.put(AFSType.CTF, new FXAfsStatisticalField(AFSType.CTF, "ctfBkg", "ctfTkt"));
        }
    };
    private static String FOP_COMPONENT_KEY_SEP = "|";

    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    private static Double getValue(Double value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? Double.valueOf(-value.doubleValue()) : value;
    }

    public static void toVMProductCommissions(BaseProduct product, BaseProductUIData productData, BookingFileProductCommissionsVM model) {
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        boolean negate = productStatus == ProductStatus.REFUND || productStatus == ProductStatus.EXCHANGE;
        List entries = productData.getCommissionDiscountFeeHandlers().stream().map(data -> GeneralProductFXHelper.toVMCommissionsEntry(negate, data)).collect(Collectors.toList());
        model.getContent().getEntries().addAll(entries);
        model.setProductUid(product.getUid());
    }

    public static void toVMProductFop(BaseProduct product, BaseProductUIData productData, BookingFileProductFopVM model) {
        List<DiscountsUIData> discounts = productData.getCommissionDiscountFeeHandlers().stream().flatMap(h -> h.getDiscounts().stream()).collect(Collectors.toList());
        List<FeesUIData> fees = productData.getCommissionDiscountFeeHandlers().stream().flatMap(h -> h.getFees().stream()).collect(Collectors.toList());
        model.setAllDiscounts(discounts);
        model.setAllFees(fees);
        List<BookingFileProductFopTableVM> paymentMethods = GeneralProductFXHelper.toVMFopTable(product, productData.getFopsList(), discounts, fees);
        model.getFopTable().addAll(paymentMethods);
        model.setAgencyBanks(productData.getAgencyBanks());
        model.setAvailablePayersUids(productData.getPayersUids());
        model.setHasSubagencyType(productData.getSubagency() != null && !productData.getSubagency().equals((Object)productData.getAgency()));
        model.setProductShortName(Messages.Forms_of_payment);
        model.setProductUid(product.getUid());
        model.setTicketType(ProductHandler.of((BaseProduct)product).getTicketType(product));
    }

    public static void toVMProductStatistic(StatisticalData statisticalData, BaseProductUIData productData, Collection<ReasonCodeType> reasonCodeTypes, Class<? extends BaseProduct> productClass, BookingFileProductStatisticVM model, EntityReference<Organization> org) {
        if (statisticalData != null) {
            GeneralProductFXHelper.toVMProductStatisticReasonCodes(statisticalData, model, productData, reasonCodeTypes);
            GeneralProductFXHelper.toVMProductStatisticCostCodes(statisticalData, model, productData);
            GeneralProductFXHelper.toVMProductStatisticAfs(statisticalData, model, productClass, org);
        }
        GeneralProductFXHelper.toVMProductStatisticBaseData(productData, productClass, model);
        GeneralProductFXHelper.actualizeCostCodeProperties(statisticalData, model);
    }

    public static void toVMProductStatisticBaseData(BaseProductUIData productData, Class<? extends BaseProduct> productClass, BookingFileProductStatisticVM model) {
        model.setProductType(productClass);
        model.setDestinations(productData.getOverallDestinations());
        model.setSystemNumber(productData.getSystemNumber());
    }

    public static void toVMProductStatisticAfs(StatisticalData statisticalData, BookingFileProductStatisticVM model, Class<? extends BaseProduct> productClass, EntityReference<Organization> org) {
        for (FXAfsStatisticalField afsFields : afs2fields.values()) {
            BookingFileProductStatisticPricesVM vm = GeneralProductFXHelper.afsFields2Vm(statisticalData, afsFields);
            model.getStatistic().getAfs().getPrices().add(vm);
        }
        model.getStatistic().getAfs().setClient(org);
        model.getStatistic().getAfs().getParameters().setProductClass(productClass);
        model.getStatistic().getAfs().getParameters().setOverallDestination(statisticalData.getOverallDestination());
        model.getStatistic().getAfs().getParameters().setOverallClassService(statisticalData.getOverallClassService());
        model.getStatistic().getAfs().getParameters().setValidatingCarrier(statisticalData.getValidatingCarrier());
    }

    public static void toVMProductStatisticReasonCodes(StatisticalData statisticalData, BookingFileProductStatisticVM model, BaseProductUIData productData, Collection<ReasonCodeType> reasonCodeTypes) {
        model.getStatistic().getReasonCodes().addAll(statisticalData.getReasonCodes().stream().map(rc -> {
            BookingFileProductStatisticReasonCodesVM vm = new BookingFileProductStatisticReasonCodesVM();
            vm.setReasonCode(rc);
            return vm;
        }).collect(Collectors.toList()));
        List reasonCodes = reasonCodeTypes.isEmpty() ? productData.getProfileReasonCodes() : productData.getProfileReasonCodes().stream().filter(rc -> reasonCodeTypes.contains(rc.getType())).collect(Collectors.toList());
        model.setProfileReasonCodes(reasonCodes);
    }

    public static void toVMProductStatisticCostCodes(StatisticalData statisticalData, BookingFileProductStatisticVM model, BaseProductUIData productData) {
        model.getProfileCostCodeProperties().addAll(productData.getProfileCostCodeProperties());
        model.getProfileCostCodes().addAll(productData.getProfileCostCodes());
        HashMap<Traveller, List> personCostCodes = new HashMap<Traveller, List>();
        model.setPersonCostCodes(personCostCodes);
        for (PersonCostCodesUIData uiData : productData.getPersonCostCodes()) {
            personCostCodes.put(uiData.getTraveller(), uiData.getPersonCostCodes());
        }
    }

    public static void toVMValidationMessages(List<ValidationMessage> validationMessages, String productUid, BookingFileProductValidationMessagesVM model) {
        for (ValidationMessage message : validationMessages) {
            BookingFileProductValidationMessagesTableVM row = new BookingFileProductValidationMessagesTableVM();
            row.setType(message.getSeverity());
            row.setCategory(message.getCategory());
            row.setErrorCode(message.getErrorCode());
            if (message.getMessage() != null) {
                row.setMessage(message.getMessage().toString());
            }
            row.getDetails().setContent(message.getDetails());
            model.getContent().add(row);
        }
    }

    private static CommissionsEntryVM toVMCommissionsEntry(boolean negate, CommissionsDiscountsFeesUIDataHandler handler) {
        Money money;
        RateMoney rateMoney;
        CommissionsEntryVM entryVM = new CommissionsEntryVM();
        entryVM.setUid(handler.getUid());
        if (handler.getContractType() != null) {
            entryVM.setCommissionsCaption(Messages.Commission + ' ' + handler.getContractType().toString());
            entryVM.setFeesCaption(Messages.Fees + ' ' + handler.getContractType().toString());
        }
        for (CommissionsUIData commission : handler.getCommissions()) {
            CommissionItemVM commissionVM = new CommissionItemVM();
            commissionVM.setUid(commission.getUid());
            commissionVM.setCommissionProperties(commission.getCommissionProperty());
            commissionVM.setSegmentTariff(commission.getSegmentTariff());
            if (commission.getCommissionProperty() != null) {
                commissionVM.setName(commission.getCommissionProperty().getCaption());
            }
            rateMoney = new RateMoney();
            if (commission.getCurrency() != null) {
                money = new Money();
                if (commission.getAmount() == null && commission.getRate() != null) {
                    money.setValue(GeneralProductFXHelper.getValue(commission.getEquivalentAmount(), negate));
                } else {
                    money.setValue(GeneralProductFXHelper.getValue(commission.getAmount(), negate));
                }
                money.setCurrency(commission.getCurrency());
                rateMoney.setMoney(money);
            } else {
                rateMoney.setRate(GeneralProductFXHelper.getValue(commission.getRate(), negate));
            }
            commissionVM.setValue(rateMoney);
            money = new Money();
            money.setValue(GeneralProductFXHelper.getValue(commission.getEquivalentAmount(), negate));
            money.setCurrency(commission.getEquivalentCurrency());
            commissionVM.setSum(money);
            entryVM.getCommissions().add(commissionVM);
        }
        for (DiscountsUIData discount : handler.getDiscounts()) {
            CommissionItemVM discountVM = new CommissionItemVM();
            discountVM.setUid(discount.getUid());
            discountVM.setCommissionProperties(discount.getDiscountProperty());
            discountVM.setSegmentTariff(discount.getSegmentTariff());
            if (discount.getDiscountProperty() != null) {
                discountVM.setName(discount.getDiscountProperty().getCaption());
            }
            rateMoney = new RateMoney();
            if (discount.getCurrency() != null && discount.getAmount() != null) {
                money = new Money();
                money.setValue(GeneralProductFXHelper.getValue(BigDecimal.valueOf(discount.getAmount()), negate));
                money.setCurrency(discount.getCurrency());
                rateMoney.setMoney(money);
            } else {
                rateMoney.setRate(GeneralProductFXHelper.getValue(discount.getRate(), negate));
            }
            discountVM.setValue(rateMoney);
            money = new Money();
            money.setValue(GeneralProductFXHelper.getValue(discount.getEquivalentAmount(), negate));
            money.setCurrency(discount.getEquivalentCurrency());
            discountVM.setSum(money);
            entryVM.getCommissions().add(discountVM);
        }
        for (FeesUIData fee : handler.getFees()) {
            CommissionItemVM feeVM = new CommissionItemVM();
            feeVM.setUid(fee.getUid());
            feeVM.setCommissionProperties(fee.getFeeProperty());
            feeVM.setSegmentTariff(fee.getSegmentTariff());
            if (fee.getFeeProperty() != null) {
                feeVM.setName(fee.getFeeProperty().getCaption());
            }
            rateMoney = new RateMoney();
            if (fee.getCurrency() != null) {
                money = new Money();
                money.setValue(GeneralProductFXHelper.getValue(fee.getAmount(), negate));
                money.setCurrency(fee.getCurrency());
                rateMoney.setMoney(money);
            } else {
                rateMoney.setRate(GeneralProductFXHelper.getValue(fee.getRate(), negate));
            }
            feeVM.setValue(rateMoney);
            money = new Money();
            money.setValue(GeneralProductFXHelper.getValue(fee.getEquivalentAmount(), negate));
            money.setCurrency(fee.getEquivalentCurrency());
            feeVM.setSum(money);
            entryVM.getFees().add(feeVM);
        }
        entryVM.setContractType(handler.getContractType());
        return entryVM;
    }

    private static List<BookingFileProductFopTableVM> toVMFopTable(BaseProduct product, List<ProductFopUIData> fopList, List<DiscountsUIData> discounts, List<FeesUIData> fees) {
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        boolean negate = productStatus == ProductStatus.REFUND || productStatus == ProductStatus.EXCHANGE;
        ArrayList<BookingFileProductFopTableVM> fops = new ArrayList<BookingFileProductFopTableVM>();
        for (ProductFopUIData fop : fopList) {
            BookingFileProductFopTableVM fopVM = new BookingFileProductFopTableVM();
            fopVM.setUid(fop.getUid());
            fopVM.setContractType(fop.getContractType());
            fopVM.setSum(GeneralProductFXHelper.getValue(fop.getAmount(), negate));
            fopVM.setCurrency(fop.getCurrency());
            fopVM.setAgent(fop.getAgent());
            BookingFileProductFopCardsVM injectedWidget = fopVM.getSuperColumn().getContent();
            injectedWidget.getBank().setBankName(fop.getBankName());
            fopVM.setDate(DateUtils.asLocalDateTime((Date)fop.getOperationDate()));
            injectedWidget.getDocument().setDetails(fop.getPassengerStatus());
            if (Arrays.asList(PaymentType.CREDIT, PaymentType.MTD, PaymentType.MTD_AGENCY, PaymentType.INTERLINE).contains(fop.getPaymentType())) {
                injectedWidget.getDocument().setDocumentNumber(fop.getNumber());
            } else {
                injectedWidget.getRelatedTicketNumber().setNumber(fop.getNumber());
            }
            injectedWidget.getContractTypeVendor().setPayer(fop.getPayer());
            injectedWidget.getAccompanyingDocument().setAccompanyingDocumentType(fop.getTchCCAccompanyingDocumentType());
            injectedWidget.getBank().setBankName(fop.getBankName());
            fopVM.setDenied(fop.isRefused());
            fopVM.setPaymentType(fop.getPaymentType());
            injectedWidget.getAccompanyingDocument().setAccompanyingDocumentType(fop.getTchCCAccompanyingDocumentType());
            BookingFileProductFopCard6GridVM cardVM = injectedWidget.getCard();
            if (fop.getCard() != null) {
                cardVM.setUid(fop.getCard().getUid());
                cardVM.setVendor(fop.getCard().getVendor());
                cardVM.setNumber(fop.getCard().getNumber());
                cardVM.setSecurityCode(fop.getCard().getSecurityCode());
                cardVM.setExpirationDate(DateUtils.asLocalDate((Date)fop.getCard().getExpiration()));
            }
            List fopDiscounts = discounts.stream().filter(d -> fop.getCommissionUids().contains(d.getUid())).map(d -> {
                FopDiscountsVM row = new FopDiscountsVM();
                row.setSum(GeneralProductFXHelper.getValue(d.getEquivalentAmount(), negate));
                row.setDiscount(d);
                return row;
            }).collect(Collectors.toList());
            injectedWidget.getDiscounts().addAll(fopDiscounts);
            List fopFees = fees.stream().filter(f -> fop.getCommissionUids().contains(f.getUid())).map(f -> {
                FopFeesVM row = new FopFeesVM();
                row.setSum(GeneralProductFXHelper.getValue(f.getEquivalentAmount(), negate));
                row.setFee(f);
                return row;
            }).collect(Collectors.toList());
            injectedWidget.getFees().addAll(fopFees);
            fopVM.setCategory(fop.getCategory());
            FopDetalization fopDetalization = (FopDetalization)product.getFopDetalizations().get(fop.getUid());
            Collection<Object> fopComponents = fopDetalization == null ? Collections.emptyList() : fopDetalization.getComponents();
            fopComponents = GeneralProductFXHelper.groupFopComponents(fopComponents);
            VMHelper.transfer(fopComponents, fopVM.getSuperColumn().getContent().getFopComponent(), fopComponentVM -> new FopComponentVM(), (component, conditionVM) -> {
                conditionVM.setHidden(component.isHidden());
                conditionVM.setTraveller(component.getTraveller());
                conditionVM.setUid(component.getUid());
                conditionVM.setVatRate(component.getVatRate());
                conditionVM.setType(component.getType());
                conditionVM.setNomenclature(component.getNomenclature());
                conditionVM.setAmount(GeneralProductFXHelper.getValue(component.getAmount(), negate));
                conditionVM.setVatAmount(GeneralProductFXHelper.getValue(component.getVatAmount(), negate));
                conditionVM.setShipment(component.getShipment());
                conditionVM.setCorrectionShipment(component.getCorrectionShipment());
                conditionVM.setReceipt(component.getReceipt());
            });
            fops.add(fopVM);
        }
        return fops;
    }

    private static Collection<FopComponent> groupFopComponents(Collection<FopComponent> fopComponents) {
        Map grouped = fopComponents.stream().collect(Collectors.toMap(fc -> GeneralProductFXHelper.buildKey(fc), Function.identity(), (fc1, fc2) -> {
            try {
                FopComponent result = (FopComponent)XCloneHelper.clone((XCloneable)fc1);
                result.setAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fc1.getAmount(), fc2.getAmount()}));
                result.setVatAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fc1.getVatAmount(), fc2.getVatAmount()}));
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        return grouped.values();
    }

    private static String buildKey(FopComponent fc) {
        List<String> values = Arrays.asList(fc.getTraveller() == null ? "" : fc.getTraveller().getUid(), fc.getType() == null ? "" : fc.getType().name(), String.valueOf(fc.isHidden()), fc.getVatRate() == null ? "" : String.valueOf(fc.getVatRate()), fc.getNomenclature() == null ? "" : fc.getNomenclature().getCode(), fc.getShipment() == null ? "" : fc.getShipment().getUid());
        return TextUtil.join((String)FOP_COMPONENT_KEY_SEP, values);
    }

    public static void toVMProductContract(BaseProductUIData productData, BookingFileContractPanelVM controlPanelVM) {
        for (ProductContractUIData contractUIData : productData.getContractsList()) {
            BookingFileContractTableVM contractTableVM = new BookingFileContractTableVM();
            contractTableVM.setContractType(contractUIData.getContractType());
            contractTableVM.setContract(contractUIData.getContract());
            contractTableVM.setManualContract(contractUIData.getManualContract());
            contractTableVM.setContractUid(contractUIData.getContractUid());
            controlPanelVM.getContracts().add(contractTableVM);
        }
        productData.getContractCurrencies().forEach((t, r) -> {
            ExchangeRateData rate = r;
            if (rate != null && rate.getCurrencyRateData() != null) {
                ContractCurrencyVM currencyTableVM = new ContractCurrencyVM();
                currencyTableVM.setCurrency(r);
                currencyTableVM.setContractType(t);
                if (productData.getPaymentCurrencies().containsKey(t)) {
                    currencyTableVM.setFromContract(false);
                    rate = (ExchangeRateData)productData.getPaymentCurrencies().get(t);
                } else {
                    currencyTableVM.setFromContract(true);
                }
                boolean indirect = rate.getIndirectRate() != null && rate.getIndirectRate() != false;
                currencyTableVM.setBaseCurrency(indirect ? rate.getCurrencyRateData().getBaseCurrency() : rate.getCurrencyRateData().getCurrency());
                currencyTableVM.setEquivalentCurrency(indirect ? rate.getCurrencyRateData().getCurrency() : rate.getCurrencyRateData().getBaseCurrency());
                currencyTableVM.setCurrencyType(rate.getCurrencyRateData().getType());
                currencyTableVM.setConversionDate(DateUtils.asLocalDate((Date)rate.getCurrencyRateData().getDate()));
                currencyTableVM.setConversionCoefficient(Optional.of(rate.getCoefficient()).orElse(1.0).doubleValue());
                currencyTableVM.setConversionValue(indirect ? 1.0 / rate.getCurrencyRateData().getRate() : rate.getCurrencyRateData().getRate());
                controlPanelVM.getCurrencyConversion().add(currencyTableVM);
            }
        });
    }

    public static void toVMPrepaymentDocuments(BaseProductUIData productData, List<PrepaymentDocumentTableVM> prepaymentDocumentsVMs) {
        for (ProductPrepaymentDocumentUIData documentUIData : productData.getPrepaymentDocumentsList()) {
            PrepaymentDocumentTableVM prepaymentDocumentTableVM = new PrepaymentDocumentTableVM();
            prepaymentDocumentTableVM.setUid(documentUIData.getUid());
            prepaymentDocumentTableVM.setContractType(documentUIData.getContractType());
            prepaymentDocumentTableVM.setDocument(documentUIData.getDocument());
            prepaymentDocumentTableVM.setSum(documentUIData.getAmount());
            prepaymentDocumentsVMs.add(prepaymentDocumentTableVM);
        }
    }

    public static void toVMVendorFinanceDocumentsData(BaseProductUIData productData, BookingFileVendorFinanceDocumentsDataPanelVM controlPanelVM) {
        for (VendorFinanceDocumentDataUIData vendorFinanceDocumentDataUIData : productData.getVendorFinanceDocumentsDataList()) {
            BookingFileVendorFinanceDocumentsDataTableVM vendorFinanceDocumentsDataTableVM = new BookingFileVendorFinanceDocumentsDataTableVM();
            vendorFinanceDocumentsDataTableVM.setFinanceDocumentType(vendorFinanceDocumentDataUIData.getFinanceDocumentType());
            vendorFinanceDocumentsDataTableVM.setNumber(vendorFinanceDocumentDataUIData.getNumber());
            vendorFinanceDocumentsDataTableVM.setDate(DateUtils.asLocalDate((Date)vendorFinanceDocumentDataUIData.getDate()));
            vendorFinanceDocumentsDataTableVM.setVendorNumber(vendorFinanceDocumentDataUIData.getVendorNumber());
            vendorFinanceDocumentsDataTableVM.setVendorDate(DateUtils.asLocalDate((Date)vendorFinanceDocumentDataUIData.getVendorDate()));
            vendorFinanceDocumentsDataTableVM.setVendorShippingDocumentNumber(vendorFinanceDocumentDataUIData.getVendorShippingDocumentNumber());
            vendorFinanceDocumentsDataTableVM.setVendorShippingDocumentDate(DateUtils.asLocalDate((Date)vendorFinanceDocumentDataUIData.getVendorShippingDocumentDate()));
            vendorFinanceDocumentsDataTableVM.setSequenceNumber(vendorFinanceDocumentDataUIData.getSequenceNumber());
            controlPanelVM.getContent().add(vendorFinanceDocumentsDataTableVM);
        }
    }

    public static void toVMPassiveSegments(BaseProduct product, SabrePassiveSegmentsPaneVM vm) {
        SabrePassiveSegmentsResult model = product.getPassiveSegmentsCreationResult();
        vm.setPcc(model == null ? null : model.getPcc());
        vm.setPnr(model == null ? null : model.getPnr());
        vm.setTimestamp(model == null ? null : DateUtils.asLocalDateTime((Date)model.getResponseDate()));
    }

    public static void fromVMProductStatistic(BookingFile bookingFile, BookingFileProductStatisticVM statisticVM, StatisticalData statisticalData, BaseProductUIData productData) {
        if (GeneralProductFXHelper.hasStatisticalDataChanged(statisticVM, statisticalData)) {
            GeneralProductFXHelper.fromVMProductStatisticAfs(statisticVM, statisticalData);
            GeneralProductFXHelper.fromVMProductStatisticReasonCodes(statisticVM, statisticVM.getStatistic().getReasonCodes(), statisticalData, bookingFile);
        }
    }

    public static void fromVMProductStatisticAfs(BookingFileProductStatisticVM statisticVM, StatisticalData statisticalData) {
        for (BookingFileProductStatisticPricesVM afsRow : statisticVM.getStatistic().getAfs().getPrices()) {
            Double booking = afsRow.getBooking() == null ? null : Double.valueOf(afsRow.getBooking().doubleValue());
            Double ticket = afsRow.getTicket() == null ? null : Double.valueOf(afsRow.getTicket().doubleValue());
            FXAfsStatisticalField fields = afs2fields.get(afsRow.getAfsType());
            statisticalData.setValue(fields.getFieldBkg(), (Object)booking);
            statisticalData.setValue(fields.getFieldTkt(), (Object)ticket);
        }
        statisticalData.setOverallDestination(statisticVM.getStatistic().getAfs().getParameters().getOverallDestination());
        statisticalData.setOverallClassService(statisticVM.getStatistic().getAfs().getParameters().getOverallClassService());
        statisticalData.setValidatingCarrier(statisticVM.getStatistic().getAfs().getParameters().getValidatingCarrier());
    }

    public static void fromVMProductStatisticReasonCodes(BookingFileProductStatisticVM statisticVM, List<BookingFileProductStatisticReasonCodesVM> reasonCodesVMList, StatisticalData statisticalData, BookingFile bookingFile) {
        Map<String, ReasonCode> allReasonCodeMap = GeneralProductFXHelper.getAllReasonCodesMap(bookingFile);
        List reasonCodes = reasonCodesVMList.stream().filter(vm -> vm.getReasonCode() != null).map(vm -> allReasonCodeMap.getOrDefault(vm.getReasonCode().getUid(), vm.getReasonCode())).collect(Collectors.toList());
        statisticalData.getReasonCodes().clear();
        statisticalData.getReasonCodes().addAll(reasonCodes);
    }

    private static List<ProductFopUIData> toUIDataFop(boolean negate, List<BookingFileProductFopTableVM> fopList) {
        ArrayList<ProductFopUIData> result = new ArrayList<ProductFopUIData>();
        ArrayList cards = new ArrayList();
        fopList.forEach(fopVM -> {
            ProductFopUIData fopUI = new ProductFopUIData();
            BookingFileProductFopCardsVM injected = fopVM.getSuperColumn().getContent();
            fopUI.setUid(fopVM.getUid());
            fopUI.setContractType(fopVM.getContractType());
            fopUI.setAmount(GeneralProductFXHelper.getValue(fopVM.getSum(), negate));
            fopUI.setAgent(fopVM.getAgent());
            fopUI.setCurrency(fopVM.getCurrency());
            fopUI.setOperationDate(DateUtils.asDate((LocalDateTime)fopVM.getDate()));
            fopUI.setRefused(fopVM.isDenied());
            fopUI.setPayer(injected.getContractTypeVendor().getPayer());
            fopUI.setBankName(injected.getBank().getBankName());
            fopUI.setPaymentType(fopVM.getPaymentType());
            fopUI.getCommissionUids().clear();
            fopUI.getCommissionUids().addAll(injected.getDiscounts().stream().filter(d -> d.getDiscount() != null && d.getDiscount().getUid() != null).map(d -> d.getDiscount().getUid()).collect(Collectors.toList()));
            fopUI.getCommissionUids().addAll(injected.getFees().stream().filter(f -> f.getFee() != null && f.getFee().getUid() != null).map(f -> f.getFee().getUid()).collect(Collectors.toList()));
            fopUI.setPassengerStatus(injected.getDocument().getDetails());
            if (Arrays.asList(PaymentType.CREDIT, PaymentType.MTD, PaymentType.INTERLINE, PaymentType.MTD_AGENCY).contains(fopVM.getPaymentType())) {
                fopUI.setNumber(injected.getDocument().getDocumentNumber());
            } else {
                fopUI.setNumber(injected.getRelatedTicketNumber().getNumber());
            }
            fopUI.setTchCCAccompanyingDocumentType(injected.getAccompanyingDocument().getAccompanyingDocumentType());
            fopUI.setCategory(fopVM.getCategory());
            BookingFileProductFopCard6GridVM cardVM = injected.getCard();
            if (cardVM.getExpirationDate() != null || cardVM.getNumber() != null || cardVM.getSecurityCode() != null || cardVM.getVendor() != null) {
                Card card = new Card();
                if (cardVM.getUid() != null) {
                    card.setUid(cardVM.getUid());
                }
                card.setNumber(cardVM.getNumber());
                card.setVendor(cardVM.getVendor());
                card.setExpiration(DateUtils.asDate((LocalDate)cardVM.getExpirationDate()));
                card.setSecurityCode(cardVM.getSecurityCode());
                boolean isDublicate = false;
                if (!cards.isEmpty()) {
                    for (Card card1 : cards) {
                        if (!card1.getUid().equals(card.getUid())) continue;
                        card = card1;
                        isDublicate = true;
                        break;
                    }
                }
                if (!isDublicate) {
                    cards.add(card);
                }
                fopUI.setCard(card);
            }
            result.add(fopUI);
        });
        return result;
    }

    public static void fromVMCommissions(BaseProduct product, BookingFileProductCommissionsVM commissionsVM, BaseProductUIData productData) {
        if (commissionsVM.getContent() != null) {
            ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
            boolean negate = productStatus == ProductStatus.REFUND || productStatus == ProductStatus.EXCHANGE;
            commissionsVM.getContent().getEntries().forEach(commissionsEntryVM -> GeneralProductFXHelper.fromVMCommissionsEntry(negate, commissionsEntryVM, GeneralProductFXHelper.getOrCreateHandler(productData.getCommissionDiscountFeeHandlers(), commissionsEntryVM)));
        }
    }

    private static void fromVMCommissionsEntry(boolean negate, CommissionsEntryVM entryVM, CommissionsDiscountsFeesUIDataHandler handler) {
        handler.getCommissions().clear();
        for (CommissionItemVM vm : entryVM.getCommissions()) {
            CommissionsUIData commission = new CommissionsUIData();
            commission.setUid(vm.getUid());
            commission.setAmount(GeneralProductFXHelper.getValue(MoneyCalculationFXHelper.getAmount(vm.getValue()), negate));
            commission.setCurrency(MoneyCalculationFXHelper.getCurrency(vm.getValue()));
            commission.setEquivalentAmount(GeneralProductFXHelper.getValue(vm.getSum() != null ? vm.getSum().getValue() : null, negate));
            commission.setRate(GeneralProductFXHelper.getValue(MoneyCalculationFXHelper.getRate(vm.getValue()), negate));
            commission.setCommissionProperty(vm.getCommissionProperties());
            commission.setSegmentTariff(vm.getSegmentTariff());
            handler.getCommissions().add(commission);
        }
        handler.getFees().clear();
        for (CommissionItemVM vm : entryVM.getFees()) {
            FeesUIData fee = new FeesUIData();
            fee.setUid(vm.getUid());
            fee.setAmount(GeneralProductFXHelper.getValue(MoneyCalculationFXHelper.getAmount(vm.getValue()), negate));
            fee.setCurrency(MoneyCalculationFXHelper.getCurrency(vm.getValue()));
            fee.setEquivalentAmount(GeneralProductFXHelper.getValue(vm.getSum() != null ? vm.getSum().getValue() : null, negate));
            fee.setRate(GeneralProductFXHelper.getValue(MoneyCalculationFXHelper.getRate(vm.getValue()), negate));
            fee.setFeeProperty(vm.getCommissionProperties());
            fee.setSegmentTariff(vm.getSegmentTariff());
            handler.getFees().add(fee);
        }
    }

    private static CommissionsDiscountsFeesUIDataHandler getOrCreateHandler(List<CommissionsDiscountsFeesUIDataHandler> handlers, CommissionsEntryVM commissionsEntryVM) {
        CommissionsDiscountsFeesUIDataHandler handler = handlers.stream().filter(item -> MiscUtil.equals((Object)item.getUid(), (Object)commissionsEntryVM.getUid())).findFirst().orElse(null);
        if (handler == null) {
            handler = new CommissionsDiscountsFeesUIDataHandler();
            handler.setUid(commissionsEntryVM.getUid());
            handler.setContractType(commissionsEntryVM.getContractType());
            handlers.add(handler);
        }
        return handler;
    }

    public static void fromVMFop(BaseProduct product, BookingFileProductFopVM view, BaseProductUIData productData) {
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        boolean negate = productStatus == ProductStatus.REFUND || productStatus == ProductStatus.EXCHANGE;
        List<ProductFopUIData> fopUIData = GeneralProductFXHelper.toUIDataFop(negate, view.getFopTable());
        productData.getFopsList().clear();
        productData.getFopsList().addAll(fopUIData);
    }

    public static void fromVMVendorFinanceDocumentsData(BookingFileVendorFinanceDocumentsDataPanelVM panelVM, BaseProductUIData productData) {
        productData.getVendorFinanceDocumentsDataList().clear();
        panelVM.getContent().forEach(vm -> {
            VendorFinanceDocumentDataUIData uiData = new VendorFinanceDocumentDataUIData();
            uiData.setFinanceDocumentType(vm.getFinanceDocumentType());
            uiData.setNumber(vm.getNumber());
            uiData.setDate(DateUtils.asDate((LocalDate)vm.getDate()));
            uiData.setVendorNumber(vm.getVendorNumber());
            uiData.setVendorDate(DateUtils.asDate((LocalDate)vm.getVendorDate()));
            uiData.setVendorShippingDocumentNumber(vm.getVendorShippingDocumentNumber());
            uiData.setVendorShippingDocumentDate(DateUtils.asDate((LocalDate)vm.getVendorShippingDocumentDate()));
            uiData.setSequenceNumber(vm.getSequenceNumber());
            productData.getVendorFinanceDocumentsDataList().add(uiData);
        });
    }

    private static void fromVMProductFopComponents(BookingFileProductFopVM model, BaseProduct product) {
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        boolean negate = productStatus == ProductStatus.REFUND || productStatus == ProductStatus.EXCHANGE;
        List fopUids = model.getFopTable().stream().map(BaseVM::getUid).collect(Collectors.toList());
        List<String> orphanFopUids = product.getFopDetalizations().entrySet().stream().filter(entry -> !fopUids.contains(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
        orphanFopUids.forEach(orphanFopUid -> {
            FopDetalization cfr_ignored_0 = (FopDetalization)product.getFopDetalizations().remove(orphanFopUid);
        });
        for (BookingFileProductFopTableVM fopTable : model.getFopTable()) {
            FopDetalization fopDetalization;
            if (product.getFopDetalizations().containsKey(fopTable.getUid())) {
                fopDetalization = (FopDetalization)product.getFopDetalizations().get(fopTable.getUid());
            } else {
                if (fopTable.getSuperColumn().getContent().getFopComponent().isEmpty()) continue;
                fopDetalization = new FopDetalization();
                product.getFopDetalizations().put(fopTable.getUid(), fopDetalization);
            }
            VMHelper.transfer(fopTable.getSuperColumn().getContent().getFopComponent(), fopDetalization.getComponents(), fopComponent -> new FopComponent(), (componentVM, component) -> {
                component.setHidden(componentVM.isHidden());
                Traveller traveller = componentVM.getTraveller() == null ? null : GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), componentVM.getTraveller().getUid());
                component.setTraveller(traveller);
                component.setUid(componentVM.getUid());
                component.setVatRate(componentVM.getVatRate());
                component.setType(componentVM.getType());
                component.setNomenclature(componentVM.getNomenclature());
                component.setShipment(componentVM.getShipment());
                component.setCorrectionShipment(componentVM.getCorrectionShipment());
                component.setReceipt(componentVM.getReceipt());
                component.setAmount(GeneralProductFXHelper.getValue(componentVM.getAmount(), negate));
                component.setVatAmount(GeneralProductFXHelper.getValue(componentVM.getVatAmount(), negate));
            });
        }
    }

    public static void fromVMProductContract(BookingFileContractPanelVM controlPanelVM, BaseProductUIData productData) {
        productData.getContractsList().clear();
        for (BookingFileContractTableVM tableVM : controlPanelVM.getContracts()) {
            ProductContractUIData contractUIData = new ProductContractUIData();
            contractUIData.setContractType(tableVM.getContractType());
            contractUIData.setContract(tableVM.getContract());
            contractUIData.setManualContract(tableVM.getManualContract());
            contractUIData.setContractUid(tableVM.getContractUid());
            productData.getContractsList().add(contractUIData);
        }
        productData.getPaymentCurrencies().clear();
        controlPanelVM.getCurrencyConversion().forEach(cc -> {
            if (!cc.isFromContract()) {
                ExchangeRateData rate = new ExchangeRateData();
                rate.setCurrencyRateData(new CurrencyRateData());
                rate.getCurrencyRateData().setType(cc.getCurrencyType());
                rate.getCurrencyRateData().setBaseCurrency(cc.getEquivalentCurrency());
                rate.getCurrencyRateData().setCurrency(cc.getBaseCurrency());
                rate.getCurrencyRateData().setRate(cc.getConversionValue());
                rate.getCurrencyRateData().setDate(DateUtils.asDate((LocalDate)cc.getConversionDate()));
                rate.setCoefficient(cc.getConversionCoefficient());
                rate.setRateWithCoefficient(cc.getConversionCoefficient() * cc.getConversionValue());
                productData.getPaymentCurrencies().put(cc.getContractType(), rate);
            }
        });
    }

    public static void fromVMPassiveSegments(SabrePassiveSegmentsPaneVM vm, BaseProduct product) {
        if (product.getPassiveSegmentsCreationResult() != null) {
            product.getPassiveSegmentsCreationResult().setPcc(vm.getPcc());
            product.getPassiveSegmentsCreationResult().setPnr(vm.getPnr());
            product.getPassiveSegmentsCreationResult().setResponseDate(DateUtils.asDate((LocalDateTime)vm.getTimestamp()));
        }
    }

    public static void configureBlankTypeNodes(DictBoxWidget<BlankType> blankTypeWidget, SimpleCell scnCaptionCell, ComplexCell<TextFieldWidget> scnValueCell) {
        scnCaptionCell.setValue("SCN");
        ControllerInterceptorsHelper.spyFor("BlankTypeCategory", blankTypeWidget, blankTypeRef -> {
            try {
                return (BlankType)((DictService)RpcServiceManager.get().getService(DictService.class)).loadBypassingAcl(ServiceInvocationContext.get(), blankTypeRef);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
                return null;
            }
        }, blankType -> {
            if (blankType != null && blankType.getBlankCategory() == BlankCategory.ETICKET) {
                scnCaptionCell.setValue("ETKT");
                ((TextFieldWidget)scnValueCell.getPayload()).getViewState().setNotEditable(true);
            } else {
                scnCaptionCell.setValue("SCN");
                ((TextFieldWidget)scnValueCell.getPayload()).getViewState().setNotEditable(false);
            }
        });
    }

    public static void configureStatusWidget(HyperlinkWidget statusValueNode, Supplier<BaseProductVM> data) {
        statusValueNode.setOnAction(evt -> {
            BookingFile booking = ((BaseProductVM)data.get()).getBookingFile();
            BaseProduct product = BookingHelper.findProduct((BookingFile)booking, (String)((BaseProductVM)data.get()).getUid());
            if (product == null) {
                return;
            }
            ProductStatusHistoryDialogContainerController statusHistoryController = new ProductStatusHistoryDialogContainerController(true);
            statusHistoryController.getContent().readData(GeneralProductFXHelper.productStatusHistoryToVm(product));
            ProductStatusHistoryDialogContainer pane = statusHistoryController.getView();
            new LightDialog().setTitle(Messages.Product_status_history).setBody((Node)pane).show((Region)statusValueNode);
        });
    }

    private static Collection<ProductStatusHistoryDialogEntryVM> productStatusHistoryToVm(BaseProduct product) {
        return product.getBillingDataChangeEntries().stream().map(entry -> {
            ProductStatusHistoryDialogEntryVM vm = new ProductStatusHistoryDialogEntryVM();
            vm.setDate(com.gridnine.xtrip.common.util.DateUtils.toLocalDateTime((Date)entry.getDate()));
            vm.setStatus(entry.getStatus());
            vm.setSource(entry.getSource());
            return vm;
        }).collect(Collectors.toList());
    }

    public static BookingFileProductStatisticPricesVM afsFields2Vm(StatisticalData statisticalData, FXAfsStatisticalField afsFields) {
        BookingFileProductStatisticPricesVM vm = new BookingFileProductStatisticPricesVM();
        vm.setAfsType(afsFields.getAfsType());
        Object bkg = afsFields.getFieldBkg() == null ? null : statisticalData.getValue(afsFields.getFieldBkg());
        Object tkt = afsFields.getFieldTkt() == null ? null : statisticalData.getValue(afsFields.getFieldTkt());
        vm.setBooking(bkg == null ? null : BigDecimal.valueOf((Double)bkg));
        switch (afsFields.getAfsType()) {
            case HBF1: {
                tkt = tkt == null ? statisticalData.getHigherBenchmarkFare() : tkt;
                vm.setTicket(tkt == null ? null : BigDecimal.valueOf((Double)tkt));
                break;
            }
            case LAF1: {
                tkt = tkt == null ? statisticalData.getLowestAvailableFare() : tkt;
                vm.setTicket(tkt == null ? null : BigDecimal.valueOf((Double)tkt));
                break;
            }
            case ATF1: {
                tkt = tkt == null ? statisticalData.getActualTicketFare() : tkt;
                vm.setTicket(tkt == null ? null : BigDecimal.valueOf((Double)tkt));
                break;
            }
            default: {
                vm.setTicket(tkt == null ? null : BigDecimal.valueOf((Double)tkt));
            }
        }
        return vm;
    }

    public static boolean hasStatisticalDataChanged(BookingFileProductStatisticVM statisticVM, StatisticalData statisticalData) {
        for (BookingFileProductStatisticPricesVM afsRow : statisticVM.getStatistic().getAfs().getPrices()) {
            if (afsRow.getBooking() == null && afsRow.getTicket() == null) continue;
            return true;
        }
        if (statisticVM.getStatistic().getAfs().getParameters().getOverallDestination() != null || statisticVM.getStatistic().getAfs().getParameters().getOverallClassService() != null || statisticVM.getStatistic().getAfs().getParameters().getValidatingCarrier() != null) {
            return true;
        }
        for (BookingFileProductStatisticUdidsVM udid : statisticVM.getStatistic().getUdids()) {
            if (udid.getName() == null && udid.getValue() == null && udid.getLocalValue() == null && udid.getEnglishValue() == null) continue;
            return true;
        }
        return GeneralProductFXHelper.hasReasonCodesDataChanged(statisticVM, statisticalData);
    }

    private static boolean hasReasonCodesDataChanged(BookingFileProductStatisticVM statisticVM, StatisticalData statisticalData) {
        return !CollectionUtils.isEqualCollection((Collection)statisticVM.getStatistic().getReasonCodes().stream().map(BookingFileProductStatisticReasonCodesVM::getReasonCode).collect(Collectors.toList()), (Collection)statisticalData.getReasonCodes());
    }

    public static String getBigDecimalPresentation(BigDecimal bigDecimal) {
        LocaleManager lm = LocaleManager.get();
        DecimalFormat formatter = lm.getLocaleData(lm.getCurrentLocale()).getPriceFormat();
        return formatter.format(bigDecimal != null ? bigDecimal : BigDecimal.ZERO);
    }

    public static Traveller findTraveller(BookingFile bookingFile, String travellerUid) {
        if (bookingFile == null || TextUtil.isBlank((String)travellerUid)) {
            return null;
        }
        return bookingFile.getTravellers().stream().filter(Objects::nonNull).filter(traveller -> ObjectUtils.equals((Object)travellerUid, (Object)traveller.getUid())).findFirst().orElse(null);
    }

    public static Set<ContractType> getHiddenContractTypes(EntityReference<Organization> agency, EntityReference<Organization> subagency) {
        if (subagency == null || subagency.equals(agency)) {
            return Collections.singleton(ContractType.SUBAGENCY);
        }
        return Collections.emptySet();
    }

    private static Map<String, ReasonCode> getAllReasonCodesMap(BookingFile bookingFile) {
        return bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).flatMap(pr -> {
            ProductFXHandler<BaseProduct, ?, ?, ?> handler = ProductFXHandler.forProduct(pr);
            if (handler != null) {
                StatisticalData statisticalData = handler.getStatisticalData((BaseProduct)pr);
                return statisticalData == null ? Stream.empty() : statisticalData.getReasonCodes().stream().filter(Objects::nonNull);
            }
            return Stream.empty();
        }).collect(Collectors.toMap(BaseIdentity::getUid, el -> el, (o1, o2) -> o1));
    }

    public static Map<String, CostCodeProperties> getAllCostCodePropertiesMap(BookingFile bookingFile) {
        return bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).flatMap(pr -> {
            StatisticalData statisticalData;
            ProductFXHandler<BaseProduct, ?, ?, ?> handler = ProductFXHandler.forProduct(pr);
            if (handler != null && (statisticalData = handler.getStatisticalData((BaseProduct)pr)) != null) {
                return statisticalData.getTravellerCostCodes().stream().flatMap(cc -> cc.getCostCodes().stream()).map(CostCode::getCostCodeProperties);
            }
            return Stream.empty();
        }).filter(Objects::nonNull).collect(Collectors.toMap(BaseIdentity::getUid, el -> el, (o1, o2) -> o1));
    }

    private static void actualizeCostCodeProperties(StatisticalData statisticalData, BookingFileProductStatisticVM statisticVM) {
        for (CostCodeProperties profileCostCodeProperty : statisticVM.getProfileCostCodeProperties()) {
            for (BookingFileProductStatisticUdidsVM udid : statisticVM.getStatistic().getUdids()) {
                if (!profileCostCodeProperty.equals((Object)udid.getName()) || profileCostCodeProperty == udid.getName()) continue;
                udid.setName(profileCostCodeProperty);
            }
            if (statisticalData == null) continue;
            for (TravellerCostCodes travellerCostCode : statisticalData.getTravellerCostCodes()) {
                for (CostCode costCode : travellerCostCode.getCostCodes()) {
                    if (!profileCostCodeProperty.equals((Object)costCode.getCostCodeProperties()) || profileCostCodeProperty == costCode.getCostCodeProperties()) continue;
                    costCode.setCostCodeProperties(profileCostCodeProperty);
                }
            }
        }
    }

    public static void savePrototypeData(BaseProduct product) {
        try {
            BaseProduct clone = (BaseProduct)XCloneHelper.clone((XCloneable)product);
            List relatedProducts = ProductHandler.of((BaseProduct)clone).getRelatedProducts(clone);
            clone.setReservation(null);
            ProductHandler.of((BaseProduct)clone).setPreviousProduct(clone, null);
            ProductHandler.of((BaseProduct)clone).setNextProduct(clone, null);
            for (BaseProduct relatedProduct : relatedProducts) {
                ProductHandler.of((BaseProduct)clone).removeRelatedProduct(clone, relatedProduct);
            }
            Path path = Paths.get(Environment.getDataFolder().getPath(), "settings", GeneralProductFXHelper.getPreferredDataFileName(clone));
            FileUtils.writeByteArrayToFile((File)path.toFile(), (byte[])XSUtil.toByteArray((XSSerializable)clone));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public static void loadPrototypeData(BaseProduct product) {
        Path path = Paths.get(Environment.getDataFolder().getPath(), "settings", GeneralProductFXHelper.getPreferredDataFileName(product));
        if (Files.exists(path, new LinkOption[0])) {
            try {
                product.fromXML(DocumentBuilderHelper.parse((File)path.toFile()).getDocumentElement());
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
    }

    private static String getPreferredDataFileName(BaseProduct product) {
        String type = Optional.ofNullable(ProductHandler.of((BaseProduct)product).getProductCategory(product)).filter(item -> item == ProductCategory.MCO).map(item -> item.name().toLowerCase()).orElse(Optional.ofNullable(ProductHandler.of((BaseProduct)product).getProductType(product)).map(item -> item.name().toLowerCase()).orElse(null));
        String description = Optional.ofNullable(ProductHandler.of((BaseProduct)product).getUniversalProductDescription(product)).map(item -> item.getUid()).orElse(null);
        String fileName = "preferred_data" + (type != null ? "_" + type : "") + (description != null ? "_" + description : "") + ".xml";
        return fileName;
    }

    public static void validateStatisticalData(BookingFileSpace space, String productUid, Collection<BookingFileProductStatisticUdidsVM> statisticUdidsVMS, List<Message> errors) throws Exception {
        ServiceInvocationContext serviceInvocationContext;
        BookingFileService service = (BookingFileService)RpcServiceManager.get().getService(BookingFileService.class);
        BaseProduct baseProduct = service.getProductByUid(serviceInvocationContext = ServiceInvocationContext.get(), productUid);
        if (baseProduct != null) {
            String systemNumber = GeneralProductHelper.getSystemNumber((BaseProduct)baseProduct);
            List shipmentCostCodes = service.getClientShipmentCostCodes(serviceInvocationContext, baseProduct);
            for (CostCode costCode : shipmentCostCodes) {
                if (costCode.getCostCodeProperties() == null || costCode.getValue() == null) continue;
                List udidsVm = statisticUdidsVMS.stream().filter(item -> costCode.getCostCodeProperties().equals((Object)item.getName())).collect(Collectors.toList());
                if (udidsVm.isEmpty()) {
                    errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ShipmentCategoryCostCodeDeleted, (Object[])new Object[]{systemNumber, costCode.getCostCodeProperties().getName()}));
                    continue;
                }
                if (!udidsVm.stream().noneMatch(item -> costCode.getValue().equals(item.getValue()))) continue;
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ShipmentCategoryCostCodeValueChanged, (Object[])new Object[]{systemNumber, costCode.getValue(), costCode.getCostCodeProperties().getName()}));
            }
            ProductHandler handler = ProductHandler.of((BaseProduct)baseProduct);
            Date issueDate = handler.findIssueDate(baseProduct);
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            if (issueDate != null) {
                Date date = MiscUtil.clearTime((Date)issueDate);
                EntityReference client = ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)space.getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode().getValue();
                List clientCostCodeProperties = service.getCostCodeProperties(serviceInvocationContext, client);
                for (BookingFileProductStatisticUdidsVM udidVM : statisticUdidsVMS) {
                    CostCodeProperties costCodeProperties = clientCostCodeProperties.stream().filter(item -> item.equals((Object)udidVM.getName())).findFirst().orElse(null);
                    if (costCodeProperties == null || MiscUtil.isBetween((Date)costCodeProperties.getStartDate(), (Date)costCodeProperties.getEndDate(), (Date)date)) continue;
                    errors.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.CostCodePropertiesNotUsed, (Object[])new Object[]{systemNumber, udidVM.getName().getName(), client.getCaption(), format.format(date)}));
                }
            }
        }
    }
}

