/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMCOFeesMainTicketInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMCOFeesOperationVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesTotalSum;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.util.StringConverter;

public class McoFeesFXHelper {
    private static final StringConverter<MCOFeesSource> MCO_FEES_SOURCE_CONVERTER = new StringConverter<MCOFeesSource>(){

        public String toString(MCOFeesSource object) {
            if (object != null) {
                return object.getDescription();
            }
            return "";
        }

        public MCOFeesSource fromString(String string) {
            return null;
        }
    };

    public static void toVMChildParameters(BookingFileProductMCOFeesGeneralPanelVM vm, MCOFees product, BaseProductUIData uiData, BookingFileProductMCOFeesStatusesPaneVM statuses) {
        McoFeesFXHelper.toVMChildTicketInfo(product, vm.getTicketInformation());
        McoFeesFXHelper.toVMOperation(product, vm.getOperation());
        McoFeesFXHelper.toVMControlStatuses(product, statuses, uiData);
        McoFeesFXHelper.toVMSource(product.getSources(), vm.getSource());
    }

    public static void toVMSource(List<MCOFeesSource> sources, List<BookingFileProductMCOFeesTotalSum> vm) {
        VMHelper.transfer(sources, vm, pr -> new BookingFileProductMCOFeesTotalSum(), (source, sourceVM) -> {
            sourceVM.setFare(source.getFare());
            sourceVM.setMcoFeesSource(source);
        });
    }

    public static void toVMAdditionalParameters(BookingFileProductMCOFeesPanelVM vm, MCOFees product) {
        vm.getOtherParameters().getPopups().setComments(product.getComments());
    }

    public static void fromVMChildParameters(BookingFileProductMCOFeesGeneralPanelVM vm, MCOFees product, BaseProductUIData uiData, BookingFileProductMCOFeesStatusesPaneVM statuses) {
        McoFeesFXHelper.fromVMChildTicketInfo(product, vm.getTicketInformation());
        McoFeesFXHelper.fromVMOperation(product, vm.getOperation());
        McoFeesFXHelper.fromVMControlStatuses(product, statuses, uiData);
        McoFeesFXHelper.fromVMSource(product, vm);
    }

    public static void fromVMAdditionalParameters(BookingFileProductMCOFeesPanelVM vm, MCOFees product) {
        product.setComments(vm.getOtherParameters().getPopups().getComments());
    }

    private static void toVMChildTicketInfo(MCOFees product, BookingFileMCOFeesMainTicketInfoVM vm) {
        vm.setProductValue(ProductType.MCO_FEES.toString());
        vm.setBlankValue(product.getBlankType());
        vm.setStatusValue(EnumUtil.stringValueOf((Enum)product.getStatus()));
        vm.setTicketTypeValue(product.getTicketType());
        vm.setScnValue(product.getScn());
        vm.setAgencyValue(product.getAgency());
        vm.setSalesPointValue(product.getSalesPoint());
        vm.setPrescribeAgentValue(product.getAgent());
        product.getReservation().getBookingFile().getTravellers().stream().filter(el -> el.getUid().equals(product.getTravellerUid())).findFirst().ifPresent(arg_0 -> ((BookingFileMCOFeesMainTicketInfoVM)vm).setPassengerValue(arg_0));
    }

    private static void toVMOperation(MCOFees product, BookingFileMCOFeesOperationVM vm) {
        vm.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        vm.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        vm.setPaymentTypeValue(product.getPaymentType());
        vm.setTotalValue(MoneyHelper.buildMoney((BigDecimal)product.getTotal(), (String)Prefetched.getData().getEquivalentCurrency()));
    }

    private static void toVMControlStatuses(MCOFees product, BookingFileProductMCOFeesStatusesPaneVM vm, BaseProductUIData productData) {
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        vm.setHasErrors(productData.isHasErrors());
        vm.setHasWarnings(productData.isHasWarnings());
    }

    private static void fromVMChildTicketInfo(MCOFees product, BookingFileMCOFeesMainTicketInfoVM vm) {
        product.setBlankType(vm.getBlankValue());
        product.setTicketType(vm.getTicketTypeValue());
        product.setScn(vm.getScnValue());
        product.setAgency(vm.getAgencyValue());
        product.setSalesPoint(vm.getSalesPointValue());
        product.setAgent(vm.getPrescribeAgentValue());
        if (vm.getPassengerValue() != null) {
            product.setTravellerUid(vm.getPassengerValue().getUid());
        }
    }

    private static void fromVMSource(MCOFees product, BookingFileProductMCOFeesGeneralPanelVM vm) {
        Map<String, MCOFeesSource> sourceUid = product.getSources().stream().collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        product.getSources().clear();
        product.getSources().addAll(vm.getSource().stream().map(BookingFileProductMCOFeesTotalSum::getMcoFeesSource).filter(Objects::nonNull).map(vmSource -> sourceUid.getOrDefault(vmSource.getUid(), (MCOFeesSource)vmSource)).collect(Collectors.toList()));
        product.setTotal(McoFeesFXHelper.calculateTotalFromProductSources(product.getSources()));
    }

    public static BigDecimal calculateTotalFromProductSources(List<MCOFeesSource> sources) {
        return sources.stream().filter(source -> source.getFare() != null).map(mcoFeesSource -> mcoFeesSource.getFare().getValue()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    private static void fromVMControlStatuses(MCOFees product, BookingFileProductMCOFeesStatusesPaneVM vm, BaseProductUIData uiData) {
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        product.setChecked(vm.isChecked());
        uiData.setHasErrors(vm.isHasErrors());
    }

    private static void fromVMOperation(MCOFees product, BookingFileMCOFeesOperationVM vm) {
        product.setIssueDate(DateUtils.asDate((LocalDateTime)vm.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)vm.getCorrectionDateValue()));
        product.setPaymentType(vm.getPaymentTypeValue());
    }

    public static MiscUtil.Pair<MCOFees, BaseProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        MCOFees product = new MCOFees();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new MCOFees(), (Object)new BaseProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductMCOFeesPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(MCOFees.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }

    public static StringConverter<MCOFeesSource> getMcoFeesSourceConverter() {
        return MCO_FEES_SOURCE_CONVERTER;
    }

    public static class Configuration {
        private List<MCOFeesSource> sources;

        public List<MCOFeesSource> getSources() {
            return this.sources;
        }

        public void setSources(List<MCOFeesSource> sources) {
            this.sources = sources;
        }
    }
}

