/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripCostPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripCostSumPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripSalesChainPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripTicketInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTransferXtripTravelerInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.CustomVatContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.transfer.TransferHelper;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.uidata.TransferProductXtripUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

public class TransferFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVM(Transfer product, TransferProductXtripUIData productData, BookingFileProductTransferXtripPanelVM vm) {
        vm.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        vm.setUid(product.getUid());
        TransferFXHelper.toVMStatuses(vm.getStatuses(), product, productData);
        TransferFXHelper.toVMGeneral(vm.getGeneral(), productData, product);
        TransferFXHelper.toVMCost(vm.getCost(), product, productData);
        vm.getOtherParameters().setComments(product.getComments());
    }

    public static void fromVM(BookingFileProductTransferXtripPanelVM vm, Transfer product, TransferProductXtripUIData productData) {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
        TransferFXHelper.fromVMGeneral(vm.getGeneral(), product, productData);
        TransferFXHelper.fromVMStatuses(vm.getStatuses(), product, productData);
        TransferFXHelper.fromVMCost(vm.getCost(), product);
        product.setComments(vm.getOtherParameters().getComments());
    }

    private static void toVMGeneral(BookingFileProductTransferXtripGeneralPanelVM vm, TransferProductXtripUIData productData, Transfer product) {
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        BookingFileProductTransferXtripTicketInfoPaneVM ticketInfoVM = vm.getTicketInfo();
        ticketInfoVM.setProductValue(ProductType.TRANSFER.toString());
        ticketInfoVM.setStatusValue(productStatus != null ? productStatus.toString() : null);
        ticketInfoVM.setTicketNumberValue(product.getIwayBookerNumber());
        ticketInfoVM.setSystemNumberValue(product.getSystemNumber());
        ticketInfoVM.setBookingNumberValue(product.getReservation().getUid());
        ticketInfoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        ticketInfoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        ticketInfoVM.setStartDateValue(DateUtils.asLocalDateTime((Date)product.getStartDate()));
        ticketInfoVM.setStartAddressValue(product.getStartAddress());
        ticketInfoVM.setStartCountryValue(product.getStartCountry());
        ticketInfoVM.setStartCityValue(product.getStartCity());
        ticketInfoVM.setStartTypeValue(product.getStartType());
        ticketInfoVM.setEndDateValue(DateUtils.asLocalDateTime((Date)product.getEndDate()));
        ticketInfoVM.setEndAddressValue(product.getEndAddress());
        ticketInfoVM.setEndCountryValue(product.getEndCountry());
        ticketInfoVM.setEndCityValue(product.getEndCity());
        ticketInfoVM.setEndTypeValue(product.getEndType());
        VMHelper.transfer(product.getSubAddresses(), ticketInfoVM.getSubAddressesValue());
        BookingFileProductTransferXtripTravelerInfoPaneVM travelerInfoVM = vm.getTravelerInfo();
        VMHelper.transfer(product.getTravellers(), travelerInfoVM.getTravellersValue());
        travelerInfoVM.setInfo(product.getNotes());
        travelerInfoVM.setContactPersonValue(product.getContactPerson());
        travelerInfoVM.setPassengersCountValue(product.getPassengersCount());
        travelerInfoVM.setCarClassValue(product.getCarClass());
        travelerInfoVM.setCurrencyRateCodeValue(product.getCurrencyRate());
        travelerInfoVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        travelerInfoVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        BookingFileProductTransferXtripSalesChainPaneVM salesChainVM = vm.getSalesChain();
        salesChainVM.setBlankOwnerValue(product.getBlankOwner());
        salesChainVM.setSupplierValue(productData.getSupplier());
        salesChainVM.setAgencyValue(productData.getAgency());
        salesChainVM.setSubagencyValue(productData.getSubagency());
        salesChainVM.setSalesPointValue(product.getSalesPoint());
        salesChainVM.setPrescribeAgentValue(product.getAgent());
        salesChainVM.setTicketTypeValue(product.getTicketType());
    }

    private static void toVMStatuses(BookingFileProductStatusesPaneVM vm, Transfer product, TransferProductXtripUIData productData) {
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        vm.setHasErrors(productData.isHasErrors());
        vm.setHasWarnings(productData.isHasWarnings());
        vm.setRulesApplied(product.isContractRulesApplied());
    }

    private static void toVMCost(BookingFileProductTransferXtripCostPaneVM costVM, Transfer product, TransferProductXtripUIData productData) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductTransferXtripCostSumPaneVM sumVM = costVM.getSum();
        BigDecimal ndsValue = null;
        String currency = null;
        if (product.getFare() != null) {
            currency = product.getFare().getCurrency();
            sumVM.setTariffSum(TransferFXHelper.getValue(product.getFare().getValue(), negate));
            sumVM.setTariffCurrency(currency);
        }
        if (product.getEquivalentFare() != null) {
            currency = product.getEquivalentFare().getCurrency();
            sumVM.setEqTariffSum(TransferFXHelper.getValue(product.getEquivalentFare().getValue(), negate));
            sumVM.setEqTariffCurrency(currency);
        }
        if (product.getEquivalentFareVatValue() != null) {
            VatValue vatValue = product.getEquivalentFareVatValue();
            ndsValue = vatValue.getAmount();
            sumVM.getVatIncludedEqTariff().setVatAmount(TransferFXHelper.getValue(vatValue.getAmount(), negate));
            sumVM.getVatIncludedEqTariff().setVatRate(vatValue.getRate());
        }
        sumVM.setPenaltySum(product.getPenalty());
        sumVM.setPenaltyCurrency(currency);
        sumVM.setTotalSum(TransferHelper.getTotalPrice((Transfer)product));
        sumVM.setVatIncludedTotal(TransferFXHelper.getValue(ndsValue, negate));
        sumVM.setTotalCurrency(currency);
        costVM.getRates().setRateValue(productData.getRate());
        costVM.getRates().setEqCurrencyValue(productData.getEqCurrency() == null ? null : productData.getEqCurrency());
        costVM.getRates().setBaseCurrencyValue(productData.getBaseCurrency() == null ? null : productData.getBaseCurrency());
    }

    private static void fromVMGeneral(BookingFileProductTransferXtripGeneralPanelVM vm, Transfer product, TransferProductXtripUIData productData) {
        BookingFileProductTransferXtripTicketInfoPaneVM ticketInfoVM = vm.getTicketInfo();
        product.setSystemNumber(ticketInfoVM.getSystemNumberValue());
        product.setIwayBookerNumber(ticketInfoVM.getTicketNumberValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getCorrectionDateValue()));
        product.setStartDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getStartDateValue()));
        product.setStartAddress(ticketInfoVM.getStartAddressValue());
        product.setStartCountry(ticketInfoVM.getStartCountryValue());
        product.setStartCity(ticketInfoVM.getStartCityValue());
        product.setStartType(ticketInfoVM.getStartTypeValue());
        product.setEndDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getEndDateValue()));
        product.setEndAddress(ticketInfoVM.getEndAddressValue());
        product.setEndCountry(ticketInfoVM.getEndCountryValue());
        product.setEndCity(ticketInfoVM.getEndCityValue());
        product.setEndType(ticketInfoVM.getEndTypeValue());
        VMHelper.transfer(ticketInfoVM.getSubAddressesValue(), product.getSubAddresses());
        BookingFileProductTransferXtripTravelerInfoPaneVM travelerInfoVM = vm.getTravelerInfo();
        product.getTravellers().clear();
        travelerInfoVM.getTravellersValue().forEach(tr -> {
            Traveller traveller;
            if (tr != null && (traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), tr.getUid())) != null) {
                product.getTravellers().add(traveller);
            }
        });
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateSubagentValue()));
        product.setNotes(travelerInfoVM.getInfo());
        product.setContactPerson(travelerInfoVM.getContactPersonValue());
        product.setPassengersCount(travelerInfoVM.getPassengersCountValue());
        product.setCarClass(travelerInfoVM.getCarClassValue());
        product.setCurrencyRate(travelerInfoVM.getCurrencyRateCodeValue());
        BookingFileProductTransferXtripSalesChainPaneVM salesChainVM = vm.getSalesChain();
        product.setBlankOwner(salesChainVM.getBlankOwnerValue());
        productData.setSupplier(salesChainVM.getSupplierValue());
        productData.setAgency(salesChainVM.getAgencyValue());
        productData.setSubagency(salesChainVM.getSubagencyValue());
        product.setSalesPoint(salesChainVM.getSalesPointValue());
        product.setAgent(salesChainVM.getPrescribeAgentValue());
        product.setTicketType(salesChainVM.getTicketTypeValue());
    }

    private static void fromVMStatuses(BookingFileProductStatusesPaneVM vm, Transfer product, TransferProductXtripUIData productData) {
        product.setChecked(vm.isChecked());
        product.setCompleted(vm.isFinished());
        productData.setHasErrors(vm.isHasErrors());
        product.setContractRulesApplied(vm.isRulesApplied());
    }

    public static void fromVMCost(BookingFileProductTransferXtripCostPaneVM costVM, Transfer product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductTransferXtripCostSumPaneVM sumVM = costVM.getSum();
        if (product.getFare() == null) {
            product.setFare(new Money());
        }
        product.getFare().setValue(TransferFXHelper.getValue(sumVM.getTariffSum(), negate));
        product.getFare().setCurrency(sumVM.getTariffCurrency());
        if (product.getEquivalentFare() == null) {
            product.setEquivalentFare(new Money());
        }
        product.getEquivalentFare().setValue(TransferFXHelper.getValue(sumVM.getEqTariffSum(), negate));
        product.getEquivalentFare().setCurrency(sumVM.getEqTariffCurrency());
        if (product.getEquivalentFareVatValue() == null) {
            product.setEquivalentFareVatValue(new VatValue());
        }
        CustomVatContainerVM vatEq = sumVM.getVatIncludedEqTariff();
        product.getEquivalentFareVatValue().setRate(vatEq.getVatRate());
        product.getEquivalentFareVatValue().setAmount(TransferFXHelper.getValue(vatEq.getVatAmount(), negate));
        product.setPenalty(sumVM.getPenaltySum());
    }

    public static MiscUtil.Pair<Transfer, TransferProductXtripUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        Transfer product = new Transfer();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new Transfer(), (Object)new TransferProductXtripUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductTransferXtripPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(Transfer.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

