/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.branch;

import com.gridnine.xtrip.client.fx.model.profile.BranchAddressVM;
import com.gridnine.xtrip.client.fx.model.profile.BranchContactsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.BranchEmailVM;
import com.gridnine.xtrip.client.fx.model.profile.BranchSiteVM;
import com.gridnine.xtrip.client.fx.model.profile.ContactPhonesTableVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Communication;
import java.util.ArrayList;

final class BranchContactsTileHelper {
    private BranchContactsTileHelper() {
    }

    static void toVM(Branch model, BranchContactsPanelVM full) {
        full.setPrefLang(model.getPreferredLocale());
        ArrayList<Communication> phones = new ArrayList<Communication>();
        ArrayList<Communication> emails = new ArrayList<Communication>();
        ArrayList<Communication> sites = new ArrayList<Communication>();
        block4: for (Communication cmm2 : model.getCommunications()) {
            if (cmm2.getType() == null) {
                phones.add(cmm2);
                continue;
            }
            switch (cmm2.getType()) {
                case EMAIL: {
                    emails.add(cmm2);
                    continue block4;
                }
                case WEB: {
                    sites.add(cmm2);
                    continue block4;
                }
            }
            phones.add(cmm2);
        }
        VMHelper.transfer(phones, full.getPhones(), cmm -> new ContactPhonesTableVM(), (cmm, vm) -> {
            vm.setType(cmm.getType());
            vm.setCountryCode(cmm.getCountryCode());
            vm.setCityCode(cmm.getCityCode());
            vm.setPhoneNumber(cmm.getSense());
            vm.setInternalNumber(cmm.getInternalNumber());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(emails, full.getEmails(), cmm -> new BranchEmailVM(), (cmm, vm) -> {
            vm.setAddress(cmm.getSense());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(sites, full.getSites(), cmm -> new BranchSiteVM(), (cmm, vm) -> {
            vm.setAddress(cmm.getSense());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(model.getAddresses(), full.getAddresses(), address -> new BranchAddressVM(), (address, vm) -> {
            vm.getGeneral().setType(address.getAddressType());
            vm.getGeneral().setZip(address.getZip());
            vm.getGeneral().setCountry(address.getCountry());
            vm.getGeneral().setCity(address.getCity());
            vm.getGeneral().setStreet(address.getAddress());
            vm.getGeneral().setBuilding(address.getHouse());
            vm.getGeneral().setOffice(address.getOffice());
            vm.getExtraMain().setRegion(address.getRegion());
            vm.getExtraMain().setDistrict(address.getDistrict());
            vm.getExtraMain().setLocality(address.getTown());
            vm.getExtraMain().setPoBox(address.getPoBox());
            vm.getExtraMain().setHousing(address.getHousing());
            vm.getExtraMain().setBuilding(address.getBuilding());
            vm.getExtraMain().setPavilion(address.getPavilion());
            vm.getExtraMain().setFlat(address.getFlat());
            vm.getExtraMain().setMetroStation(address.getMetroStation());
            vm.getExtraMain().setDeliveryRegion(address.getDeliveryRegion());
            vm.getExtraMain().setComment(address.getNotes());
        });
    }

    static void fromVM(BranchContactsPanelVM full, Branch model) {
        model.setPreferredLocale(full.getPrefLang());
        ArrayList communicationVMs = new ArrayList();
        communicationVMs.addAll(full.getPhones());
        communicationVMs.addAll(full.getEmails());
        communicationVMs.addAll(full.getSites());
        VMHelper.transfer(communicationVMs, model.getCommunications(), vm -> new Communication(), (vm, cmm) -> {
            if (vm instanceof ContactPhonesTableVM) {
                ContactPhonesTableVM phoneVM = (ContactPhonesTableVM)vm;
                cmm.setType(phoneVM.getType());
                cmm.setCountryCode(phoneVM.getCountryCode());
                cmm.setCityCode(phoneVM.getCityCode());
                cmm.setSense(phoneVM.getPhoneNumber());
                cmm.setInternalNumber(phoneVM.getInternalNumber());
                cmm.setRemarks(phoneVM.getNotes());
            } else if (vm instanceof BranchEmailVM) {
                BranchEmailVM emailVM = (BranchEmailVM)vm;
                cmm.setType(CommunicationType.EMAIL);
                cmm.setSense(emailVM.getAddress());
                cmm.setRemarks(emailVM.getNotes());
            } else if (vm instanceof BranchSiteVM) {
                BranchSiteVM siteVM = (BranchSiteVM)vm;
                cmm.setType(CommunicationType.WEB);
                cmm.setSense(siteVM.getAddress());
                cmm.setRemarks(siteVM.getNotes());
            }
        });
        VMHelper.transfer(full.getAddresses(), model.getAddresses(), vm -> new Address(), (vm, address) -> {
            address.setAddressType(vm.getGeneral().getType());
            address.setZip(vm.getGeneral().getZip());
            address.setCountry(vm.getGeneral().getCountry());
            address.setCity(vm.getGeneral().getCity());
            address.setRegion(vm.getExtraMain().getRegion());
            VMHelper.fromVM(vm.getGeneral().getStreet(), address.getAddress());
            VMHelper.fromVM(vm.getGeneral().getBuilding(), address.getHouse());
            VMHelper.fromVM(vm.getGeneral().getOffice(), address.getOffice());
            VMHelper.fromVM(vm.getExtraMain().getDistrict(), address.getDistrict());
            VMHelper.fromVM(vm.getExtraMain().getLocality(), address.getTown());
            address.setPoBox(vm.getExtraMain().getPoBox());
            VMHelper.fromVM(vm.getExtraMain().getHousing(), address.getHousing());
            VMHelper.fromVM(vm.getExtraMain().getBuilding(), address.getBuilding());
            VMHelper.fromVM(vm.getExtraMain().getPavilion(), address.getPavilion());
            VMHelper.fromVM(vm.getExtraMain().getFlat(), address.getFlat());
            address.setMetroStation(vm.getExtraMain().getMetroStation());
            address.setDeliveryRegion(vm.getExtraMain().getDeliveryRegion());
            address.setNotes(vm.getExtraMain().getComment());
        });
    }
}

