/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.branch;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.profile.BranchSpace;
import com.gridnine.xtrip.client.fx.model.profile.BranchSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.BranchSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.branch.BranchBankAccountsTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.branch.BranchContactsTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.branch.BranchGeneralTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.branch.BranchOtherParametersTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.branch.BranchPaymentOptionsTIleHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.branch.controllerinterceptors.BranchAddressExtraPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.branch.controllerinterceptors.BranchAddressGeneralPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.branch.controllerinterceptors.BranchContactsControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.branch.controllerinterceptors.BranchControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.OrganizationDocumentsTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors.OrganizationDocumentsPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors.OrganizationFinanceDocumentSettingControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors.OrganizationPaymentDocumentSettingControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors.OrganizationSignaturesPanelControllerInterceptor;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.BranchIndex;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;

public class BranchHandler
extends BaseRootEntityHandler<Branch, Void, BranchSpaceVM, BranchSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BranchIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<Branch, Void>, BranchSpaceVM>> toVM, List<BiConsumer<BranchSpaceVM, DataTransferPackage<Branch, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new BranchControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new BranchContactsControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new BranchAddressExtraPanelControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new BranchAddressGeneralPanelControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new OrganizationDocumentsPanelControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new OrganizationSignaturesPanelControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new OrganizationPaymentDocumentSettingControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new OrganizationFinanceDocumentSettingControllerInterceptor());
        toVM.add((dtp, vm) -> {
            Branch model = (Branch)dtp.getContainer().getEntity();
            vm.getOverview().setCode(model.getCode());
            vm.getOverview().setAgency(model.getAgency());
            vm.getOverview().setShortName(model.getShortName());
            BranchGeneralTileHelper.toVM(model, vm.getGeneralFull());
            BranchContactsTileHelper.toVM(model, vm.getContactsFull());
            BranchBankAccountsTileHelper.toVM(model, vm.getBankAccountsFull());
            OrganizationDocumentsTileHelper.toVM(model.getShipmentProperties(), model.getFinanceDocumentProperties(), model.getPaymentDocumentProperties(), vm.getDocumentsFull());
            BranchPaymentOptionsTIleHelper.toVM(model, vm.getPaymentOptionsFull());
            BranchOtherParametersTileHelper.toVM(model, vm.getOtherParametersFull());
        });
        fromVM.add((vm, dtp) -> {
            Branch model = (Branch)dtp.getContainer().getEntity();
            BranchGeneralTileHelper.fromVM(vm.getGeneralFull(), model);
            BranchContactsTileHelper.fromVM(vm.getContactsFull(), model);
            BranchBankAccountsTileHelper.fromVM(vm.getBankAccountsFull(), model);
            OrganizationDocumentsTileHelper.fromVM(vm.getDocumentsFull(), model.getShipmentProperties(), model.getFinanceDocumentProperties(), model.getPaymentDocumentProperties());
            if (vm.getDocumentsFull().getFinanceDocuments().getBankAccount() != null) {
                Optional<BankAccount> opt = model.getBankAccounts().stream().filter(el -> el.equals((Object)vm.getDocumentsFull().getFinanceDocuments().getBankAccount().getBankAccount())).findFirst();
                if (opt.isPresent()) {
                    model.getFinanceDocumentProperties().setBankAccount(opt.get());
                } else {
                    model.getFinanceDocumentProperties().setBankAccount(vm.getDocumentsFull().getFinanceDocuments().getBankAccount().getBankAccount());
                }
            }
            BranchPaymentOptionsTIleHelper.fromVM(vm.getPaymentOptionsFull(), model);
            BranchOtherParametersTileHelper.fromVM(vm.getOtherParametersFull(), model);
        });
    }

    public Class<Branch> getEntityClass() {
        return Branch.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected BranchSpaceVM createVM() {
        return new BranchSpaceVM();
    }

    @Override
    protected ViewController<BranchSpace, BranchSpaceVM> createSpaceController(boolean readonly) {
        return new BranchSpaceController(readonly);
    }
}

