/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractDetailsBankAccountGridPanel;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractDetailsClientBankAccountGridPanel;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractDetailsCurrencyRatesGridPanel;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractDetailsFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractDetailsFullPanelController;
import com.gridnine.xtrip.client.fx.model.profile.ContractDetailsVM;
import com.gridnine.xtrip.client.fx.model.profile.CurrencyRateVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBankAccountVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.ContractCurrencyDetailsConfigurator;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class ClientContractDetailsControllerInterceptor
extends ControllerInterceptor<ContractDetailsVM, ClientContractDetailsFullPanelController> {
    protected Class<ClientContractDetailsFullPanelController> getControllerClass() {
        return ClientContractDetailsFullPanelController.class;
    }

    protected void onCreate(ClientContractDetailsFullPanelController controller) {
        for (ContractCurrencyDetailsConfigurator configurator : ClientRegistry.get().allOf(ContractCurrencyDetailsConfigurator.TYPE).values()) {
            configurator.configureTable((TableWidget<CurrencyRateVM>)((ClientContractDetailsCurrencyRatesGridPanel)controller.getView().getCurrencyDetailsCard().getContent()).getCurrencyRatesNode());
        }
        ComboBoxWidget bankAccountWidget = ((ClientContractDetailsBankAccountGridPanel)controller.getView().getBankAccountDetailsCard().getContent()).getBankAccountNode();
        this.setBankAccountVmList((ComboBoxWidget<OrganizationBankAccountVM>)bankAccountWidget, controller.getView(), true);
        ((ClientContractDetailsBankAccountGridPanel)controller.getView().getBankAccountDetailsCard().getContent()).getBankAccountNode().setConverter(this.getOrganizationBankAccountConverter());
        ComboBoxWidget clientBankAccountWidget = ((ClientContractDetailsClientBankAccountGridPanel)controller.getView().getClientBankAccountDetailsCard().getContent()).getClientBankAccountNode();
        this.setBankAccountVmList((ComboBoxWidget<OrganizationBankAccountVM>)clientBankAccountWidget, controller.getView(), false);
        ((ClientContractDetailsClientBankAccountGridPanel)controller.getView().getClientBankAccountDetailsCard().getContent()).getClientBankAccountNode().setConverter(this.getOrganizationBankAccountConverter());
    }

    private void setBankAccountVmList(ComboBoxWidget<OrganizationBankAccountVM> bankAccountWidget, ClientContractDetailsFullPanel panel, boolean isSupplier) {
        bankAccountWidget.setLive(true);
        bankAccountWidget.setAsync(true);
        bankAccountWidget.setItemsSupplier(() -> {
            List<BankAccount> bankAccountList = this.getOrganizationBankAccountList(panel, isSupplier);
            return bankAccountList.stream().map(item -> {
                OrganizationBankAccountVM vm = new OrganizationBankAccountVM();
                vm.setBankAccount(item);
                return vm;
            }).collect(Collectors.toList());
        });
    }

    private String getBankAccountString(BankAccount bankAccount) {
        if (bankAccount != null) {
            if (bankAccount.getBankName() != null && bankAccount.getBankName().length() > 0 && bankAccount.getSettlementAccount() != null && bankAccount.getSettlementAccount().length() > 0) {
                return bankAccount.getBankName() + " - " + bankAccount.getSettlementAccount();
            }
            if (bankAccount.getBankName() != null && bankAccount.getBankName().length() > 0) {
                return bankAccount.getBankName();
            }
            if (bankAccount.getSettlementAccount() != null && bankAccount.getSettlementAccount().length() > 0) {
                return bankAccount.getSettlementAccount();
            }
        }
        return UiUtil.NULL_TEXT;
    }

    private StringConverter<OrganizationBankAccountVM> getOrganizationBankAccountConverter() {
        return new StringConverter<OrganizationBankAccountVM>(){

            public String toString(OrganizationBankAccountVM object) {
                if (object != null) {
                    BankAccount bankAccount = object.getBankAccount();
                    return ClientContractDetailsControllerInterceptor.this.getBankAccountString(bankAccount);
                }
                return UiUtil.NULL_TEXT;
            }

            public OrganizationBankAccountVM fromString(String string) {
                return null;
            }
        };
    }

    private List<BankAccount> getOrganizationBankAccountList(ClientContractDetailsFullPanel panel, boolean isSupplier) {
        EntityContainer ctr;
        ArrayList<BankAccount> result = new ArrayList<BankAccount>();
        RootEntityPane pane = RootEntityPane.lookup((Node)panel);
        if (pane != null && pane.getData() != null && pane.getData().getContainer() != null && (ctr = pane.getData().getContainer()) != null && ctr.getEntity().getClass().isAssignableFrom(Contract.class)) {
            EntityReference org = isSupplier ? ((Contract)ctr.getEntity()).getSupplier() : ((Contract)ctr.getEntity()).getCustomer();
            try {
                EntityContainer organization = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), org);
                if (organization != null) {
                    result.addAll(((Organization)organization.getEntity()).getBankAccounts().stream().filter(item -> TextUtil.nonBlank((String)item.getBankName()) && TextUtil.nonBlank((String)item.getSettlementAccount())).collect(Collectors.toList()));
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
        return result;
    }
}

