/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.QueryDataViewHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.Contract2AllModelContractsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpaceController;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.ContractService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.scene.Node;

public class Contract2ModelContractQueryDataHandler
extends QueryDataViewHandler<Contract2AllModelContractsPanelVM> {
    private final ContractSpaceController controller;

    Contract2ModelContractQueryDataHandler(ContractSpaceController controller) {
        this.controller = controller;
        this.setQuery(new SearchQuery());
    }

    protected List<Contract2AllModelContractsPanelVM> executeQuery(SearchQuery query) throws Exception {
        ArrayList<Contract2AllModelContractsPanelVM> result = new ArrayList<Contract2AllModelContractsPanelVM>();
        ContractService contractService = (ContractService)RpcServiceManager.get().getService(ContractService.class);
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        FxUtil.waitForFxThread(() -> {
            RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)this.controller.getView());
            if (rootEntityPane != null && rootEntityPane.getData() != null) {
                EntityContainer container = rootEntityPane.getData().getContainer();
                List serverResult = contractService.getContract2ModelContractUIData(sic, container.toReference(), query);
                VMHelper.transfer(serverResult, result, item -> {
                    Contract2AllModelContractsPanelVM vm = new Contract2AllModelContractsPanelVM();
                    vm.setStartDate(item.getStartDate());
                    vm.setEndDate(item.getEndDate());
                    vm.setTranslateSupplierFees(item.getTranslateSupplierFees());
                    vm.setDirectBinding(Boolean.valueOf(item.isDirectBinding()));
                    vm.setName(item.getName());
                    vm.setPriority(item.getPriority());
                    vm.setSource(item.getSource());
                    return vm;
                });
            }
        });
        if (!result.isEmpty()) {
            result.sort((str1, str2) -> {
                double b;
                double a = Double.parseDouble(str1.getPriority());
                if (a < (b = Double.parseDouble(str2.getPriority()))) {
                    return 1;
                }
                if (a > b) {
                    return -1;
                }
                SimpleDateFormat sourceFormat = new SimpleDateFormat("dd.MM.yyyy");
                try {
                    if (str1.getEndDate() == null && str2.getEndDate() == null) {
                        return 0;
                    }
                    if (str1.getEndDate() == null) {
                        return -1;
                    }
                    if (str2.getEndDate() == null) {
                        return 1;
                    }
                    Date date1 = sourceFormat.parse(str1.getEndDate());
                    Date date2 = sourceFormat.parse(str2.getEndDate());
                    return -date1.compareTo(date2);
                }
                catch (ParseException e) {
                    ErrorHandler.handle((Throwable)e);
                    return 0;
                }
            });
        }
        return result;
    }
}

