/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.SuperColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.BaseGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.model.profile.AppliedToVM;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractDetailsFullGeneralPanelBigTable;
import com.gridnine.xtrip.client.fx.model.profile.ClientContractMainFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.Contract2AllModelContractsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractAgenciesFilterPanel;
import com.gridnine.xtrip.client.fx.model.profile.ContractClientsFilterPanel;
import com.gridnine.xtrip.client.fx.model.profile.ContractDetailsVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpace;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpaceOverviewMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractSubAgenciesFilterPanel;
import com.gridnine.xtrip.client.fx.model.profile.OtherParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.SubagencyContractMainFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractApplicationsNavigateContainer;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractDetailsFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractMainFullPanel;
import com.gridnine.xtrip.client.fx.model.system.RelatedDocumentsPanel;
import com.gridnine.xtrip.client.fx.model.system.SysLogDataItemVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.ClientsContractMainTileActions;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.Contract2ModelContractQueryDataHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.ContractItemsConverterHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.ContractPanelsSynchronizationHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.SubagencyContractMainTileActions;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.SupplierContractApplicationsTileActions;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.SupplierContractMainTileActions;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.DataViewWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.RelatedDocumentsConfiguration;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.client.fx.standard.rules.RulesWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.rules.StandardFilters;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.profile.VendorContractType;
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationAdditionalTargets;
import com.gridnine.xtrip.common.model.rules.subsidized.SubsidizedContractFilteringCategories;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;

public class ContractSpaceControllerInterceptor
extends ControllerInterceptor<ContractSpaceVM, ContractSpaceController> {
    private static final List<Tile<?, ?>> hiddenTilesFromOthersPlugins = new ArrayList();

    public static List<Tile<?, ?>> getHiddenTilesFromOthersPlugins() {
        return hiddenTilesFromOthersPlugins;
    }

    public static void configureRulesTile(Tile<Node, CustomWidget<RuleSet>> tile) {
        RulesViewConfiguration config = new RulesViewConfiguration();
        config.setActionsSupplier(target -> RulesEnvironment.get().getActions(target).stream().filter(action -> {
            boolean flag = false;
            for (RuleFilteringCategory category : RulesEnvironment.get().getFilteringCategories()) {
                if (!ContractSpaceControllerInterceptor.checkFilteringCategory(category) || !RulesEnvironment.get().getActions(category).contains(action) || !RulesEnvironment.get().getTargets(category).contains(target)) continue;
                flag = true;
            }
            return flag;
        }).collect(Collectors.toList()));
        config.setTargetsSupplier(() -> {
            boolean additionalTargetsNeeded = Prefetched.getData().isShowSabreSyncRuleTargets();
            List<SabreSynchronizationAdditionalTargets> additionalTargets = Arrays.asList(SabreSynchronizationAdditionalTargets.values());
            HashSet<RuleTarget> targets = new HashSet<RuleTarget>();
            for (RuleFilteringCategory category : RulesEnvironment.get().getFilteringCategories()) {
                if (!ContractSpaceControllerInterceptor.checkFilteringCategory(category)) continue;
                for (RuleTarget target : RulesEnvironment.get().getTargets(category)) {
                    if (!target.isAvailableToCreate() || !additionalTargetsNeeded && additionalTargets.contains(target)) continue;
                    targets.add(target);
                }
            }
            return new ArrayList(targets);
        });
        config.getFilters().addAll(Arrays.asList(StandardFilters.values()));
        RulesWidgetHelper.initTile(tile, config);
    }

    private static boolean checkFilteringCategory(RuleFilteringCategory object) {
        return ContractsFilteringCategories.contains((Object)object) || SubsidizedContractFilteringCategories.AVIA_SUBSIDIZED_CONTRACT == object;
    }

    static List<AppliedToVM> getAppliedToList() {
        ArrayList<AppliedToVM> result = new ArrayList<AppliedToVM>();
        for (RuleTarget target : RulesEnvironment.get().getTargets(null)) {
            AppliedToVM vm = new AppliedToVM();
            vm.setAppliedTo(target.getDisplayName());
            result.add(vm);
        }
        result.sort((o1, o2) -> TextUtil.compare((String)o1.getAppliedTo(), (String)o2.getAppliedTo(), (boolean)false, (boolean)true));
        return result;
    }

    private static void setStringConverters(ContractSpaceController main) {
        ((OtherParametersFullPanel)main.getView().getOtherParametersTile().getFullNode()).getIrrelevantNode().setConverter(Converters.boolConverter((String)Messages.Dont_show_in_list, (String)Messages.Show_in_list));
    }

    private static void updateTilesVisibility(ContractSpace space, ContractSpaceVM model) {
        ContractType contractType;
        if (model != null && (contractType = model.getOverview().getMain().getType()) != null) {
            boolean isNewModel = model.getOverview().getMain().getNewModel();
            switch (contractType) {
                case CLIENT: {
                    space.getHiddenTiles().setAll((Object[])new Tile[]{space.getSubAgencyContractTile(), space.getSupplierContractTile(), space.getSupplierContractDetailsTile(), space.getSupplierContractApplicationsTile(), space.getExtendedSupplierContractTile(), space.getExtendedSupplierContractDetailsTile(), space.getExtendedSupplierContractApplicationsTile(), space.getExtendedSubAgencyContractTile(), space.getExtendedSubAgencyContractDetailsTile()});
                    if (isNewModel) {
                        space.getHiddenTiles().add((Object)space.getClientContractTile());
                        space.getHiddenTiles().add((Object)space.getRulesTile());
                    } else {
                        space.getHiddenTiles().add((Object)space.getExtendedClientContractTile());
                        space.getHiddenTiles().add((Object)space.getExtendedClientContractDetailsTile());
                        space.getHiddenTiles().add((Object)space.getModelContractsTile());
                    }
                    space.getHiddenTiles().addAll(hiddenTilesFromOthersPlugins);
                    return;
                }
                case SUBAGENCY: 
                case TECHNICAL_PROVIDER: {
                    space.getHiddenTiles().setAll((Object[])new Tile[]{space.getClientContractTile(), space.getSupplierContractTile(), space.getSupplierContractDetailsTile(), space.getSupplierContractApplicationsTile(), space.getExtendedSupplierContractTile(), space.getExtendedSupplierContractDetailsTile(), space.getExtendedSupplierContractApplicationsTile(), space.getExtendedClientContractTile(), space.getExtendedClientContractDetailsTile()});
                    if (isNewModel) {
                        space.getHiddenTiles().add((Object)space.getSubAgencyContractTile());
                        space.getHiddenTiles().add((Object)space.getRulesTile());
                    } else {
                        space.getHiddenTiles().add((Object)space.getExtendedSubAgencyContractTile());
                        space.getHiddenTiles().add((Object)space.getExtendedSubAgencyContractDetailsTile());
                        space.getHiddenTiles().add((Object)space.getModelContractsTile());
                    }
                    space.getHiddenTiles().addAll(hiddenTilesFromOthersPlugins);
                    return;
                }
                case VENDOR: {
                    space.getHiddenTiles().setAll((Object[])new Tile[]{space.getClientContractTile(), space.getSubAgencyContractTile(), space.getExtendedSubAgencyContractTile(), space.getExtendedSubAgencyContractDetailsTile(), space.getExtendedClientContractTile(), space.getExtendedClientContractDetailsTile()});
                    if (isNewModel) {
                        space.getHiddenTiles().add((Object)space.getSupplierContractTile());
                        space.getHiddenTiles().add((Object)space.getSupplierContractDetailsTile());
                        space.getHiddenTiles().add((Object)space.getSupplierContractApplicationsTile());
                        space.getHiddenTiles().add((Object)space.getRulesTile());
                    } else {
                        space.getHiddenTiles().add((Object)space.getExtendedSupplierContractTile());
                        space.getHiddenTiles().add((Object)space.getExtendedSupplierContractDetailsTile());
                        space.getHiddenTiles().add((Object)space.getExtendedSupplierContractApplicationsTile());
                        space.getHiddenTiles().add((Object)space.getModelContractsTile());
                    }
                    space.getHiddenTiles().addAll(hiddenTilesFromOthersPlugins);
                    return;
                }
            }
        }
        space.getHiddenTiles().setAll((Object[])new Tile[]{space.getClientContractTile(), space.getSubAgencyContractTile(), space.getSupplierContractTile(), space.getSupplierContractDetailsTile(), space.getSupplierContractApplicationsTile(), space.getRulesTile(), space.getExtendedClientContractTile(), space.getExtendedClientContractDetailsTile(), space.getExtendedSupplierContractTile(), space.getExtendedSupplierContractDetailsTile(), space.getExtendedSupplierContractApplicationsTile(), space.getExtendedSubAgencyContractTile(), space.getExtendedSubAgencyContractDetailsTile(), space.getModelContractsTile()});
        space.getHiddenTiles().addAll(hiddenTilesFromOthersPlugins);
    }

    protected Class<ContractSpaceController> getControllerClass() {
        return ContractSpaceController.class;
    }

    protected void onCreate(ContractSpaceController controller) {
        ContractSpaceControllerInterceptor.setStringConverters(controller);
        ContractSpace space = controller.getView();
        ContractSpaceControllerInterceptor.updateTilesVisibility(space, null);
        ((SupplierContractMainFullPanel)space.getSupplierContractTile().getFullNode()).getAgenciesCard().setAdaptiveHeight(true);
        ((TableWidget)((SupplierContractMainFullPanel)space.getSupplierContractTile().getFullNode()).getAgenciesCard().getContent()).setFiltering(() -> new ContractAgenciesFilterPanel(false), filterPanel -> vm -> {
            String searchValue = filterPanel.getSearchValueNode().getValue();
            LocalDate startDate = (LocalDate)filterPanel.getStartDateNode().valueProperty().get();
            LocalDate endDate = (LocalDate)filterPanel.getEndDateNode().valueProperty().get();
            VendorContractType contractType = (VendorContractType)filterPanel.getVendorContractTypeNode().valueProperty().get();
            return ControllerInterceptorsHelper.matches(searchValue, vm.getOrganization(), vm.getContractNumber()) && ControllerInterceptorsHelper.matches(startDate, endDate, vm.getStartDate(), vm.getEndDate()) && ControllerInterceptorsHelper.matches(contractType, vm.getVendorContractType());
        }, false);
        ((SubagencyContractMainFullPanel)space.getSubAgencyContractTile().getFullNode()).getSubAgenciesCard().setAdaptiveHeight(true);
        ((BigTableWidget)((SubagencyContractMainFullPanel)space.getSubAgencyContractTile().getFullNode()).getSubAgenciesCard().getContent()).setFiltering(() -> new ContractSubAgenciesFilterPanel(false), filterPanel -> vm -> {
            String searchValue = filterPanel.getSearchValueNode().getValue();
            LocalDate startDate = (LocalDate)filterPanel.getStartDateNode().valueProperty().get();
            LocalDate endDate = (LocalDate)filterPanel.getEndDateNode().valueProperty().get();
            return ControllerInterceptorsHelper.matches(searchValue, vm.getSuperColumn().getGeneralDetails().getOrganization(), vm.getSuperColumn().getGeneralDetails().getContractNumber()) && ControllerInterceptorsHelper.matches(startDate, endDate, vm.getSuperColumn().getGeneralDetails().getStartDate(), vm.getSuperColumn().getGeneralDetails().getEndDate());
        }, false);
        ((ClientContractMainFullPanel)space.getClientContractTile().getFullNode()).getClientsCard().setAdaptiveHeight(true);
        BigTableWidget clientsTable = (BigTableWidget)((ClientContractMainFullPanel)space.getClientContractTile().getFullNode()).getClientsCard().getContent();
        clientsTable.setFiltering(() -> new ContractClientsFilterPanel(false), filterPanel -> vm -> {
            String searchValue = filterPanel.getSearchValueNode().getValue();
            LocalDate startDate = (LocalDate)filterPanel.getStartDateNode().valueProperty().get();
            LocalDate endDate = (LocalDate)filterPanel.getEndDateNode().valueProperty().get();
            return ControllerInterceptorsHelper.matches(searchValue, vm.getSuperColumn().getGeneralDetails().getOrganization(), vm.getSuperColumn().getGeneralDetails().getContractNumber()) && ControllerInterceptorsHelper.matches(startDate, endDate, vm.getSuperColumn().getGeneralDetails().getStartDate(), vm.getSuperColumn().getGeneralDetails().getEndDate());
        }, false);
        SuperColumn superColumn = (SuperColumn)clientsTable.getColumn("superColumn");
        superColumn.setPopupCloseHandler((rowIndex, panel) -> {
            if (clientsTable.getViewState().isImmutable()) {
                return;
            }
            ClientContractDetailsFullGeneralPanelBigTable generalPane = (ClientContractDetailsFullGeneralPanelBigTable)panel.getGeneralDetailsCard().getContent();
            clientsTable.setCellValue(rowIndex.intValue(), "organizationText", generalPane.getOrganizationNode().getValue() == null ? null : generalPane.getOrganizationNode().getValue().getCaption());
            clientsTable.setCellValue(rowIndex.intValue(), "contractNumberText", (Object)generalPane.getContractNumberNode().getValue());
            clientsTable.setCellValue(rowIndex.intValue(), "issueDate", (Object)generalPane.getIssueDateNode().getValue());
            clientsTable.setCellValue(rowIndex.intValue(), "issueDate", (Object)generalPane.getIssueDateNode().getValue());
            clientsTable.setCellValue(rowIndex.intValue(), "startDate", (Object)generalPane.getStartDateNode().getValue());
            clientsTable.setCellValue(rowIndex.intValue(), "endDate", (Object)generalPane.getEndDateNode().getValue());
        });
        controller.getView().getSupplierContractApplicationsTile().expandedProperty().addListener(value -> {
            if (!controller.getView().getSupplierContractApplicationsTile().isExpanded()) {
                controller.getView().getSupplierContractApplicationsTile().getActions().clear();
                return;
            }
            controller.getView().getSupplierContractApplicationsTile().getActions().add((Object)SupplierContractApplicationsTileActions.ADD);
        });
        ContractSpaceControllerInterceptor.configureRulesTile((Tile<Node, CustomWidget<RuleSet>>)space.getRulesTile());
        ContractItemsConverterHelper.setSupplierContractConverter(controller);
        ContractPanelsSynchronizationHelper.setSupplierPanelsSynchronization(controller);
        space.getClientContractTile().expandedProperty().addListener((s, o, n) -> {
            if (n.booleanValue()) {
                space.getClientContractTile().getActions().setAll((Object[])ClientsContractMainTileActions.values());
            } else {
                space.getClientContractTile().getActions().clear();
            }
        });
        space.getSubAgencyContractTile().expandedProperty().addListener((s, o, n) -> {
            if (n.booleanValue()) {
                space.getSubAgencyContractTile().getActions().setAll((Object[])SubagencyContractMainTileActions.values());
            } else {
                space.getSubAgencyContractTile().getActions().clear();
            }
        });
        space.getSupplierContractTile().expandedProperty().addListener((s, o, n) -> {
            if (n.booleanValue()) {
                space.getSupplierContractTile().getActions().setAll((Object[])SupplierContractMainTileActions.values());
            } else {
                space.getSupplierContractTile().getActions().clear();
            }
        });
        Contract2ModelContractQueryDataHandler handler = new Contract2ModelContractQueryDataHandler(controller);
        ((DataViewWidget)controller.getModelContractsFull().getView().getAllModelContractsCard().getContent()).setHandler((DataViewHandler)handler);
        ((DataViewWidget)controller.getModelContractsFull().getView().getAllModelContractsCard().getContent()).getTableView().setActionHandler((TableActionHandler)new TableActionHandler<Contract2AllModelContractsPanelVM>(){

            public boolean isActive(TableColumn<Contract2AllModelContractsPanelVM, ?> column, Contract2AllModelContractsPanelVM item) {
                return false;
            }

            public void onAction(TableColumn<Contract2AllModelContractsPanelVM, ?> column, Contract2AllModelContractsPanelVM item) {
                RootEntityEditingService.navigateTo((EntityReference)item.getSource());
            }
        });
        DataViewWidgetHelper.configureSysLogDataView((DataViewWidget<SysLogDataItemVM>)((DataViewWidget)controller.getView().getChangesLogTile().getFullNode()), () -> {
            RootEntityPane rep = RootEntityPane.lookup((Node)controller.getView());
            if (rep == null) {
                return null;
            }
            return rep.getData() == null || rep.getData().getContainer() == null ? null : rep.getData().getContainer().toReference();
        }, (ObservableValue<Boolean>)controller.getView().getChangesLogTile().expandedProperty());
        DataViewWidgetHelper.configureRelatedDocumentsTile((Tile<Node, RelatedDocumentsPanel>)controller.getView().getRelatedDocumentsTile(), () -> {
            RootEntityPane rep = RootEntityPane.lookup((Node)controller.getView());
            if (rep == null) {
                return null;
            }
            return rep.getData() == null || rep.getData().getContainer() == null ? null : rep.getData().getContainer().toReference();
        }, (ObservableValue<Boolean>)controller.getView().getRelatedDocumentsTile().expandedProperty(), new RelatedDocumentsConfiguration().setActionsVisible().setFiltersVisible());
    }

    protected void afterReadData(ContractSpaceController controller, ContractSpaceVM model) {
        ContractSpaceControllerInterceptor.updateTilesVisibility(controller.getView(), model);
        if (model.getOverview().getMain().getType() != null) {
            switch (model.getOverview().getMain().getType()) {
                case CLIENT: 
                case SUBAGENCY: 
                case TECHNICAL_PROVIDER: {
                    break;
                }
                case VENDOR: {
                    this.setVendorUidProperties((TableWidget<ContractDetailsVM>)((TableWidget)controller.getSupplierContractFull().getAgencies().getView()), (List<SupplierContractDetailsFullPanel>)((BaseGroupsWidget)controller.getSupplierContractDetailsFull().getContent().getView()).getViews(), (List<SupplierContractApplicationsNavigateContainer>)((BaseGroupsWidget)controller.getSupplierContractApplicationsFull().getContent().getView()).getViews(), model.getSupplierContractFull().getAgencies());
                }
            }
        }
        ((ContractSpaceOverviewMainPanel)controller.getView().getOverviewNode().getMainCard().getContent()).getNewModelNode().setConverter(Converters.boolConverter((String)Messages.New, (String)Messages.Old));
        this.reloadModelContractsData(controller);
    }

    private void setVendorUidProperties(TableWidget<ContractDetailsVM> table, List<SupplierContractDetailsFullPanel> detailPanels, List<SupplierContractApplicationsNavigateContainer> applicationPanels, List<ContractDetailsVM> customers) {
        for (int i = 0; i < customers.size(); ++i) {
            ((EntityBoxWidget)((EntityBoxWidgetColumn)table.getColumn("organization")).getWidget(i)).getProperties().put((Object)"uid", (Object)customers.get(i).getUid());
            detailPanels.get(i).getProperties().put((Object)"uid", (Object)customers.get(i).getUid());
            applicationPanels.get(i).getProperties().put((Object)"uid", (Object)customers.get(i).getUid());
        }
    }

    private void reloadModelContractsData(ContractSpaceController controller) {
        DataTransferPackage data = Objects.requireNonNull(RootEntityPane.lookup((Node)controller.getView())).getData();
        if (data != null && data.getContainer() != null) {
            ((DataViewWidget)controller.getModelContractsFull().getView().getAllModelContractsCard().getContent()).reloadData();
        }
    }
}

