/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.erasure;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.erasure.ErasureRequestIndividualPanelContainerVM;
import com.gridnine.xtrip.client.fx.model.erasure.ErasureRequestTileSpace;
import com.gridnine.xtrip.client.fx.model.erasure.ErasureRequestTileSpaceController;
import com.gridnine.xtrip.client.fx.model.erasure.ErasureRequestTileSpaceVM;
import com.gridnine.xtrip.client.fx.model.erasure.IndividualEmailVM;
import com.gridnine.xtrip.client.fx.model.erasure.IndividualPassportInfoVM;
import com.gridnine.xtrip.client.fx.model.erasure.IndividualPersonNamesVM;
import com.gridnine.xtrip.client.fx.model.erasure.IndividualPhoneVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.erasure.ErasureRequestControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.erasure.BatchErasureParams;
import com.gridnine.xtrip.common.model.erasure.EmailCriterion;
import com.gridnine.xtrip.common.model.erasure.ErasureParamsType;
import com.gridnine.xtrip.common.model.erasure.ErasureRequest;
import com.gridnine.xtrip.common.model.erasure.ErasureRequestIndex;
import com.gridnine.xtrip.common.model.erasure.ErasureSearchCriterionType;
import com.gridnine.xtrip.common.model.erasure.IndividualErasureParams;
import com.gridnine.xtrip.common.model.erasure.PassportCriterion;
import com.gridnine.xtrip.common.model.erasure.PersonNameCriterion;
import com.gridnine.xtrip.common.model.erasure.PhoneCriterion;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class ErasureRequestHandler
extends BaseRootEntityHandler<ErasureRequest, Void, ErasureRequestTileSpaceVM, ErasureRequestTileSpace> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<ErasureRequest, Void>, ErasureRequestTileSpaceVM>> toVM, List<BiConsumer<ErasureRequestTileSpaceVM, DataTransferPackage<ErasureRequest, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new ErasureRequestControllerInterceptor());
        toVM.add((dtp, vm) -> {
            ErasureRequest model = (ErasureRequest)dtp.getContainer().getEntity();
            vm.setParamsType(model.getParams().getType());
            vm.getOverview().setStatus(model.getStatus());
            vm.getOverview().setNumber(model.getNumber());
            vm.getMainFull().getGeneralParams().setNumber(model.getNumber());
            vm.getMainFull().getGeneralParams().setStatus(model.getStatus());
            if (model.getParams().getType().equals((Object)ErasureParamsType.BATCH)) {
                BatchErasureParams params = (BatchErasureParams)model.getParams();
                vm.getMainFull().getBatch().setOrganization(params.getCompany().getProfile());
            } else if (model.getParams().getType().equals((Object)ErasureParamsType.INDIVIDUAL)) {
                IndividualErasureParams params = (IndividualErasureParams)model.getParams();
                ErasureRequestIndividualPanelContainerVM indPanel = vm.getMainFull().getIndividual();
                List names = params.getCriteria().stream().filter(c -> c.getType() == ErasureSearchCriterionType.PERSON_NAME).map(c -> (PersonNameCriterion)c).collect(Collectors.toList());
                VMHelper.transfer(names, indPanel.getPersonNames(), name -> new IndividualPersonNamesVM(), (name, tableVM) -> {
                    tableVM.setLastName(name.getLastName());
                    tableVM.setFirstName(name.getFirstName());
                    tableVM.setMiddleName(name.getMiddleName());
                });
                List passports = params.getCriteria().stream().filter(c -> c.getType() == ErasureSearchCriterionType.PASSPORT).map(c -> (PassportCriterion)c).collect(Collectors.toList());
                VMHelper.transfer(passports, indPanel.getPassports(), name -> new IndividualPassportInfoVM(), (name, tableVM) -> tableVM.setNumber(name.getNumber()));
                List phones = params.getCriteria().stream().filter(c -> c.getType() == ErasureSearchCriterionType.PHONE).map(c -> (PhoneCriterion)c).collect(Collectors.toList());
                VMHelper.transfer(phones, indPanel.getPhones(), name -> new IndividualPhoneVM(), (name, tableVM) -> tableVM.setNumber(name.getNumber()));
                List emails = params.getCriteria().stream().filter(c -> c.getType() == ErasureSearchCriterionType.EMAIL).map(c -> (EmailCriterion)c).collect(Collectors.toList());
                VMHelper.transfer(emails, indPanel.getEmails(), name -> new IndividualEmailVM(), (name, tableVM) -> tableVM.setAddress(name.getAddress()));
            }
        });
        fromVM.add((vm, dtp) -> {
            ErasureRequest model = (ErasureRequest)dtp.getContainer().getEntity();
            if (model.getParams().getType().equals((Object)ErasureParamsType.BATCH)) {
                BatchErasureParams params = (BatchErasureParams)model.getParams();
                vm.getMainFull().getBatch().setOrganization(params.getCompany().getProfile());
            } else if (model.getParams().getType().equals((Object)ErasureParamsType.INDIVIDUAL)) {
                IndividualErasureParams params = (IndividualErasureParams)model.getParams();
                ErasureRequestIndividualPanelContainerVM indPanel = vm.getMainFull().getIndividual();
                VMHelper.transfer(indPanel.getPersonNames(), params.getCriteria(), tableVM -> new PersonNameCriterion(), (tableVM, criterion) -> {
                    PersonNameCriterion name = (PersonNameCriterion)criterion;
                    name.setLastName(tableVM.getLastName());
                    name.setFirstName(tableVM.getFirstName());
                    name.setMiddleName(tableVM.getMiddleName());
                });
                VMHelper.transfer(indPanel.getPassports(), params.getCriteria(), tableVM -> new PassportCriterion(), (tableVM, criterion) -> {
                    PassportCriterion passport = (PassportCriterion)criterion;
                    passport.setNumber(tableVM.getNumber());
                });
                VMHelper.transfer(indPanel.getPhones(), params.getCriteria(), tableVM -> new PhoneCriterion(), (tableVM, criterion) -> {
                    PhoneCriterion phone = (PhoneCriterion)criterion;
                    phone.setNumber(tableVM.getNumber());
                });
                VMHelper.transfer(indPanel.getEmails(), params.getCriteria(), tableVM -> new EmailCriterion(), (tableVM, criterion) -> {
                    EmailCriterion email = (EmailCriterion)criterion;
                    email.setAddress(tableVM.getAddress());
                });
            }
        });
    }

    @Override
    protected ViewController<ErasureRequestTileSpace, ErasureRequestTileSpaceVM> createSpaceController(boolean readonly) {
        return new ErasureRequestTileSpaceController(readonly);
    }

    @Override
    protected ErasureRequestTileSpaceVM createVM() {
        return new ErasureRequestTileSpaceVM();
    }

    public Class<ErasureRequest> getEntityClass() {
        return ErasureRequest.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return ErasureRequestIndex.class;
    }
}

