/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportSettingsGeneral;
import com.gridnine.xtrip.client.fx.model.exportSettings.FinanceDocumentXmlExportSettingsContainer;
import com.gridnine.xtrip.client.fx.model.exportSettings.FinanceDocumentXmlExportSettingsContainerController;
import com.gridnine.xtrip.client.fx.model.exportSettings.FinanceDocumentXmlExportSettingsContainerVM;
import com.gridnine.xtrip.client.fx.model.exportSettings.FinanceDocumentXmlExportSettingsGeneral;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings.ExportSettingsEditorHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings.ExportSettingsHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings.ExportSettingsListCreater;
import com.gridnine.xtrip.client.fx.standard.settings.model.FileConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.FtpConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.HttpConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.SftpConnectionSettingsModel;
import com.gridnine.xtrip.common.fx.model.export.TreeDataWrapper;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.export.ConnectionType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

class FinanceDocumentXmlExportSettingsControllerInterceptor
extends ControllerInterceptor<FinanceDocumentXmlExportSettingsContainerVM, FinanceDocumentXmlExportSettingsContainerController> {
    private static final String rootEntityId = "com.gridnine.xtrip.common.model.export.finance.v2.FinanceDocumentExport";

    FinanceDocumentXmlExportSettingsControllerInterceptor() {
    }

    private static void hideConnectionCards(FinanceDocumentXmlExportSettingsContainer view) {
        view.getCards().forEach(card -> card.setHidden(true));
        view.getCommonCard().setHidden(false);
        view.getSpecifiedCard().setHidden(false);
    }

    protected Class<FinanceDocumentXmlExportSettingsContainerController> getControllerClass() {
        return FinanceDocumentXmlExportSettingsContainerController.class;
    }

    protected void onCreate(FinanceDocumentXmlExportSettingsContainerController controller) {
        FinanceDocumentXmlExportSettingsContainer view = controller.getView();
        FinanceDocumentXmlExportSettingsControllerInterceptor.hideConnectionCards(view);
        ComboBoxWidget connectionTypeNode = ((ExportSettingsGeneral)controller.getView().getCommonCard().getContent()).getConnectionTypeNode();
        connectionTypeNode.setNoNulls(true);
        connectionTypeNode.valueProperty().addListener((obj, o, newConnectionType) -> {
            FinanceDocumentXmlExportSettingsControllerInterceptor.hideConnectionCards(view);
            if (newConnectionType != null) {
                switch (newConnectionType) {
                    case FTP: {
                        view.getFtpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case SFTP: {
                        view.getSftpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case HTTP: {
                        view.getHttpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case FILE: {
                        view.getFileConnectionSettingsCard().setHidden(false);
                    }
                }
            }
        });
        ((FileConnectionSettingsModel)view.getFileConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.FILE));
        ((FtpConnectionSettingsModel)view.getFtpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.FTP));
        ((SftpConnectionSettingsModel)view.getSftpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.SFTP));
        ((HttpConnectionSettingsModel)view.getHttpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.HTTP));
        List<FinanceDocumentType> financeDocumentTypes = Arrays.asList(FinanceDocumentType.STANDARD_BILL, FinanceDocumentType.INVOICE, FinanceDocumentType.INVOICE_CONSOLIDATED, FinanceDocumentType.INVOICE_PREPAYMENT, FinanceDocumentType.CORRECTION_DOCUMENT, FinanceDocumentType.INVOICE_FACTURA, FinanceDocumentType.ACCEPTANCE_CERTIFICATE, FinanceDocumentType.UNIVERSAL_DOCUMENT);
        ((FinanceDocumentXmlExportSettingsGeneral)view.getSpecifiedCard().getContent()).getFinanceDocumentTypeNode().setItemsSupplier(Suppliers.createEnumSupplier(FinanceDocumentType.class, financeDocumentTypes::contains));
    }

    protected void afterReadData(final FinanceDocumentXmlExportSettingsContainerController controller, final FinanceDocumentXmlExportSettingsContainerVM model) {
        Consumer<TreeDataWrapper> cons = new Consumer<TreeDataWrapper>(){

            @Override
            public void accept(TreeDataWrapper wrapper) {
                ExportSettingsHelper.toTreeDataWrapper(wrapper, model.getSpecified().getRootExportSettings().getSettings());
                ((FinanceDocumentXmlExportSettingsGeneral)controller.getView().getSpecifiedCard().getContent()).getRootExportSettingsNode().readData((Object)wrapper);
            }
        };
        ExportSettingsListCreater.getTreeData(rootEntityId, cons);
    }
}

