/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings;

import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportSettingsGeneral;
import com.gridnine.xtrip.client.fx.model.exportSettings.RelatedDocumentsExportSettingsContainer;
import com.gridnine.xtrip.client.fx.model.exportSettings.RelatedDocumentsExportSettingsContainerController;
import com.gridnine.xtrip.client.fx.model.exportSettings.RelatedDocumentsExportSettingsContainerVM;
import com.gridnine.xtrip.client.fx.model.exportSettings.RelatedDocumentsExportSettingsGeneral;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings.ExportSettingsEditorHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.model.FileConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.FtpConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.HttpConnectionSettingsModel;
import com.gridnine.xtrip.client.fx.standard.settings.model.SftpConnectionSettingsModel;
import com.gridnine.xtrip.common.model.export.ConnectionType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import java.util.Arrays;
import java.util.List;

class RelatedDocumentsExportSettingsControllerInterceptor
extends ControllerInterceptor<RelatedDocumentsExportSettingsContainerVM, RelatedDocumentsExportSettingsContainerController> {
    RelatedDocumentsExportSettingsControllerInterceptor() {
    }

    private static void hideConnectionCards(RelatedDocumentsExportSettingsContainer view) {
        view.getCards().forEach(card -> card.setHidden(true));
        view.getCommonCard().setHidden(false);
        view.getSpecifiedCard().setHidden(false);
    }

    protected Class<RelatedDocumentsExportSettingsContainerController> getControllerClass() {
        return RelatedDocumentsExportSettingsContainerController.class;
    }

    protected void onCreate(RelatedDocumentsExportSettingsContainerController controller) {
        RelatedDocumentsExportSettingsContainer view = controller.getView();
        RelatedDocumentsExportSettingsControllerInterceptor.hideConnectionCards(view);
        ComboBoxWidget connectionTypeNode = ((ExportSettingsGeneral)controller.getView().getCommonCard().getContent()).getConnectionTypeNode();
        connectionTypeNode.setNoNulls(true);
        connectionTypeNode.valueProperty().addListener((obj, o, newConnectionType) -> {
            RelatedDocumentsExportSettingsControllerInterceptor.hideConnectionCards(view);
            if (newConnectionType != null) {
                switch (newConnectionType) {
                    case FTP: {
                        view.getFtpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case SFTP: {
                        view.getSftpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case HTTP: {
                        view.getHttpConnectionSettingsCard().setHidden(false);
                        break;
                    }
                    case FILE: {
                        view.getFileConnectionSettingsCard().setHidden(false);
                    }
                }
            }
        });
        ((FileConnectionSettingsModel)view.getFileConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.FILE));
        ((FtpConnectionSettingsModel)view.getFtpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.FTP));
        ((SftpConnectionSettingsModel)view.getSftpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.SFTP));
        ((HttpConnectionSettingsModel)view.getHttpConnectionSettingsCard().getContent()).getReferenceNode().setListParametersSupplier(() -> ExportSettingsEditorHelper.filterConnectionsList(ConnectionType.HTTP));
        Notifications.get().submitTask(() -> FxUtil.submitToFxThread(() -> {
            List<DocumentType> documentTypes = Arrays.asList(DocumentType.RECEIPT, DocumentType.VOUCHER);
            controller.getSpecified().getView().getDocumentTypeNode().setItemsSupplier(Suppliers.createEnumSupplier(DocumentType.class, documentTypes::contains));
        }), Messages.RelatedDocumentsExportSettingsHandler_loadDocumentTypes);
        ((RelatedDocumentsExportSettingsGeneral)view.getSpecifiedCard().getContent()).getClientsNode().setListParametersSupplier(ControllerInterceptorsHelper::getClients);
        ((RelatedDocumentsExportSettingsGeneral)view.getSpecifiedCard().getContent()).getSubagencyNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        ((RelatedDocumentsExportSettingsGeneral)view.getSpecifiedCard().getContent()).getSuppliersNode().setListParametersSupplier(ControllerInterceptorsHelper::getSuppliers);
        ((FileConnectionSettingsModel)view.getFileConnectionSettingsCard().getContent()).getReferenceCell().setHelp(() -> new QuickHelp(Messages.RelatedDocumentsExportSettingsReferenceHelp));
        ((FtpConnectionSettingsModel)view.getFtpConnectionSettingsCard().getContent()).getReferenceCell().setHelp(() -> new QuickHelp(Messages.RelatedDocumentsExportSettingsReferenceHelp));
        ((SftpConnectionSettingsModel)view.getSftpConnectionSettingsCard().getContent()).getReferenceCell().setHelp(() -> new QuickHelp(Messages.RelatedDocumentsExportSettingsReferenceHelp));
        ((HttpConnectionSettingsModel)view.getHttpConnectionSettingsCard().getContent()).getReferenceCell().setHelp(() -> new QuickHelp(Messages.RelatedDocumentsExportSettingsReferenceHelp));
    }
}

