/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentDocumentsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentRelatedDocumentsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentTransactionsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.CreditBankTransferOrderCardController;
import com.gridnine.xtrip.client.fx.model.profile.CreditBankTransferOrderCardVM;
import com.gridnine.xtrip.client.fx.model.profile.CreditBankTransferOrderMainCard;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.DataViewWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.NestedEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class CreditBankTransferOrderContollerInterceptor
extends ControllerInterceptor<CreditBankTransferOrderCardVM, CreditBankTransferOrderCardController> {
    protected Class<CreditBankTransferOrderCardController> getControllerClass() {
        return CreditBankTransferOrderCardController.class;
    }

    protected void onCreate(CreditBankTransferOrderCardController controller) {
        ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getOrganizationNode().setListParametersSupplier(ControllerInterceptorsHelper.getAgenciesAndBlankOwnersAndClient());
        ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getPayerNode().setListParametersSupplier(ControllerInterceptorsHelper.getAgenciesAndBlankOwnersAndClientAndPassenger());
        ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getEndOfDecadeCell().setHidden(true);
        ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getPaymentTypeCell().setHidden(true);
        ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getPayerNode().valueProperty().addListener((obj, oldValue, newValue) -> {
            if (newValue == null || !Organization.class.isAssignableFrom(newValue.getType())) {
                return;
            }
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            Notifications.get().submitTask(() -> {
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer ctr = entityService.load(sic, newValue);
                FxUtil.waitForFxThread(() -> {
                    if (ctr != null) {
                        Organization organization = (Organization)ctr.getEntity();
                        boolean blankOwner = false;
                        if (organization != null) {
                            blankOwner = organization.getTypes().contains(OrganizationType.BLANK_OWNER);
                        }
                        ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getEndOfDecadeCell().setHidden(!blankOwner);
                        ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getPaymentTypeCell().setHidden(!blankOwner);
                    }
                });
            }, Messages.Receiving_data);
        });
        this.configureCreditBankTransferOrder(controller);
        this.configureContract(controller);
    }

    protected void afterReadData(CreditBankTransferOrderCardController controller, CreditBankTransferOrderCardVM model) {
        ((DataViewWidget)controller.getView().getTransactionsCard().getContent()).reloadData();
    }

    private void configureCreditBankTransferOrder(CreditBankTransferOrderCardController controller) {
        Supplier<EntityContainer<? extends BasePaymentDocument>> containerSupplier = () -> {
            RootEntityPane rep = RootEntityPane.lookup((Node)controller.getView());
            if (rep == null) {
                return null;
            }
            return rep.getData() == null || rep.getData().getContainer() == null ? null : rep.getData().getContainer();
        };
        DataViewWidgetHelper.configurePaymentRelatedDocumentsView((DataViewWidget<BasePaymentDocumentRelatedDocumentsViewVM>)((DataViewWidget)controller.getView().getRelatedDocumentsCard().getContent()), containerSupplier, (ObservableValue<Boolean>)controller.getView().getRelatedDocumentsCard().collapsedProperty());
        DataViewWidgetHelper.configureTransactionsDataViewForBankTransferOrder((DataViewWidget<BasePaymentDocumentTransactionsViewVM>)((DataViewWidget)controller.getView().getTransactionsCard().getContent()), containerSupplier, (ObservableValue<Boolean>)controller.getView().getTransactionsCard().collapsedProperty());
        DataViewWidgetHelper.configurePaymentDocumentsDataView((DataViewWidget<BasePaymentDocumentDocumentsViewVM>)((DataViewWidget)controller.getView().getDocumentsCard().getContent()), containerSupplier, (ObservableValue<Boolean>)controller.getView().getDocumentsCard().collapsedProperty());
    }

    private void configureContract(CreditBankTransferOrderCardController controller) {
        NestedEntityBoxWidget contractNode = ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getContractNode();
        Supplier<IndexListParameters> supplier = () -> {
            EntityReference organization = ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getOrganizationNode().getValue();
            EntityReference baseProfileRef = ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getPayerNode().getValue();
            EntityReference payer = baseProfileRef != null && Organization.class.isAssignableFrom(baseProfileRef.getType()) ? baseProfileRef : null;
            return ControllerInterceptorsHelper.getContracts((EntityReference<Organization>)organization, payer);
        };
        contractNode.setListParametersSupplier(supplier);
        contractNode.setNestedReferenceBuilder(idx -> new NestedEntityReference(idx.getSource(), idx.getNavigationKey(), ContractCustomerInfo.class, (((ContractCustomerIndex)idx).getCustomer() != null ? ((ContractCustomerIndex)idx).getCustomer() + " " : "") + "(" + (((ContractCustomerIndex)idx).getName() != null ? ((ContractCustomerIndex)idx).getName() : "") + ")"));
        contractNode.setValueSelectionListener(val -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            Notifications.get().submitTask(() -> {
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer ctr = entityService.load(sic, val.getSource());
                if (ctr != null) {
                    FxUtil.waitForFxThread(() -> {
                        NestedEntityReference ref;
                        NestedEntity contractCustomerInfo;
                        Contract contract = (Contract)ctr.getEntity();
                        ContractType contractType = contract.getContractType();
                        if (contractType != null && (contractCustomerInfo = entityService.resolve(sic, ref = (NestedEntityReference)contractNode.getValue())) != null) {
                            if (contractType == ContractType.VENDOR) {
                                ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getOrganizationNode().setValue(((ContractCustomerInfo)contractCustomerInfo.getEtt()).getCustomer());
                                ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getPayerNode().setValue(contract.getSupplier());
                            } else {
                                ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getOrganizationNode().setValue(contract.getSupplier());
                                ((CreditBankTransferOrderMainCard)controller.getView().getMainCardCard().getContent()).getPayerNode().setValue(((ContractCustomerInfo)contractCustomerInfo.getEtt()).getCustomer());
                            }
                        }
                    });
                }
            }, Messages.Receiving_data);
        });
    }
}

