/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentDocumentsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentRelatedDocumentsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentTransactionsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.DebitSlipCardController;
import com.gridnine.xtrip.client.fx.model.profile.DebitSlipCardVM;
import com.gridnine.xtrip.client.fx.model.profile.DebitSlipMainCard;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.DataViewWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.helpers.PersonalNameFormat;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class DebitSlipControllerInterceptor
extends ControllerInterceptor<DebitSlipCardVM, DebitSlipCardController> {
    protected Class<DebitSlipCardController> getControllerClass() {
        return DebitSlipCardController.class;
    }

    protected void onCreate(DebitSlipCardController controller) {
        ((DebitSlipMainCard)controller.getView().getMainCardCard().getContent()).getOrganizationNode().setListParametersSupplier(ControllerInterceptorsHelper.getAgenciesAndBlankOwnersAndClient());
        ((DebitSlipMainCard)controller.getView().getMainCardCard().getContent()).getCashierNode().setListParametersSupplier(ControllerInterceptorsHelper::getCashierAccountant);
        ((DebitSlipMainCard)controller.getView().getMainCardCard().getContent()).getPersonNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgents);
        this.configureDebitSlip(controller);
        this.configurePersonInfo(controller);
    }

    protected void afterReadData(DebitSlipCardController controller, DebitSlipCardVM model) {
        ((DataViewWidget)controller.getView().getTransactionsCard().getContent()).reloadData();
    }

    private void configureDebitSlip(DebitSlipCardController controller) {
        Supplier<EntityContainer<? extends BasePaymentDocument>> containerSupplier = () -> {
            RootEntityPane rep = RootEntityPane.lookup((Node)controller.getView());
            if (rep == null) {
                return null;
            }
            return rep.getData() == null || rep.getData().getContainer() == null ? null : rep.getData().getContainer();
        };
        DataViewWidgetHelper.configurePaymentRelatedDocumentsView((DataViewWidget<BasePaymentDocumentRelatedDocumentsViewVM>)((DataViewWidget)controller.getView().getRelatedDocumentsCard().getContent()), containerSupplier, (ObservableValue<Boolean>)controller.getView().getRelatedDocumentsCard().collapsedProperty());
        DataViewWidgetHelper.configureTransactionsDataViewForSlip((DataViewWidget<BasePaymentDocumentTransactionsViewVM>)((DataViewWidget)controller.getView().getTransactionsCard().getContent()), containerSupplier, (ObservableValue<Boolean>)controller.getView().getTransactionsCard().collapsedProperty());
        DataViewWidgetHelper.configurePaymentDocumentsDataView((DataViewWidget<BasePaymentDocumentDocumentsViewVM>)((DataViewWidget)controller.getView().getDocumentsCard().getContent()), containerSupplier, (ObservableValue<Boolean>)controller.getView().getDocumentsCard().collapsedProperty());
    }

    private void configurePersonInfo(DebitSlipCardController controller) {
        EntityBoxWidget personNode = ((DebitSlipMainCard)controller.getView().getMainCardCard().getContent()).getPersonNode();
        TextFieldWidget personNameNode = ((DebitSlipMainCard)controller.getView().getMainCardCard().getContent()).getPersonNameNode();
        personNode.setValueSelectionListener(ref -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            Notifications.get().submitTask(() -> {
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer ctr = entityService.load(sic, ref.getSource());
                if (ctr != null) {
                    FxUtil.waitForFxThread(() -> {
                        Person person = (Person)ctr.getEntity();
                        boolean personNameEmpty = TextUtil.isBlank((String)personNameNode.getValue());
                        if (personNameEmpty) {
                            Locale locale = ClientSettings.get().getDataLocale() != null ? ClientSettings.get().getDataLocale() : ClientSettings.get().getUiLocale();
                            PersonalLocalizableNameFormatter format = new PersonalLocalizableNameFormatter("L F M");
                            String personName = format.format((PersonalLocalizableName)person, locale, false);
                            personNameNode.setValue(personName);
                        }
                        for (PassportType type : Arrays.asList(PassportType.INTERNAL, PassportType.FOREIGN)) {
                            Passport passport = person.getPassports().stream().filter(item -> item != null && item.getType() == type).findFirst().orElse(null);
                            if (passport == null) continue;
                            if (!personNameEmpty || type != PassportType.INTERNAL) break;
                            PersonalNameFormat format = new PersonalNameFormat("L F M");
                            String personName = format.format((PersonalName)passport);
                            personNameNode.setValue(personName);
                            break;
                        }
                    });
                }
            }, Messages.Receiving_data);
        });
    }
}

