/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.finance.ShipmentHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.finance.ShipmentSpaceControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.finance.controllerinterceptors.ShipmentEditorInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.model.CommentsGridVM;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentItemsBillingItemsVM;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentItemsFinanceDocumentsVM;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentItemsPaymentItemsVM;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentItemsPrepaymentFinanceDocumentsVM;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentItemsVendorFinanceDocumentsVM;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentMainGridVM;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentSpaceVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentUIData;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class StandardShipmentHandlerConfigurator
implements ShipmentHandlerConfigurator {
    @Override
    public void configureController(List<BiConsumer<DataTransferPackage<Shipment, ShipmentUIData>, ShipmentSpaceVM>> toVM, List<BiConsumer<ShipmentSpaceVM, DataTransferPackage<Shipment, ShipmentUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new ShipmentSpaceControllerInterceptor());
        toVM.add((dtp, vm) -> {
            Shipment model = (Shipment)dtp.getContainer().getEntity();
            ShipmentUIData supplement = (ShipmentUIData)dtp.getSupplement();
            ShipmentMainGridVM mainCard = vm.getOverview().getMain();
            mainCard.setCustomer(model.getCustomer());
            mainCard.setDate(DateUtils.asLocalDateTime((Date)model.getDate()));
            mainCard.setAmountChecked(model.isAmountChecked());
            mainCard.setNumber(model.getNumber());
            mainCard.setPayer(model.getPayer());
            mainCard.setSupplier(model.getSupplier());
            mainCard.setAgent(model.getAgent());
            mainCard.setCategoryAgent(model.getCategoryAgent());
            mainCard.setPeriodBegin(DateUtils.asLocalDate((Date)model.getPeriodBegin()));
            mainCard.setPeriodEnd(DateUtils.asLocalDate((Date)model.getPeriodEnd()));
            mainCard.setContract((EntityReference)model.getContract());
            mainCard.setCorrection(model.isCorrection());
            mainCard.getCorrectingShipments().clear();
            mainCard.getCorrectingShipments().addAll(model.getCorrectionShipments());
            mainCard.setOriginalShipment(model.getOriginalShipment());
            mainCard.setSentToEmail(model.isSentToEmail());
            if (supplement != null) {
                VMHelper.transfer(supplement.getBillingItems(), vm.getOverview().getBillingItems(), bi -> new ShipmentItemsBillingItemsVM(), (bi, biVM) -> {
                    biVM.setName(bi.getName());
                    biVM.setPaymentType(bi.getPaymentType());
                    if (bi.getAmount() != null) {
                        biVM.setAmount(bi.getAmount().getTotal());
                        biVM.setVat(bi.getAmount().getVatAmount());
                    }
                    biVM.setProduct(bi.getProduct() != null ? bi.getProduct() : null);
                    biVM.setTraveller(bi.getTraveller() != null ? bi.getTraveller() : null);
                    BigDecimal totalAmount = mainCard.getTotalAmount();
                    totalAmount = totalAmount == null ? bi.getAmount().getTotal() : MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalAmount, bi.getAmount().getTotal()});
                    mainCard.setTotalAmount(totalAmount);
                });
            }
            if (supplement != null && supplement.getPaymentItems() != null) {
                VMHelper.transfer(supplement.getPaymentItems().getData(), vm.getOverview().getPaymentItems(), bi -> new ShipmentItemsPaymentItemsVM(), (pi, piVM) -> {
                    piVM.setType(pi.getPaymentType());
                    if (pi.getAmount() != null) {
                        piVM.setAmount(pi.getAmount().getValue());
                        piVM.setCurrency(pi.getAmount().getCurrency());
                        piVM.setPaymentDocument((EntityReference)supplement.getPaymentItemPaymentDocumentMap().get(pi));
                        Money paymentsTotalAmount = mainCard.getPaymentsTotalAmount();
                        if (paymentsTotalAmount == null) {
                            paymentsTotalAmount = new Money();
                            paymentsTotalAmount.setValue(pi.getAmount().getValue());
                            paymentsTotalAmount.setCurrency(pi.getAmount().getCurrency());
                        } else {
                            paymentsTotalAmount.setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{paymentsTotalAmount.getValue(), pi.getAmount().getValue()}));
                        }
                        mainCard.setPaymentsTotalAmount(paymentsTotalAmount);
                    }
                });
            }
            if (supplement != null) {
                VMHelper.transfer(supplement.getFinanceDocuments(), vm.getOverview().getFinanceDocuments(), rs -> new ShipmentItemsFinanceDocumentsVM(), (finDoc, finDocVM) -> {
                    finDocVM.setFinanceDocument(finDoc.getFinanceDocumentReference());
                    finDocVM.setDelivery(finDoc.getDeliveryReference());
                    finDocVM.setNumber(finDoc.getNumber());
                    finDocVM.setDate(DateUtils.asLocalDate((Date)finDoc.getDate()));
                    finDocVM.setType(finDoc.getType());
                });
                VMHelper.transfer(supplement.getVendorFinanceDocuments(), vm.getOverview().getVendorFinanceDocuments(), rs -> new ShipmentItemsVendorFinanceDocumentsVM(), (finDoc, finDocVM) -> {
                    finDocVM.setOpenFinanceDocumentAction(Messages.View_Document);
                    finDocVM.setDelivery(finDoc.getDeliveryReference());
                    finDocVM.setNumber(finDoc.getNumber());
                    finDocVM.setDate(DateUtils.asLocalDate((Date)finDoc.getDate()));
                    finDocVM.setType(TextUtil.objToNotNullString((Object)finDoc.getType()));
                    finDocVM.setFinanceDocumentReference((Object)finDoc.getFinanceDocumentReference());
                });
                VMHelper.transfer(supplement.getPrepaymentFinanceDocuments(), vm.getOverview().getPrepaymentFinanceDocuments(), rs -> new ShipmentItemsPrepaymentFinanceDocumentsVM(), (finDoc, finDocVM) -> {
                    finDocVM.setFinanceDocument(finDoc.getFinanceDocumentReference());
                    finDocVM.setNumber(finDoc.getNumber());
                    finDocVM.setDate(DateUtils.asLocalDate((Date)finDoc.getDate()));
                    finDocVM.setType(finDoc.getType());
                    finDocVM.setAmount(finDoc.getAmount());
                });
            }
            CommentsGridVM commentsCard = vm.getCommentsFull();
            commentsCard.setComments(model.getComments());
        });
        fromVM.add((vm, dtp) -> {
            Shipment model = (Shipment)dtp.getContainer().getEntity();
            ShipmentMainGridVM mainCard = vm.getOverview().getMain();
            model.setCustomer(mainCard.getCustomer());
            model.setDate(DateUtils.asDate((LocalDateTime)mainCard.getDate()));
            model.setAmountChecked(mainCard.isAmountChecked());
            model.setNumber(mainCard.getNumber());
            model.setPayer(mainCard.getPayer());
            model.setSupplier(mainCard.getSupplier());
            model.setAgent(mainCard.getAgent());
            model.setPeriodBegin(DateUtils.asDate((LocalDate)mainCard.getPeriodBegin()));
            model.setPeriodEnd(DateUtils.asDate((LocalDate)mainCard.getPeriodEnd()));
            if (mainCard.getContract() != null) {
                model.setContract(new NestedEntityReference(mainCard.getContract(), "fake", ContractCustomerInfo.class, null));
            }
            model.setCorrection(mainCard.isCorrection());
            model.getCorrectionShipments().clear();
            model.getCorrectionShipments().addAll(mainCard.getCorrectingShipments());
            model.setOriginalShipment(mainCard.getOriginalShipment());
            model.setSentToEmail(mainCard.isSentToEmail());
            ShipmentUIData supplement = (ShipmentUIData)dtp.getSupplement();
            if (supplement != null && supplement.getBillingItems() != null) {
                VMHelper.transfer(vm.getOverview().getBillingItems(), supplement.getBillingItems(), bi -> new BillingItem(), (biVM, bi) -> bi.setName(biVM.getName()));
            }
            CommentsGridVM commentsCard = vm.getCommentsFull();
            model.setComments(commentsCard.getComments());
        });
    }

    @Override
    public void collectEditorInterceptors(List<RootEntityEditorInterceptor<Shipment, ShipmentUIData>> editorInterceptors) {
        editorInterceptors.add(new ShipmentEditorInterceptor());
    }
}

