/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractSpace;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractInContractsDataInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractMainPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractMainPanelHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractOtherParametersTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractSpaceControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.StandardModelContractHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.rules.RuleSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class ModelContractHandler
extends BaseRootEntityHandler<ModelContract, Void, ModelContractSpaceVM, ModelContractSpace> {
    private List<RootEntityEditorInterceptor<ModelContract, Void>> editorInterceptors;

    public ModelContractHandler() {
        ControllersRegistry.register((ControllerInterceptor)new ModelContractSpaceControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new ModelContractInContractsDataInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new ModelContractMainPanelControllerInterceptor());
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<ModelContract, Void>, ModelContractSpaceVM>> toVM, List<BiConsumer<ModelContractSpaceVM, DataTransferPackage<ModelContract, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            ModelContract model = (ModelContract)dtp.getContainer().getEntity();
            vm.getOverview().setName(model.getName());
            ModelContractMainPanelHelper.toVM(model, vm.getContractFull());
            ModelContractOtherParametersTileHelper.toVM(model, vm.getOtherParametersFull());
            VMHelper.copy(model.getRuleSet(), vm.getRulesFull());
        });
        fromVM.add((vm, dtp) -> {
            ModelContract model = (ModelContract)dtp.getContainer().getEntity();
            ModelContractMainPanelHelper.fromVM(vm.getContractFull(), model);
            ModelContractOtherParametersTileHelper.fromVM(vm.getOtherParametersFull(), model);
            if (model.getRuleSet() == null) {
                model.setRuleSet(new RuleSet());
            }
            VMHelper.copy(vm.getRulesFull(), model.getRuleSet());
        });
        StandardModelContractHandlerConfigurator configurator = new StandardModelContractHandlerConfigurator();
        configurator.configureController(toVM, fromVM);
        ClientRegistry.get().allOf(ModelContractHandlerConfigurator.TYPE).values().forEach(cfg -> cfg.configureController(toVM, fromVM));
    }

    public Class<ModelContract> getEntityClass() {
        return ModelContract.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return ModelContractIndex.class;
    }

    @Override
    protected ViewController<ModelContractSpace, ModelContractSpaceVM> createSpaceController(boolean readonly) {
        return new ModelContractSpaceController(readonly);
    }

    @Override
    protected ModelContractSpaceVM createVM() {
        return new ModelContractSpaceVM();
    }

    public List<RootEntityEditorInterceptor<ModelContract, Void>> getEditorInterceptors() {
        if (this.editorInterceptors == null) {
            this.editorInterceptors = new ArrayList<RootEntityEditorInterceptor<ModelContract, Void>>();
            new StandardModelContractHandlerConfigurator().collectEditorInterceptors(this.editorInterceptors);
            ClientRegistry.get().allOf(ModelContractHandlerConfigurator.TYPE).values().forEach(cfg -> cfg.collectEditorInterceptors(this.editorInterceptors));
        }
        return this.editorInterceptors;
    }
}

