/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.FilterableDataViewHandler;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractInContractsDataVM;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractInContractsFilterContainer;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractSpaceController;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Contract2ModelContract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContract2Organization;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.Pair;
import org.apache.commons.lang.StringUtils;

public class ModelContractInContractsFilterableDataHandler
extends FilterableDataViewHandler<ModelContractInContractsDataVM, ModelContractInContractsFilterContainer> {
    private static final int DEFAULT_LIMIT = 18;
    private int offset;
    private ModelContractSpaceController controller;

    ModelContractInContractsFilterableDataHandler(ModelContractSpaceController controller) {
        super(() -> new ModelContractInContractsFilterContainer(false), false);
        this.controller = controller;
    }

    protected int getLimit() {
        return 18;
    }

    protected int getOffset() {
        return this.offset;
    }

    protected void reloadData(int newOffset, List<Pair<String, SortOrder>> sorting) {
        Notifications.get().submitTask(() -> {
            EntityContainer modelContractCtr;
            DataTransferPackage dtp;
            FilteringPane filteringPane = this.getFilteringPane();
            String nameFilter = ((ModelContractInContractsFilterContainer)filteringPane.getContent()).getNameNode().getValue();
            FilterProperty property = new FilterProperty(newOffset, 18, nameFilter);
            ArrayList<ModelContractInContractsDataVM> result = new ArrayList<ModelContractInContractsDataVM>();
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            RootEntityPane rootEntityPane = RootEntityPane.lookup((Node)this.controller.getView());
            if (rootEntityPane != null && (dtp = rootEntityPane.getData()) != null && (modelContractCtr = dtp.getContainer()) != null) {
                List<String> contractWithThisModelContractUids = this.searchContractsDirectBinding((EntityReference<ModelContract>)modelContractCtr.toReference(), entityService);
                List<ContractIndex> indirectBindingContractIndices = this.searchContracts((EntityContainer<ModelContract>)modelContractCtr, entityService, property);
                for (ContractIndex index : indirectBindingContractIndices) {
                    ModelContract modelContract;
                    ModelContractInContractsDataVM view;
                    boolean isDirectBinding = contractWithThisModelContractUids.contains(index.getUid());
                    if (isDirectBinding) {
                        EntityReference modelContractRef = modelContractCtr.toReference();
                        EntityContainer contractCtr = entityService.load(ServiceInvocationContext.get(), index.getSource());
                        if (contractCtr != null) {
                            for (Contract2ModelContract c2mc : ((Contract)contractCtr.getEntity()).getModelContracts()) {
                                if (!modelContractRef.equals((Object)c2mc.getModelContract())) continue;
                                view = this.createModelContractVM(index, true);
                                Date endDate = c2mc.getEndDate();
                                Date startDate = c2mc.getStartDate();
                                view.setStartDateText((String)StandardRenderers.DATE.apply((Object)startDate));
                                view.setStartDate(startDate);
                                view.setEndDateText((String)StandardRenderers.DATE.apply((Object)endDate));
                                view.setEndDate(endDate);
                                view.setTranslateSupplierFeesText((String)StandardRenderers.BOOLEAN.apply((Object)c2mc.isTranslateSupplierFees()));
                                view.setTranslateSupplierFees(Boolean.valueOf(c2mc.isTranslateSupplierFees()));
                                result.add(view);
                            }
                        }
                    }
                    if ((modelContract = (ModelContract)modelContractCtr.getEntity()).getContractType() != null && modelContract.getContractType().equals((Object)index.getContractType())) {
                        ModelContractInContractsDataVM view2 = this.createModelContractVM(index, false);
                        result.add(view2);
                    }
                    for (ModelContract2Organization mc2o : modelContract.getSuppliers()) {
                        EntityReference supplier = mc2o.getOrganization();
                        if (supplier == null || !supplier.equals((Object)index.getSupplier())) continue;
                        view = this.createModelContractVM(index, false);
                        view.setStartDateText((String)StandardRenderers.DATE.apply((Object)mc2o.getStartDate()));
                        view.setStartDate(mc2o.getStartDate());
                        view.setEndDateText((String)StandardRenderers.DATE.apply((Object)mc2o.getEndDate()));
                        view.setEndDate(mc2o.getEndDate());
                        result.add(view);
                    }
                    for (ModelContract2Organization mc2o : modelContract.getCustomers()) {
                        EntityReference customer = mc2o.getOrganization();
                        if (customer == null || !customer.equals((Object)index.getCustomer())) continue;
                        view = this.createModelContractVM(index, false);
                        view.setStartDateText((String)StandardRenderers.DATE.apply((Object)mc2o.getStartDate()));
                        view.setStartDate(mc2o.getStartDate());
                        view.setEndDateText((String)StandardRenderers.DATE.apply((Object)mc2o.getEndDate()));
                        view.setEndDate(mc2o.getEndDate());
                        result.add(view);
                    }
                }
            }
            FxUtil.waitForFxThread(() -> {
                this.getData().setAll((Collection)result);
                this.offset = newOffset;
            });
        }, this.getMutex());
    }

    private List<String> searchContractsDirectBinding(EntityReference<ModelContract> modelContractRef, EntityService entityService) throws ServiceException {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)ContractIndex.Property.modelContracts.name(), modelContractRef));
        return entityService.search(ServiceInvocationContext.get(), ContractIndex.class, query).stream().map(ContractIndex::getUid).collect(Collectors.toList());
    }

    private List<ContractIndex> searchContracts(EntityContainer<ModelContract> modelContractCtr, EntityService entityService, FilterProperty property) throws ServiceException {
        SearchQuery query = new SearchQuery();
        query.setOffset(property.getOffset());
        query.setLimit(property.getLimit());
        if (StringUtils.isNotBlank((String)property.getFilterName())) {
            query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)ContractIndex.Property.name.name(), (String)('%' + property.getFilterName() + '%')));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        ArrayList<SearchCriterion> searchCriterions = new ArrayList<SearchCriterion>();
        searchCriterions.add(SearchCriterion.contains((String)ContractIndex.Property.modelContracts.name(), (Object)modelContractCtr.toReference()));
        if (!((ModelContract)modelContractCtr.getEntity()).getSuppliers().isEmpty()) {
            searchCriterions.add(SearchQueryHelper.buildOrEqEntityCriterion((String)ContractIndex.Property.supplier.name(), (Collection)((ModelContract)modelContractCtr.getEntity()).getSuppliers().stream().map(ModelContract2Organization::getOrganization).collect(Collectors.toList())));
        }
        if (!((ModelContract)modelContractCtr.getEntity()).getCustomers().isEmpty()) {
            searchCriterions.add(SearchQueryHelper.buildOrEqEntityCriterion((String)ContractIndex.Property.customer.name(), (Collection)((ModelContract)modelContractCtr.getEntity()).getCustomers().stream().map(ModelContract2Organization::getOrganization).collect(Collectors.toList())));
        }
        if (((ModelContract)modelContractCtr.getEntity()).getContractType() != null) {
            searchCriterions.add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)((ModelContract)modelContractCtr.getEntity()).getContractType()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])searchCriterions.toArray(new SearchCriterion[searchCriterions.size()])));
        return entityService.search(ServiceInvocationContext.get(), ContractIndex.class, query);
    }

    private ModelContractInContractsDataVM createModelContractVM(ContractIndex index, boolean isDirectBinding) {
        ModelContractInContractsDataVM view = new ModelContractInContractsDataVM();
        if (index.getVendor() != null) {
            view.setVendor(index.getVendor().getCaption());
        }
        view.setName(index.getName());
        if (index.getSupplier() != null) {
            view.setSupplier(index.getSupplier().getCaption());
        }
        if (index.getCustomer() != null) {
            view.setCustomer(index.getCustomer().getCaption());
        }
        if (index.getContractType() != null) {
            view.setContractType(index.getContractType().toString());
        }
        if (index.getSource() != null) {
            view.setSource(index.getSource());
        }
        view.setDirectBinding(Boolean.valueOf(isDirectBinding));
        return view;
    }

    private class FilterProperty {
        private final int offset;
        private final int limit;
        private final String filterName;

        FilterProperty(int offset, int limit, String filterName) {
            this.offset = offset;
            this.limit = limit;
            this.filterName = filterName;
        }

        private int getOffset() {
            return this.offset;
        }

        private int getLimit() {
            return this.limit;
        }

        private String getFilterName() {
            return this.filterName;
        }
    }
}

