/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractMainAdditionalPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractMainInfoPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractMainPanelCustomersTableVM;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractMainPanelSuppliersTableVM;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractMainPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContract2Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.util.Date;

final class ModelContractMainPanelHelper {
    private ModelContractMainPanelHelper() {
    }

    static void toVM(ModelContract model, ModelContractMainPanelVM modelContractVM) {
        ModelContractMainInfoPanelVM infoVM = modelContractVM.getInfo();
        infoVM.setName(model.getName());
        infoVM.setPriority(model.getPriority());
        infoVM.setLastTchNotificationDate(DateUtils.asLocalDate((Date)model.getLastTchNotificationDate()));
        ModelContractMainAdditionalPanelVM additionalVM = modelContractVM.getAdditional();
        additionalVM.setContractType(model.getContractType());
        VMHelper.transfer(model.getSuppliers(), additionalVM.getSuppliersTable(), param -> new ModelContractMainPanelSuppliersTableVM(), (param, vm) -> {
            vm.setSupplier(param.getOrganization());
            vm.setStartDate(DateUtils.asLocalDate((Date)param.getStartDate()));
            vm.setEndDate(DateUtils.asLocalDate((Date)param.getEndDate()));
        });
        VMHelper.transfer(model.getCustomers(), additionalVM.getCustomersTable(), param -> new ModelContractMainPanelCustomersTableVM(), (param, vm) -> {
            vm.setCustomer(param.getOrganization());
            vm.setStartDate(DateUtils.asLocalDate((Date)param.getStartDate()));
            vm.setEndDate(DateUtils.asLocalDate((Date)param.getEndDate()));
        });
    }

    static void fromVM(ModelContractMainPanelVM modelContractVM, ModelContract model) {
        ModelContractMainInfoPanelVM infoPanelVM = modelContractVM.getInfo();
        model.setName(infoPanelVM.getName());
        model.setPriority(infoPanelVM.getPriority());
        model.setLastTchNotificationDate(DateUtils.asDate((LocalDate)infoPanelVM.getLastTchNotificationDate()));
        ModelContractMainAdditionalPanelVM additionalVM = modelContractVM.getAdditional();
        model.setContractType(additionalVM.getContractType());
        VMHelper.transfer(additionalVM.getSuppliersTable(), model.getSuppliers(), mc2o -> new ModelContract2Organization(), (vm, mc2o) -> {
            mc2o.setOrganization(vm.getSupplier());
            mc2o.setStartDate(DateUtils.asDate((LocalDate)vm.getStartDate()));
            mc2o.setEndDate(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)vm.getEndDate())));
        });
        VMHelper.transfer(additionalVM.getCustomersTable(), model.getCustomers(), mc2o -> new ModelContract2Organization(), (vm, mc2o) -> {
            mc2o.setOrganization(vm.getCustomer());
            mc2o.setStartDate(DateUtils.asDate((LocalDate)vm.getStartDate()));
            mc2o.setEndDate(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)vm.getEndDate())));
        });
    }
}

