/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractEditorInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractMainPanelHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractOtherParametersTileHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.rules.RuleSet;
import java.util.List;
import java.util.function.BiConsumer;

class StandardModelContractHandlerConfigurator
implements ModelContractHandlerConfigurator<ModelContract, ModelContractSpaceVM> {
    StandardModelContractHandlerConfigurator() {
    }

    @Override
    public void configureController(List<BiConsumer<DataTransferPackage<ModelContract, Void>, ModelContractSpaceVM>> toVM, List<BiConsumer<ModelContractSpaceVM, DataTransferPackage<ModelContract, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            ModelContract model = (ModelContract)dtp.getContainer().getEntity();
            vm.getOverview().setName(model.getName());
            ModelContractMainPanelHelper.toVM(model, vm.getContractFull());
            ModelContractOtherParametersTileHelper.toVM(model, vm.getOtherParametersFull());
            VMHelper.copy(model.getRuleSet(), vm.getRulesFull());
        });
        fromVM.add((vm, dtp) -> {
            ModelContract model = (ModelContract)dtp.getContainer().getEntity();
            ModelContractMainPanelHelper.fromVM(vm.getContractFull(), model);
            ModelContractOtherParametersTileHelper.fromVM(vm.getOtherParametersFull(), model);
            if (model.getRuleSet() == null) {
                model.setRuleSet(new RuleSet());
            }
            VMHelper.copy(vm.getRulesFull(), model.getRuleSet());
        });
    }

    @Override
    public void collectEditorInterceptors(List<RootEntityEditorInterceptor<ModelContract, Void>> editorInterceptors) {
        editorInterceptors.add(new ModelContractEditorInterceptor());
    }
}

