/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.ContactPhonesTableVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationAccountManagerVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationAddressExtraPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationAddressVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationContactsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationEmailVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationKeyContactVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSiteVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationWorkModeVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.model.profile.WorkMode;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptorReference;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.stream.Collectors;

final class OrganizationContactsTileHelper {
    private OrganizationContactsTileHelper() {
    }

    static void toVM(Organization model, OrganizationContactsPanelVM full) {
        full.getGeneralInfo().setPreferredLanguage(model.getPreferredLocale());
        VMHelper.transfer(model.getRiskManagementCompanies(), full.getGeneralInfo().getRiskManagementCompanies());
        VMHelper.transfer(model.getWorkModes(), full.getMode(), mode -> new OrganizationWorkModeVM(), (mode, vm) -> {
            vm.setWorkModeType(mode.getWorkModeType());
            vm.setStartTime(DateUtils.asLocalTime((Date)mode.getStartTime()));
            vm.setFinishTime(DateUtils.asLocalTime((Date)mode.getFinishTime()));
        });
        ArrayList<Communication> phones = new ArrayList<Communication>();
        ArrayList<Communication> emails = new ArrayList<Communication>();
        ArrayList<Communication> sites = new ArrayList<Communication>();
        block4: for (Communication cmm2 : model.getCommunications()) {
            if (cmm2.getType() == null) {
                phones.add(cmm2);
                continue;
            }
            switch (cmm2.getType()) {
                case EMAIL: {
                    emails.add(cmm2);
                    continue block4;
                }
                case WEB: {
                    sites.add(cmm2);
                    continue block4;
                }
            }
            phones.add(cmm2);
        }
        VMHelper.transfer(phones, full.getPhones(), cmm -> new ContactPhonesTableVM(), (cmm, vm) -> {
            vm.setType(cmm.getType());
            vm.setCountryCode(cmm.getCountryCode());
            vm.setCityCode(cmm.getCityCode());
            vm.setPhoneNumber(cmm.getSense());
            vm.setInternalNumber(cmm.getInternalNumber());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(emails, full.getEmails(), cmm -> new OrganizationEmailVM(), (cmm, vm) -> {
            vm.setAddress(cmm.getSense());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(sites, full.getSites(), cmm -> new OrganizationSiteVM(), (cmm, vm) -> {
            vm.setAddress(cmm.getSense());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(model.getAddresses(), full.getAddresses(), address -> new OrganizationAddressVM(), (address, vm) -> {
            vm.setType(address.getAddressType());
            vm.setStartDate(DateUtils.asLocalDate((Date)address.getStartDate()));
            vm.setEndDate(DateUtils.asLocalDate((Date)address.getEndDate()));
            vm.setZip(address.getZip());
            vm.setCountry(address.getCountry());
            vm.setCity(address.getCity());
            vm.setStreet(address.getAddress());
            vm.setBuilding(address.getHouse());
            vm.setOffice(address.getOffice());
            OrganizationAddressExtraPanelVM extraMain = vm.getExtraMain();
            extraMain.setRegion(address.getRegion());
            extraMain.setDistrict(address.getDistrict());
            extraMain.setLocality(address.getTown());
            extraMain.setPoBox(address.getPoBox());
            extraMain.setHousing(address.getHousing());
            extraMain.setBuilding(address.getBuilding());
            extraMain.setPavilion(address.getPavilion());
            extraMain.setFlat(address.getFlat());
            extraMain.setMetroStation(address.getMetroStation());
            extraMain.setDeliveryRegion(address.getDeliveryRegion());
            extraMain.setComment(address.getNotes());
        });
        VMHelper.transfer(model.getKeyContacts(), full.getKeyContacts(), contact -> new OrganizationKeyContactVM(), (contact, vm) -> {
            vm.setPerson(contact.getPerson());
            vm.setEmailType(contact.getEmailType());
            vm.setLineType(contact.getLineType());
            vm.setNotes(contact.getNotes());
            vm.setAuthorizer(contact.isAuthorizer());
        });
        VMHelper.transfer(model.getMetadata().stream().filter(data -> "KEY_ORGANIZATION_ACCOUNT_MANAGER".equals(data.getKey().getCode())).collect(Collectors.toList()), full.getAccountManagers(), manager -> new OrganizationAccountManagerVM(), (manager, vm) -> {
            vm.setPerson((EntityReference)manager.getValue());
            vm.setNotes(manager.getRemarks());
        });
    }

    static void fromVM(OrganizationContactsPanelVM full, Organization model) {
        model.setPreferredLocale(full.getGeneralInfo().getPreferredLanguage());
        VMHelper.transfer(full.getGeneralInfo().getRiskManagementCompanies(), model.getRiskManagementCompanies());
        VMHelper.transfer(full.getMode(), model.getWorkModes(), vm -> new WorkMode(), (vm, workMode) -> {
            workMode.setWorkModeType(vm.getWorkModeType());
            workMode.setStartTime(DateUtils.asDate((LocalTime)vm.getStartTime()));
            workMode.setFinishTime(DateUtils.asDate((LocalTime)vm.getFinishTime()));
        });
        ArrayList communicationVMs = new ArrayList();
        communicationVMs.addAll(full.getPhones());
        communicationVMs.addAll(full.getEmails().stream().filter(vm -> !TextUtil.isBlank((String)vm.getAddress()) || !TextUtil.isBlank((String)vm.getNotes())).collect(Collectors.toList()));
        communicationVMs.addAll(full.getSites());
        VMHelper.transfer(communicationVMs, model.getCommunications(), vm -> new Communication(), (vm, cmm) -> {
            if (vm instanceof ContactPhonesTableVM) {
                ContactPhonesTableVM phoneVM = (ContactPhonesTableVM)vm;
                cmm.setType(phoneVM.getType());
                cmm.setCountryCode(phoneVM.getCountryCode());
                cmm.setCityCode(phoneVM.getCityCode());
                cmm.setSense(phoneVM.getPhoneNumber());
                cmm.setInternalNumber(phoneVM.getInternalNumber());
                cmm.setRemarks(phoneVM.getNotes());
            } else if (vm instanceof OrganizationEmailVM) {
                OrganizationEmailVM emailVM = (OrganizationEmailVM)vm;
                cmm.setType(CommunicationType.EMAIL);
                cmm.setSense(emailVM.getAddress());
                cmm.setRemarks(emailVM.getNotes());
            } else if (vm instanceof OrganizationSiteVM) {
                OrganizationSiteVM siteVM = (OrganizationSiteVM)vm;
                cmm.setType(CommunicationType.WEB);
                cmm.setSense(siteVM.getAddress());
                cmm.setRemarks(siteVM.getNotes());
            }
        });
        VMHelper.transfer(full.getAddresses(), model.getAddresses(), vm -> new Address(), (vm, address) -> {
            address.setAddressType(vm.getType());
            address.setStartDate(DateUtils.asDate((LocalDate)vm.getStartDate()));
            address.setEndDate(DateUtils.asDate((LocalDate)vm.getEndDate()));
            address.setZip(vm.getZip());
            address.setCountry(vm.getCountry());
            address.setCity(vm.getCity());
            address.setRegion(vm.getExtraMain().getRegion());
            VMHelper.fromVM(vm.getStreet(), address.getAddress());
            VMHelper.fromVM(vm.getBuilding(), address.getHouse());
            VMHelper.fromVM(vm.getOffice(), address.getOffice());
            VMHelper.fromVM(vm.getExtraMain().getDistrict(), address.getDistrict());
            VMHelper.fromVM(vm.getExtraMain().getLocality(), address.getTown());
            VMHelper.fromVM(vm.getExtraMain().getHousing(), address.getHousing());
            VMHelper.fromVM(vm.getExtraMain().getBuilding(), address.getBuilding());
            VMHelper.fromVM(vm.getExtraMain().getPavilion(), address.getPavilion());
            VMHelper.fromVM(vm.getExtraMain().getFlat(), address.getFlat());
            address.setPoBox(vm.getExtraMain().getPoBox());
            address.setMetroStation(vm.getExtraMain().getMetroStation());
            address.setDeliveryRegion(vm.getExtraMain().getDeliveryRegion());
            address.setNotes(vm.getExtraMain().getComment());
        });
        VMHelper.transfer(full.getKeyContacts(), model.getKeyContacts(), vm -> new ProfileKeyContactPerson(), (vm, contact) -> {
            contact.setPerson(vm.getPerson());
            contact.setEmailType(vm.getEmailType());
            contact.setLineType(vm.getLineType());
            contact.setNotes(vm.getNotes());
            contact.setAuthorizer(vm.isAuthorizer());
        });
        VMHelper.transfer(full.getAccountManagers(), model.getMetadata(), md -> md.getKey() != null && "KEY_ORGANIZATION_ACCOUNT_MANAGER".equals(md.getKey().getCode()), vm -> new Metadata(), (vm, md) -> {
            md.setKey((DictionaryReference)new MetadataKeyDescriptorReference("KEY_ORGANIZATION_ACCOUNT_MANAGER"));
            md.setValue((Object)vm.getPerson());
            md.setRemarks(vm.getNotes());
        });
    }
}

