/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationCreditLimitInfoVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationCreditsPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import java.time.LocalDateTime;
import java.util.Date;

final class OrganizationCreditsTileHelper {
    private OrganizationCreditsTileHelper() {
    }

    static void toVM(Organization model, OrganizationCreditsPanelVM full) {
        VMHelper.transfer(model.getFinanceRestrictions().getCreditLimits(), full.getContent(), credit -> new OrganizationCreditLimitInfoVM(), (credit, vm) -> {
            vm.setCreditor(credit.getCreditor());
            vm.setTerminalCreditLimit(credit.getTerminalCreditLimit());
            vm.setTerminalCreditDateStart(DateUtils.asLocalDateTime((Date)credit.getTerminalCreditDateStart()));
            vm.setTerminalCreditDateEnd(DateUtils.asLocalDateTime((Date)credit.getTerminalCreditDateEnd()));
            vm.setCreditLimit(credit.getCreditLimit());
            vm.setUnlimited(credit.isUnlimited());
        });
    }

    static void fromVM(OrganizationCreditsPanelVM full, Organization model) {
        VMHelper.transfer(full.getContent(), model.getFinanceRestrictions().getCreditLimits(), vm -> new CreditLimitInfo(), (vm, credit) -> {
            credit.setCreditor(vm.getCreditor());
            credit.setUnlimited(vm.isUnlimited());
            credit.setTerminalCreditLimit(vm.getTerminalCreditLimit() != null && vm.getTerminalCreditLimit().signum() != -1 ? vm.getTerminalCreditLimit() : null);
            credit.setCreditLimit(vm.getCreditLimit() != null && vm.getCreditLimit().signum() != -1 ? vm.getCreditLimit() : null);
            Date vmStartDate = DateUtils.asDate((LocalDateTime)vm.getTerminalCreditDateStart());
            Date vmEndDate = DateUtils.asDate((LocalDateTime)vm.getTerminalCreditDateEnd());
            Date startDate = credit.getTerminalCreditDateStart();
            Date endDate = credit.getTerminalCreditDateEnd();
            if (vmStartDate != null && vmEndDate != null) {
                boolean checkLegalDate;
                boolean bl = checkLegalDate = !vmStartDate.before(vmEndDate) && !vmStartDate.equals(vmEndDate);
                if (!vmEndDate.equals(endDate) && !vmStartDate.equals(startDate)) {
                    vmEndDate = checkLegalDate ? null : vmEndDate;
                    vmStartDate = checkLegalDate ? null : vmStartDate;
                } else if (!vmEndDate.equals(endDate)) {
                    vmEndDate = checkLegalDate ? null : vmEndDate;
                } else {
                    Date date = vmStartDate = checkLegalDate ? null : vmStartDate;
                    if (checkLegalDate) {
                        vmStartDate = null;
                    }
                }
            }
            credit.setTerminalCreditDateStart(vmStartDate);
            credit.setTerminalCreditDateEnd(vmEndDate);
        });
    }
}

