/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationCreditLimitInfoVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationCreditsGridPanelController;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpace;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDateTime;
import javafx.scene.Node;

public class OrganizationCreditsTileControllerInterceptor
extends ControllerInterceptor<OrganizationCreditLimitInfoVM, OrganizationCreditsGridPanelController> {
    protected Class<OrganizationCreditsGridPanelController> getControllerClass() {
        return OrganizationCreditsGridPanelController.class;
    }

    protected void onCreate(OrganizationCreditsGridPanelController controller) {
        this.setCheckNegativeValueListener(controller.getView().getCreditLimitNode(), Messages.Negative_value_of_the_indefinite_loan);
        this.setCheckNegativeValueListener(controller.getView().getTerminalCreditLimitNode(), Messages.Negative_value_of_the_Term_loan);
        DateTimeValueWidget endDateWidget = controller.getView().getTerminalCreditDateEndNode();
        endDateWidget.valueProperty().addListener((obs, oldValue, newValue) -> {
            LocalDateTime startDate;
            RootEntityPane rootEntityPane;
            if (newValue != null && (rootEntityPane = RootEntityPane.lookup((Node)endDateWidget)) != null && (startDate = controller.getView().getTerminalCreditDateStartNode().getValue()) != null && !startDate.isEqual((ChronoLocalDateTime<?>)newValue) && startDate.isAfter((ChronoLocalDateTime<?>)newValue)) {
                OrganizationSpace space = (OrganizationSpace)rootEntityPane.getEditor();
                space.addFlashMessages(new Message[]{MessageHelper.createWarningMessage((String)Messages.Credit_end_date_can_not_be_less_than_the_credit_start_date, (Object[])new Object[0])});
            }
        });
        endDateWidget.setInitialTimeSupplier(() -> LocalTime.MAX);
        DateTimeValueWidget startDateWidget = controller.getView().getTerminalCreditDateStartNode();
        startDateWidget.valueProperty().addListener((obs, oldValue, newValue) -> {
            LocalDateTime endDate;
            RootEntityPane rootEntityPane;
            if (newValue != null && (rootEntityPane = RootEntityPane.lookup((Node)startDateWidget)) != null && (endDate = controller.getView().getTerminalCreditDateEndNode().getValue()) != null && !endDate.isEqual((ChronoLocalDateTime<?>)newValue) && newValue.isAfter(endDate)) {
                OrganizationSpace space = (OrganizationSpace)rootEntityPane.getEditor();
                space.addFlashMessages(new Message[]{MessageHelper.createWarningMessage((String)Messages.Credit_start_date_error, (Object[])new Object[0])});
            }
        });
    }

    private void setCheckNegativeValueListener(PriceValueWidget widget, String message) {
        widget.valueProperty().addListener((obs, oldValue, newValue) -> {
            RootEntityPane rootEntityPane;
            if (newValue != null && newValue.signum() == -1 && (rootEntityPane = RootEntityPane.lookup((Node)widget)) != null) {
                OrganizationSpace space = (OrganizationSpace)rootEntityPane.getEditor();
                space.addFlashMessages(new Message[]{MessageHelper.createWarningMessage((String)message, (Object[])new Object[0])});
            }
        });
    }
}

