/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.parsers.B2ExchangeDocumentSpace;
import com.gridnine.xtrip.client.fx.model.parsers.B2ExchangeDocumentSpaceController;
import com.gridnine.xtrip.client.fx.model.parsers.B2ExchangeDocumentSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.ParsersHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.parsers.model.B2ExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.B2ExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class B2ExchangeDocumentHandler
extends BaseRootEntityHandler<B2ExchangeDocument, Void, B2ExchangeDocumentSpaceVM, B2ExchangeDocumentSpace> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<B2ExchangeDocument, Void>, B2ExchangeDocumentSpaceVM>> toVM, List<BiConsumer<B2ExchangeDocumentSpaceVM, DataTransferPackage<B2ExchangeDocument, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            B2ExchangeDocument model = (B2ExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.overviewToVM((BaseExchangeDocument)model, vm.getOverview());
            ParsersHelper.generalParametersToVM((BaseExchangeDocument)model, vm.getGeneralParametersFull());
            ParsersHelper.messagesToVM((BaseExchangeDocument)model, vm.getMessagesFull());
            ParsersHelper.contentToVM((BaseExchangeDocument)model, vm.getContentFull());
            vm.getB2FileFull().setPnr(model.getPnr());
            vm.getB2FileFull().setBookingDate(DateUtils.asLocalDateTime((Date)model.getBookingDate()));
            vm.getB2FileFull().setTravellerName(model.getTravellerName());
        });
        fromVM.add((vm, dtp) -> {
            B2ExchangeDocument model = (B2ExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.generalParametersFromVM(vm.getGeneralParametersFull(), (BaseExchangeDocument)model);
            ParsersHelper.contentFromVM(vm.getContentFull(), (BaseExchangeDocument)model);
            model.setPnr(vm.getB2FileFull().getPnr());
            model.setBookingDate(DateUtils.asDate((LocalDateTime)vm.getB2FileFull().getBookingDate()));
            model.setTravellerName(vm.getB2FileFull().getTravellerName());
        });
    }

    @Override
    protected ViewController<B2ExchangeDocumentSpace, B2ExchangeDocumentSpaceVM> createSpaceController(boolean readonly) {
        return new B2ExchangeDocumentSpaceController(readonly);
    }

    @Override
    protected B2ExchangeDocumentSpaceVM createVM() {
        return new B2ExchangeDocumentSpaceVM();
    }

    public Class<B2ExchangeDocument> getEntityClass() {
        return B2ExchangeDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return B2ExchangeDocumentIndex.class;
    }
}

