/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.parsers.InmobExchangeDocumentSpace;
import com.gridnine.xtrip.client.fx.model.parsers.InmobExchangeDocumentSpaceController;
import com.gridnine.xtrip.client.fx.model.parsers.InmobExchangeDocumentSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.ParsersHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.InmobExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.InmobExchangeDocumentIndex;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class InmobExchangeDocumentHandler
extends BaseRootEntityHandler<InmobExchangeDocument, Void, InmobExchangeDocumentSpaceVM, InmobExchangeDocumentSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return InmobExchangeDocumentIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<InmobExchangeDocument, Void>, InmobExchangeDocumentSpaceVM>> toVM, List<BiConsumer<InmobExchangeDocumentSpaceVM, DataTransferPackage<InmobExchangeDocument, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            InmobExchangeDocument model = (InmobExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.overviewToVM((BaseExchangeDocument)model, vm.getOverview());
            ParsersHelper.messagesToVM((BaseExchangeDocument)model, vm.getMessagesFull());
            ParsersHelper.contentToVM((BaseExchangeDocument)model, vm.getContentFull());
            vm.getInmobFull().setIssued(DateUtils.asLocalDate((Date)model.getIssueDate()));
            StringBuilder builderTr = new StringBuilder();
            model.getTravellers().forEach(traveler -> {
                builderTr.append((String)traveler);
                builderTr.append(", ");
            });
            if (builderTr.length() > 1) {
                vm.getInmobFull().setTravelersNames(builderTr.substring(0, builderTr.length() - 2));
            }
            if (model.getTicketNumbers().isEmpty()) {
                vm.getInmobFull().setTicketNumbers(model.getSystemNumber());
            } else {
                vm.getInmobFull().setTicketNumbers(String.join((CharSequence)", ", model.getTicketNumbers()));
            }
            vm.getInmobFull().setOrderFile(model.getRelatedBookingFile());
            vm.getInmobFull().setOwner(model.getOwner());
            vm.getInmobFull().setTransactionType(model.getTransactionType());
            vm.getInmobFull().setPnrLocator(model.getPnrLocator());
        });
        fromVM.add((vm, dtp) -> {
            InmobExchangeDocument model = (InmobExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.contentFromVM(vm.getContentFull(), (BaseExchangeDocument)model);
            model.setIssueDate(DateUtils.asDate((LocalDate)vm.getInmobFull().getIssued()));
            model.setOwner(vm.getInmobFull().getOwner());
            model.getTravellers().clear();
            if (vm.getInmobFull().getTravelersNames() != null) {
                String[] travelers;
                for (String str : travelers = vm.getInmobFull().getTravelersNames().split(",")) {
                    model.getTravellers().add(str.trim());
                }
            }
            model.setSystemNumber(vm.getInmobFull().getTicketNumbers());
            model.getTicketNumbers().add(vm.getInmobFull().getTicketNumbers());
            model.setPnrLocator(vm.getInmobFull().getPnrLocator());
            model.setRelatedBookingFile(vm.getInmobFull().getOrderFile());
            model.setOwner(vm.getInmobFull().getOwner());
            model.setTransactionType(vm.getInmobFull().getTransactionType());
        });
    }

    public Class<InmobExchangeDocument> getEntityClass() {
        return InmobExchangeDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected ViewController<InmobExchangeDocumentSpace, InmobExchangeDocumentSpaceVM> createSpaceController(boolean readonly) {
        return new InmobExchangeDocumentSpaceController(readonly);
    }

    @Override
    protected InmobExchangeDocumentSpaceVM createVM() {
        return new InmobExchangeDocumentSpaceVM();
    }
}

