/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person;

import com.gridnine.xtrip.client.fx.model.profile.PersonAddressVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonAssistantEmailTypesVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonAssistantEmailVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonAssistantPhoneVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonContactsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonEmailVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonKeyContactVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonPhoneVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonSiteVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.profile.SabreContactEmail;
import com.gridnine.xtrip.common.model.profile.SabreContactPhone;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptorReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

final class PersonContactsTileHelper {
    private PersonContactsTileHelper() {
    }

    static void toVM(Person model, PersonContactsPanelVM full) {
        full.setPreferredLanguage(model.getPreferredLocale());
        ArrayList<PersonCommunication> phones = new ArrayList<PersonCommunication>();
        ArrayList<PersonCommunication> emails = new ArrayList<PersonCommunication>();
        ArrayList<PersonCommunication> sites = new ArrayList<PersonCommunication>();
        block4: for (PersonCommunication cmm2 : model.getCommunications()) {
            if (cmm2.getType() == null) {
                phones.add(cmm2);
                continue;
            }
            switch (cmm2.getType()) {
                case EMAIL: {
                    emails.add(cmm2);
                    continue block4;
                }
                case WEB: {
                    sites.add(cmm2);
                    continue block4;
                }
            }
            phones.add(cmm2);
        }
        VMHelper.transfer(phones, full.getPhones(), cmm -> new PersonPhoneVM(), (cmm, vm) -> {
            vm.setType(cmm.getType());
            vm.setCountryCode(cmm.getCountryCode());
            vm.setCityCode(cmm.getCityCode());
            vm.setPhoneNumber(cmm.getSense());
            vm.setInternalNumber(cmm.getInternalNumber());
            vm.setOrganization(cmm.getOrganization());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(emails, full.getEmails(), cmm -> new PersonEmailVM(), (cmm, vm) -> {
            vm.setOrganization(cmm.getOrganization());
            vm.setAddress(cmm.getSense());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(sites, full.getSites(), cmm -> new PersonSiteVM(), (cmm, vm) -> {
            vm.setOrganization(cmm.getOrganization());
            vm.setAddress(cmm.getSense());
            vm.setNotes(cmm.getRemarks());
        });
        VMHelper.transfer(model.getAddresses(), full.getAddresses(), addr -> new PersonAddressVM(), (address, vm) -> {
            vm.setType(address.getAddressType());
            vm.setOrganization(address.getOrganization());
            vm.setZip(address.getZip());
            vm.setCountry(address.getCountry());
            vm.setCity(address.getCity());
            vm.setStreet(address.getAddress());
            vm.setBuilding(address.getHouse());
            vm.setOffice(address.getOffice());
            vm.getExtraMain().setRegion(address.getRegion());
            vm.getExtraMain().setDistrict(address.getDistrict());
            vm.getExtraMain().setLocality(address.getTown());
            vm.getExtraMain().setHousing(address.getHousing());
            vm.getExtraMain().setBuilding(address.getBuilding());
            vm.getExtraMain().setPavilion(address.getPavilion());
            vm.getExtraMain().setFlat(address.getFlat());
            vm.getExtraMain().setPoBox(address.getPoBox());
            vm.getExtraMain().setMetroStation(address.getMetroStation());
            vm.getExtraMain().setDeliveryRegion(address.getDeliveryRegion());
            vm.getExtraMain().setComment(address.getNotes());
        });
        VMHelper.transfer(model.getSabrePhoneContacts(), full.getAssistantPhones(), contact -> new PersonAssistantPhoneVM(), (contact, vm) -> {
            vm.setName(contact.getContactName());
            vm.setFirstName(contact.getContactFirstName());
            vm.setType(contact.getType());
            vm.setCountryCode(contact.getCountryCode());
            vm.setCityCode(contact.getCityCode());
            vm.setPhoneNumber(contact.getSense());
            vm.setInternalNumber(contact.getInternalNumber());
            vm.setMain(contact.isPrimaryContact());
        });
        VMHelper.transfer(model.getSabreEmailContacts(), full.getAssistantEmails(), contact -> new PersonAssistantEmailVM(), (contact, vm) -> {
            vm.setName(contact.getContactName());
            vm.setFirstName(contact.getContactFirstName());
            PersonAssistantEmailTypesVM emailType = new PersonAssistantEmailTypesVM();
            emailType.setType(contact.getType());
            vm.setType(emailType);
            vm.setAddress(contact.getSense());
        });
        List listSalesPoint = model.getMetadata().stream().filter(md -> md.getKey() != null && "KEY_PERSON_KEY_CONTACT".equals(md.getKey().getCode())).collect(Collectors.toList());
        VMHelper.transfer(listSalesPoint, full.getPersonKeyContact(), md -> new PersonKeyContactVM(), (md, vm) -> {
            vm.setValue((EntityReference)md.getValue());
            vm.setOrganization(md.getOrganization());
        });
    }

    static void fromVM(PersonContactsPanelVM full, Person model) {
        model.setPreferredLocale(full.getPreferredLanguage());
        ArrayList communicationVMs = new ArrayList();
        communicationVMs.addAll(full.getPhones());
        communicationVMs.addAll(full.getEmails());
        communicationVMs.addAll(full.getSites());
        VMHelper.transfer(communicationVMs, model.getCommunications(), vm -> new PersonCommunication(), (vm, cmm) -> {
            if (vm instanceof PersonPhoneVM) {
                PersonPhoneVM phoneVM = (PersonPhoneVM)vm;
                cmm.setType(phoneVM.getType());
                cmm.setCountryCode(phoneVM.getCountryCode());
                cmm.setCityCode(phoneVM.getCityCode());
                cmm.setSense(phoneVM.getPhoneNumber());
                cmm.setInternalNumber(phoneVM.getInternalNumber());
                cmm.setOrganization(phoneVM.getOrganization());
                cmm.setRemarks(phoneVM.getNotes());
            } else if (vm instanceof PersonEmailVM) {
                PersonEmailVM emailVM = (PersonEmailVM)vm;
                cmm.setType(CommunicationType.EMAIL);
                cmm.setSense(emailVM.getAddress());
                cmm.setOrganization(emailVM.getOrganization());
                cmm.setRemarks(emailVM.getNotes());
            } else if (vm instanceof PersonSiteVM) {
                PersonSiteVM siteVM = (PersonSiteVM)vm;
                cmm.setType(CommunicationType.WEB);
                cmm.setSense(siteVM.getAddress());
                cmm.setOrganization(siteVM.getOrganization());
                cmm.setRemarks(siteVM.getNotes());
            }
        });
        VMHelper.transfer(full.getAddresses(), model.getAddresses(), vm -> new PersonAddress(), (vm, address) -> {
            address.setAddressType(vm.getType());
            address.setOrganization(vm.getOrganization());
            address.setZip(vm.getZip());
            address.setCountry(vm.getCountry());
            address.setCity(vm.getCity());
            VMHelper.fromVM(vm.getStreet(), address.getAddress());
            VMHelper.fromVM(vm.getBuilding(), address.getHouse());
            VMHelper.fromVM(vm.getOffice(), address.getOffice());
            address.setPoBox(vm.getExtraMain().getPoBox());
            address.setMetroStation(vm.getExtraMain().getMetroStation());
            address.setDeliveryRegion(vm.getExtraMain().getDeliveryRegion());
            address.setNotes(vm.getExtraMain().getComment());
            address.setRegion(vm.getExtraMain().getRegion());
            VMHelper.fromVM(vm.getExtraMain().getDistrict(), address.getDistrict());
            VMHelper.fromVM(vm.getExtraMain().getLocality(), address.getTown());
            VMHelper.fromVM(vm.getExtraMain().getHousing(), address.getHousing());
            VMHelper.fromVM(vm.getExtraMain().getBuilding(), address.getBuilding());
            VMHelper.fromVM(vm.getExtraMain().getPavilion(), address.getPavilion());
            VMHelper.fromVM(vm.getExtraMain().getFlat(), address.getFlat());
        });
        VMHelper.transfer(full.getAssistantPhones(), model.getSabrePhoneContacts(), vm -> new SabreContactPhone(), (vm, contact) -> {
            contact.setContactName(vm.getName());
            contact.setContactFirstName(vm.getFirstName());
            contact.setType(vm.getType());
            contact.setCountryCode(vm.getCountryCode());
            contact.setCityCode(vm.getCityCode());
            contact.setSense(vm.getPhoneNumber());
            contact.setInternalNumber(vm.getInternalNumber());
            contact.setPrimaryContact(vm.isMain());
        });
        VMHelper.transfer(full.getAssistantEmails(), model.getSabreEmailContacts(), vm -> new SabreContactEmail(), (vm, contact) -> {
            contact.setContactName(vm.getName());
            contact.setContactFirstName(vm.getFirstName());
            contact.setType(vm.getType() == null ? null : vm.getType().getType());
            contact.setSense(vm.getAddress());
        });
        VMHelper.transfer(full.getPersonKeyContact(), model.getMetadata(), md -> md.getKey() != null && "KEY_PERSON_KEY_CONTACT".equals(md.getKey().getCode()), vm -> new PersonMetadata(), (vm, md) -> {
            md.setKey((DictionaryReference)new MetadataKeyDescriptorReference("KEY_PERSON_KEY_CONTACT"));
            md.setOrganization(vm.getOrganization());
            md.setValue((Object)vm.getValue());
        });
    }
}

