/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.ExpandedGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ListItemStringConverter;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.profile.ContactPhonesTableVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonAssistantEmailTypesVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonContactsPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonContactsPanelController;
import com.gridnine.xtrip.client.fx.model.profile.PersonContactsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonKeyContact;
import com.gridnine.xtrip.client.fx.standard.helpers.CompactConverter;
import com.gridnine.xtrip.client.fx.standard.helpers.ContactsPaneHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class PersonContactsControllerInterceptor
extends ControllerInterceptor<PersonContactsPanelVM, PersonContactsPanelController> {
    private static final List<PersonAssistantEmailTypesVM> ASSISTANT_EMAIL_TYPES;
    private static final ListItemStringConverter<PersonKeyContact> KEY_PERSON_KEY_CONTACT;

    protected Class<PersonContactsPanelController> getControllerClass() {
        return PersonContactsPanelController.class;
    }

    protected void onCreate(PersonContactsPanelController controller) {
        PersonContactsPanel space = controller.getView();
        space.getPersonKeyContactCard().setHidden(true);
        ((ExpandedGroupsWidget)space.getPersonKeyContactCard().getContent()).setConverter(KEY_PERSON_KEY_CONTACT);
        Supplier<List<EntityReference<Organization>>> orgsSupplier = () -> {
            ArrayList<EntityReference> result = new ArrayList<EntityReference>();
            EntityContainer ctr = RootEntityPane.lookup((Node)space).getData().getContainer();
            if (ctr != null) {
                for (PersonEmployment empl : ((Person)ctr.getEntity()).getEmployments()) {
                    result.add(empl.getOrganization());
                }
            }
            return result;
        };
        ContactsPaneHelper.configurePhonesTable((TableWidget<? extends ContactPhonesTableVM>)((TableWidget)space.getPhonesCard().getContent()), orgsSupplier);
        ComboBoxWidgetColumn assistantPhoneTypeColumn = (ComboBoxWidgetColumn)((TableWidget)space.getAssistantPhonesCard().getContent()).getColumn("type");
        assistantPhoneTypeColumn.setItemsSupplier(() -> ContactsPaneHelper.PHONE_TYPES);
        ComboBoxWidgetColumn column = (ComboBoxWidgetColumn)((TableWidget)space.getAssistantEmailsCard().getContent()).getColumn("type");
        column.setItemsSupplier(() -> ASSISTANT_EMAIL_TYPES);
        column.setConverter((StringConverter)new StringConverter<PersonAssistantEmailTypesVM>(){

            public String toString(PersonAssistantEmailTypesVM object) {
                if (object != null) {
                    return object.getType();
                }
                return UiUtil.NULL_TEXT;
            }

            public PersonAssistantEmailTypesVM fromString(String string) {
                PersonAssistantEmailTypesVM assistantEmailTypesVM = new PersonAssistantEmailTypesVM();
                assistantEmailTypesVM.setType(string);
                return assistantEmailTypesVM;
            }
        });
        EntityBoxWidgetColumn organizationEmail = (EntityBoxWidgetColumn)((TableWidget)space.getEmailsCard().getContent()).getColumn("organization");
        organizationEmail.setItemsSupplier(orgsSupplier, false);
        EntityBoxWidgetColumn organizationSite = (EntityBoxWidgetColumn)((TableWidget)space.getSitesCard().getContent()).getColumn("organization");
        organizationSite.setItemsSupplier(orgsSupplier, false);
    }

    static {
        KEY_PERSON_KEY_CONTACT = new CompactConverter<PersonKeyContact>(panel -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add(panel.getValueNode().getText());
            return list;
        });
        PersonAssistantEmailTypesVM assistantEmailTypesVM = new PersonAssistantEmailTypesVM();
        PersonAssistantEmailTypesVM assistantEmailTypesVM2 = new PersonAssistantEmailTypesVM();
        PersonAssistantEmailTypesVM assistantEmailTypesVM3 = new PersonAssistantEmailTypesVM();
        assistantEmailTypesVM.setType("TO:");
        assistantEmailTypesVM2.setType("CC:");
        assistantEmailTypesVM3.setType("BC:");
        ASSISTANT_EMAIL_TYPES = Arrays.asList(assistantEmailTypesVM, assistantEmailTypesVM2, assistantEmailTypesVM3);
    }
}

