/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.model.profile.PersonCreditLimitInfoVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonCreditsGridPanelController;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpace;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import javafx.scene.Node;

public class PersonCreditsTileControllerInterceptor
extends ControllerInterceptor<PersonCreditLimitInfoVM, PersonCreditsGridPanelController> {
    protected Class<PersonCreditsGridPanelController> getControllerClass() {
        return PersonCreditsGridPanelController.class;
    }

    protected void onCreate(PersonCreditsGridPanelController controller) {
        this.setCheckNegativeValueListener(controller.getView().getCreditLimitNode(), Messages.Negative_value_of_the_indefinite_loan);
        this.setCheckNegativeValueListener(controller.getView().getTerminalCreditLimitNode(), Messages.Negative_value_of_the_Term_loan);
        DateValueWidget endDateWidget = controller.getView().getTerminalCreditDateEndNode();
        endDateWidget.valueProperty().addListener((obs, oldValue, newValue) -> {
            LocalDate startDate;
            RootEntityPane rootEntityPane;
            if (newValue != null && (rootEntityPane = RootEntityPane.lookup((Node)endDateWidget)) != null && (startDate = controller.getView().getTerminalCreditDateStartNode().getValue()) != null && !startDate.isEqual((ChronoLocalDate)newValue) && startDate.isAfter((ChronoLocalDate)newValue)) {
                PersonSpace space = (PersonSpace)rootEntityPane.getEditor();
                space.addFlashMessages(new Message[]{MessageHelper.createWarningMessage((String)Messages.Credit_end_date_can_not_be_less_than_the_credit_start_date, (Object[])new Object[0])});
            }
        });
        DateValueWidget startDateWidget = controller.getView().getTerminalCreditDateStartNode();
        startDateWidget.valueProperty().addListener((obs, oldValue, newValue) -> {
            LocalDate endDate;
            RootEntityPane rootEntityPane;
            if (newValue != null && (rootEntityPane = RootEntityPane.lookup((Node)startDateWidget)) != null && (endDate = controller.getView().getTerminalCreditDateEndNode().getValue()) != null && !endDate.isEqual((ChronoLocalDate)newValue) && newValue.isAfter(endDate)) {
                PersonSpace space = (PersonSpace)rootEntityPane.getEditor();
                space.addFlashMessages(new Message[]{MessageHelper.createWarningMessage((String)Messages.Credit_start_date_error, (Object[])new Object[0])});
            }
        });
    }

    private void setCheckNegativeValueListener(PriceValueWidget widget, String message) {
        widget.valueProperty().addListener((obs, oldValue, newValue) -> {
            RootEntityPane rootEntityPane;
            if (newValue != null && newValue.signum() == -1 && (rootEntityPane = RootEntityPane.lookup((Node)widget)) != null) {
                PersonSpace space = (PersonSpace)rootEntityPane.getEditor();
                space.addFlashMessages(new Message[]{MessageHelper.createWarningMessage((String)message, (Object[])new Object[0])});
            }
        });
    }
}

