/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.ExpandedGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.model.profile.PersonBonusCardsPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonContactsPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonEmailVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonEmploymentVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonExtSyncMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonGeneralParametersPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonGetThereParametersMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonGetThereParametersPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonPassportPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonPassportsMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonPrivilegeMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonSabreSyncPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpace;
import com.gridnine.xtrip.client.fx.model.profile.PersonUdidsPanel;
import com.gridnine.xtrip.client.fx.standard.custom.SabreMaskWidget;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.SabreProfilesSettings;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.ProfileService;
import com.gridnine.xtrip.common.fx.rpc.ProfilesSynchronizationService;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.person.uidata.PersonUIData;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesLoadResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationStatus;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonEditorInterceptor
implements RootEntityEditorInterceptor<Person, PersonUIData> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String NOT_UPDATE_KEY = "NOT_UPDATE";

    public void onLoad(DataTransferPackage<Person, PersonUIData> data, Node editor) {
        RootEntityPane rootEntityPane;
        if (this.isSabreProfilesLoadActive() && (rootEntityPane = RootEntityPane.lookup((Node)editor)) != null) {
            if (rootEntityPane.getMode() == EditingMode.EDIT) {
                if (!Boolean.TRUE.equals(editor.getProperties().get((Object)NOT_UPDATE_KEY))) {
                    this.updateFromSabreProfiles(rootEntityPane, data);
                    editor.getProperties().put((Object)NOT_UPDATE_KEY, (Object)Boolean.TRUE);
                }
            } else {
                editor.getProperties().put((Object)NOT_UPDATE_KEY, (Object)Boolean.FALSE);
            }
        }
    }

    public boolean onSave(DataTransferPackage<Person, PersonUIData> data, Node editor) {
        try {
            ValueHolder code = new ValueHolder();
            ValueHolder isAgent = new ValueHolder((Object)false);
            ValueHolder haveEmploymentWithoutOrganization = new ValueHolder((Object)false);
            ValueHolder havePassportWithoutType = new ValueHolder((Object)false);
            ValueHolder endDatelist = new ValueHolder();
            ValueHolder messages = new ValueHolder();
            endDatelist.set(new ArrayList());
            messages.set(new ArrayList());
            PersonSpace space = (PersonSpace)editor;
            EntityContainer personContainer = data.getContainer();
            boolean needUpdateFromSabreProfiles = this.isSabreProfilesLoadActive() && this.isNeedUpdateFromSabreProfiles((EntityContainer<Person>)personContainer, (List)messages.get());
            FxUtil.waitForFxThread(() -> {
                PersonGeneralParametersPanel panel = (PersonGeneralParametersPanel)((PersonMainPanel)space.getMainTile().getFullNode()).getGeneralCard().getContent();
                code.set((Object)panel.getCodeNode().getValue());
                ((TableWidget)((PersonMainPanel)space.getMainTile().getFullNode()).getEmploymentsCard().getContent()).getRowsData().forEach(el -> ((List)endDatelist.get()).add(el.getClosed()));
                if (((TableWidget)((PersonMainPanel)space.getMainTile().getFullNode()).getEmploymentsCard().getContent()).getRowsData().stream().anyMatch(row -> row.getOrganization() == null)) {
                    ((List)messages.get()).add(MessageHelper.createWarningMessage((String)Messages.Person_employment_org_not_set, (Object[])new Object[0]));
                    space.setMessages((List)messages.get());
                    haveEmploymentWithoutOrganization.set((Object)true);
                }
                if (panel.getTypesNode().getValues().contains((Object)PersonType.AGENT)) {
                    isAgent.set((Object)true);
                }
                if (panel.getTypesNode().getValues().isEmpty()) {
                    ((List)messages.get()).add(MessageHelper.createWarningMessage((String)Messages.Person_role_not_set, (Object[])new Object[0]));
                }
                if (((ExpandedGroupsWidget)((PersonBonusCardsPanel)((PersonPrivilegeMainPanel)space.getPrivilegeTile().getFullNode()).getBonusCardCard().getContent()).getAviaCard().getContent()).getViews().stream().anyMatch(c -> ValidationUtil.containsNonOnlyLatinLettersOrNumbers((String)c.getNumberNode().getValue()))) {
                    ((List)messages.get()).add(MessageHelper.createWarningMessage((String)Messages.Bonus_Card_Number_Contains_Non_Latin_Letters_Or_Numbers, (Object[])new Object[0]));
                }
            });
            boolean codeCorrect = this.checkCode((ValueHolder<String>)code, (ValueHolder<Boolean>)isAgent, (ValueHolder<List<LocalDate>>)endDatelist, data, editor) && this.checkSyncParams(editor, (ValueHolder<List<Message>>)messages);
            boolean hasDuplicatePassports = this.hasDuplicatePassports((EntityReference<Person>)personContainer.toReference(), space, (List)messages.get());
            if (!space.getHiddenTiles().contains((Object)space.getPassportsTile())) {
                ((ExpandedGroupsWidget)((PersonPassportsMainPanel)space.getPassportsTile().getFullNode()).getPassportsCard().getContent()).getViews().forEach(passportPanel -> PersonEditorInterceptor.validatePassport(passportPanel, (List)messages.get(), (ValueHolder<Boolean>)havePassportWithoutType));
            }
            String getThereLogin = ((PersonGetThereParametersPanel)((PersonGetThereParametersMainPanel)((PersonExtSyncMainPanel)space.getExternalSystemSynchronizationTile().getFullNode()).getGetThereSyncCard().getContent()).getParametersCard().getContent()).getResourceIdForGetThereNode().getValue();
            String somebodyWithTheSameGetThereLogin = null;
            if (!TextUtil.isBlank((String)getThereLogin) && (somebodyWithTheSameGetThereLogin = ((ProfileService)RpcServiceManager.get().getService(ProfileService.class)).getAnybodyWithEqualGetThereLogin(ServiceInvocationContext.get(), getThereLogin, personContainer.getUid())) != null) {
                ((List)messages.get()).add(MessageHelper.createWarningMessage((String)String.format(Messages.unableToSaveProfile17, getThereLogin, somebodyWithTheSameGetThereLogin), (Object[])new Object[0]));
            }
            Set emails = ((TableWidget)((PersonContactsPanel)space.getContactsTile().getFullNode()).getEmailsCard().getContent()).getRowsData().stream().map(PersonEmailVM::getAddress).collect(Collectors.toSet());
            List employments = ((TableWidget)((PersonMainPanel)space.getMainTile().getFullNode()).getEmploymentsCard().getContent()).getRowsData().stream().map(vm -> {
                PersonEmployment employment = new PersonEmployment();
                employment.setOrganization(vm.getOrganization());
                employment.setMainEmployment(vm.isMainEmployment());
                employment.setPosition(vm.getPosition());
                employment.setClosed(DateUtils.asDate((LocalDate)vm.getClosed()));
                employment.setOpened(DateUtils.asDate((LocalDate)vm.getOpened()));
                employment.setAuthorized(vm.isAuthorized());
                employment.setEmployeeCategory(vm.getEmployeeCategory());
                employment.setDepartmentSuffix(vm.getDepartmentSuffix());
                return employment;
            }).collect(Collectors.toList());
            boolean enableToSaveEmail = true;
            if (TextUtil.isBlank((String)getThereLogin) && !emails.isEmpty() && !(enableToSaveEmail = ((ProfileService)RpcServiceManager.get().getService(ProfileService.class)).checkEmails(ServiceInvocationContext.get(), personContainer.getUid(), emails, getThereLogin, employments))) {
                ((List)messages.get()).add(MessageHelper.createWarningMessage((String)Messages.unableToSaveProfileDublicateEmail, (Object[])new Object[0]));
            }
            ArrayList costCodesToFill = new ArrayList();
            for (PersonEmployment employment : employments) {
                if (employment.getOrganization() == null) continue;
                costCodesToFill.addAll(((ProfileService)RpcServiceManager.get().getService(ProfileService.class)).getCostCodesToFill(ServiceInvocationContext.get(), employment.getOrganization()));
            }
            for (PersonCostCode costCodeToFill : costCodesToFill) {
                boolean costCodeFilled = ((ExpandedGroupsWidget)((PersonUdidsPanel)space.getUdidsTile().getFullNode()).getContent()).getViews().stream().anyMatch(view -> MiscUtil.equals((Object)costCodeToFill.getOrganization(), (Object)view.getOrganizationNode().getValue()) && MiscUtil.equals((Object)costCodeToFill.getCostCodeProperties(), (Object)view.getPropertyNode().getValue()) && TextUtil.nonBlank((String)((SabreMaskWidget)view.getValueNode()).getValue()));
                if (costCodeFilled) continue;
                ((List)messages.get()).add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.UdidValueIsNotFilled, (Object[])new Object[]{costCodeToFill.getCostCodeProperties().getName(), costCodeToFill.getOrganization()}));
            }
            FxUtil.waitForFxThread(() -> space.setMessages((List)messages.get()));
            return codeCorrect && (Boolean)haveEmploymentWithoutOrganization.get() == false && (Boolean)havePassportWithoutType.get() == false && somebodyWithTheSameGetThereLogin == null && enableToSaveEmail && !needUpdateFromSabreProfiles && !hasDuplicatePassports;
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return false;
        }
    }

    public void afterSave(DataTransferPackage<Person, PersonUIData> data, Node editor) {
        if (this.isSabreProfilesLoadActive()) {
            Notifications.get().submitTask(() -> {
                MiscUtil.Pair<SabreProfilesSynchronizationStatus, List<Message>> result = this.sendToSabreProfiles((EntityContainer<Person>)data.getContainer());
                if (result != null) {
                    SabreProfilesSynchronizationStatus synchronizationStatus = (SabreProfilesSynchronizationStatus)result.getFirst();
                    List messages = (List)result.getSecond();
                    if (synchronizationStatus == SabreProfilesSynchronizationStatus.OK || synchronizationStatus == SabreProfilesSynchronizationStatus.VALIDATION_WARNING || synchronizationStatus == SabreProfilesSynchronizationStatus.SYNC_ERROR) {
                        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(data.getContainer().toReference(), EntityModification.ModificationType.CHANGE)));
                    }
                    if (synchronizationStatus == SabreProfilesSynchronizationStatus.VALIDATION_ERROR || synchronizationStatus == SabreProfilesSynchronizationStatus.SYNC_ERROR) {
                        Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProfileWasNotSynchronisedToSP, (Object[])new Object[]{messages.stream().filter(message -> message.getType() == MessageType.ERROR).map(Message::getMessage).map(L10nMessage::toString).collect(Collectors.joining(". "))})});
                    }
                }
            }, Messages.Traveler_synhronization_Sabre);
        }
    }

    boolean checkCode(ValueHolder<String> code, ValueHolder<Boolean> isAgent, ValueHolder<List<LocalDate>> endDatelist, DataTransferPackage<Person, PersonUIData> data, Node editor) throws Exception {
        if (TextUtil.isBlank((String)((String)code.get())) || !((Boolean)isAgent.get()).booleanValue()) {
            return true;
        }
        if (((List)endDatelist.get()).stream().noneMatch(Objects::isNull) && ((List)endDatelist.get()).stream().filter(Objects::nonNull).noneMatch(date -> date.compareTo(LocalDate.now()) > 0)) {
            return true;
        }
        MiscUtil.Pair result = ((ProfileService)RpcServiceManager.get().getService(ProfileService.class)).validatePersonCode(ServiceInvocationContext.get(), (String)code.get(), data.getContainer().getUid());
        if (((Boolean)result.getFirst()).booleanValue()) {
            return true;
        }
        Dialog.info((Node)editor, (String)Messages.getPerson_code_validate_error((String)code.get(), (String)result.getSecond()));
        return false;
    }

    boolean checkSyncParams(Node editor, ValueHolder<List<Message>> messages) {
        PersonSpace space = (PersonSpace)editor;
        if (((TableWidget)((PersonSabreSyncPanel)((PersonExtSyncMainPanel)space.getExternalSystemSynchronizationTile().getFullNode()).getSabreSyncCard().getContent()).getSyncParamsCard().getContent()).getRowsData().stream().anyMatch(vm -> TextUtil.nonBlank((String)vm.getPcc()) && (vm.getPassword() == null || vm.getPassword().trim().isEmpty()))) {
            ((List)messages.get()).add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Password_for_PCC_not_set, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean hasDuplicatePassports(EntityReference<Person> person, PersonSpace space, List<Message> messages) {
        if (this.isPersonEmploymentsClosed(space)) {
            return false;
        }
        List passports = ((ExpandedGroupsWidget)((PersonPassportsMainPanel)space.getPassportsTile().getFullNode()).getPassportsCard().getContent()).getViews().stream().map(passportPanel -> new MiscUtil.Pair((Object)passportPanel.getNumberNode().getValue(), (Object)MiscUtil.toDate((LocalDate)passportPanel.getBirthDateNode().getValue()))).collect(Collectors.toList());
        try {
            messages.addAll(((ProfileService)RpcServiceManager.get().getService(ProfileService.class)).checkDuplicatePassports(ServiceInvocationContext.get(), person, passports));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        return MessagesHelper.hasErrorMessage(messages);
    }

    private boolean isPersonEmploymentsClosed(PersonSpace space) {
        Collection personEmployments = ((TableWidget)((PersonMainPanel)space.getMainTile().getFullNode()).getEmploymentsCard().getContent()).getRowsData();
        return personEmployments.stream().map(PersonEmploymentVM::getClosed).noneMatch(item -> item == null || item.isAfter(LocalDate.now()));
    }

    private boolean isSabreProfilesLoadActive() {
        return Prefetched.getData().getSabreProfilesSettings().isLoadActive();
    }

    private void updateFromSabreProfiles(RootEntityPane<?, ?> rootEntityPane, DataTransferPackage<Person, PersonUIData> data) {
        Notifications.get().submitTask(() -> {
            List<SabreProfilesPccSettings> sabreProfilesPccSettings = this.checkPersonAndGetSabreProfilesPccSettings((EntityContainer<Person>)data.getContainer());
            if (sabreProfilesPccSettings.isEmpty()) {
                return;
            }
            MiscUtil.Pair loadResult = ((ProfilesSynchronizationService)RpcServiceManager.get().getService(ProfilesSynchronizationService.class)).loadExistPerson(ServiceInvocationContext.get(), data.getContainer().toReference(), sabreProfilesPccSettings.get(0), true, false);
            SabreProfilesLoadResult result = (SabreProfilesLoadResult)loadResult.getFirst();
            List messages = ((List)loadResult.getSecond()).stream().filter(message -> message.getType() == MessageType.ERROR).collect(Collectors.toList());
            if (result == SabreProfilesLoadResult.OK) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"SabreProfileLoadProfilesTask_profileWasUpdatedFromSP", (Object[])new Object[0]));
            }
            if (!messages.isEmpty()) {
                Notifications.get().showMessages(messages);
            }
            if (result == SabreProfilesLoadResult.OK) {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(data.getContainer().toReference(), EntityModification.ModificationType.CHANGE)));
            }
        }, rootEntityPane.getMutex());
    }

    private boolean isNeedUpdateFromSabreProfiles(EntityContainer<Person> personContainer, List<Message> messages) {
        boolean needUpdate;
        Date updateDateInSabreProfiles;
        List<SabreProfilesPccSettings> sabreProfilesPccSettings;
        try {
            sabreProfilesPccSettings = this.checkPersonAndGetSabreProfilesPccSettings(personContainer);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return false;
        }
        if (sabreProfilesPccSettings.isEmpty()) {
            return false;
        }
        Date updateDateInMom = ((Person)personContainer.getEntity()).getSabreProfilesUpdateDate();
        if (updateDateInMom == null) {
            return false;
        }
        try {
            updateDateInSabreProfiles = ((ProfilesSynchronizationService)RpcServiceManager.get().getService(ProfilesSynchronizationService.class)).getUpdateDateInSabreProfiles(ServiceInvocationContext.get(), personContainer.toReference(), sabreProfilesPccSettings.get(0));
        }
        catch (Exception e) {
            this.log.error("unable to get update date from Sabre Profiles", (Throwable)e);
            return false;
        }
        boolean bl = needUpdate = updateDateInSabreProfiles != null && updateDateInSabreProfiles.after(updateDateInMom);
        if (needUpdate) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SabreProfiles_profileWasUpdatedInSP, (Object[])new Object[0]));
        }
        return needUpdate;
    }

    private MiscUtil.Pair<SabreProfilesSynchronizationStatus, List<Message>> sendToSabreProfiles(EntityContainer<Person> personContainer) throws Exception {
        List<SabreProfilesPccSettings> pccSettings = this.checkPersonAndGetSabreProfilesPccSettings(personContainer);
        if (pccSettings.isEmpty()) {
            return null;
        }
        return ((ProfilesSynchronizationService)RpcServiceManager.get().getService(ProfilesSynchronizationService.class)).validateAndSendPersonToSabreProfiles(ServiceInvocationContext.get(), pccSettings, personContainer.toReference());
    }

    private List<SabreProfilesPccSettings> checkPersonAndGetSabreProfilesPccSettings(EntityContainer<Person> personContainer) throws Exception {
        SabreProfilesSettings sabreProfilesSettings = Prefetched.getData().getSabreProfilesSettings();
        if (!sabreProfilesSettings.isLoadActive()) {
            return Collections.emptyList();
        }
        Person person = (Person)personContainer.getEntity();
        if (!person.getTypes().contains(PersonType.PASSENGER)) {
            return Collections.emptyList();
        }
        if (person.getSabreProfilesUniqueIDs().isEmpty()) {
            return Collections.emptyList();
        }
        if (!((ProfilesSynchronizationService)RpcServiceManager.get().getService(ProfilesSynchronizationService.class)).isLoadAllowed(ServiceInvocationContext.get(), personContainer.toReference())) {
            return Collections.emptyList();
        }
        return person.getSabreProfilesUniqueIDs().stream().map(profileSettings -> sabreProfilesSettings.getDefaultPccSettings().stream().filter(defaultSettings -> profileSettings.getPcc().equals(defaultSettings.getPcc())).findFirst().orElse(null)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private static void validatePassport(PersonPassportPanel passportPanel, List<Message> passportMessages, ValueHolder<Boolean> havePassportWithoutType) {
        if (passportPanel.getTypeNode().getValue() == null) {
            passportMessages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Must_select_the_document_type, (Object[])new Object[0]));
            havePassportWithoutType.set((Object)true);
        }
    }
}

