/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.profile.PersonPassportPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonPassportPanelController;
import com.gridnine.xtrip.client.fx.model.profile.PersonPassportVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.person.PersonPassportsTileHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.notifications.EventNotificationTool;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import org.apache.commons.lang.StringUtils;

public class PersonPassportPanelControllerInterceptor
extends ControllerInterceptor<PersonPassportVM, PersonPassportPanelController> {
    protected Class<PersonPassportPanelController> getControllerClass() {
        return PersonPassportPanelController.class;
    }

    protected void onCreate(PersonPassportPanelController controller) {
        final PersonPassportPanel pane = controller.getView();
        controller.getView().getIssueCountyNode().setListParametersSupplier(PersonPassportsTileHelper.getDictListParameters());
        controller.getView().getCitizenshipNode().setListParametersSupplier(PersonPassportsTileHelper.getDictListParameters());
        EventNotificationTool.install(pane.getExpiredNode(), new EventNotificationTool.Configurator(){

            @Override
            public String getTitle() {
                return Messages.Notification_passport_title;
            }

            @Override
            public String getText() {
                LocalDate issueDate;
                String number;
                PassportType passportType;
                LocalDate birthDay;
                Gender gender;
                StringBuilder buf = new StringBuilder();
                String name = this.getName();
                if (!TextUtil.isBlank((String)name)) {
                    buf.append(Messages.Notification_passport_name).append(": ").append(name).append('\n');
                }
                if ((gender = (Gender)pane.getGenderNode().getValue()) != null) {
                    buf.append(Messages.Notification_passport_gender).append(": ").append(gender).append('\n');
                }
                if ((birthDay = pane.getBirthDateNode().getValue()) != null) {
                    buf.append(Messages.Notification_passport_birthday).append(": ").append((String)StandardRenderers.DATE.apply((Object)birthDay)).append('\n');
                }
                if ((passportType = (PassportType)pane.getTypeNode().getValue()) != null) {
                    buf.append(Messages.Notification_passport_type).append(": ").append(passportType).append('\n');
                }
                if (!TextUtil.isBlank((String)(number = pane.getNumberNode().getValue()))) {
                    buf.append(Messages.Notification_passport_number).append(": ").append(number).append('\n');
                }
                if ((issueDate = pane.getIssueDateNode().getValue()) != null) {
                    buf.append(Messages.Notification_passport_issued).append(": ").append((String)StandardRenderers.DATE.apply((Object)issueDate)).append('\n');
                }
                return buf.toString();
            }

            @Override
            public EntityReference<?> getNestedEntityReference() {
                Object uid = pane.getProperties().get((Object)"model-uid");
                return uid == null ? null : new EntityReference(uid.toString(), Passport.class, this.getName());
            }

            private String getName() {
                String latinName = this.getName(true);
                String cyrillicName = this.getName(false);
                return StringUtils.isBlank((String)latinName) ? cyrillicName : (StringUtils.isBlank((String)cyrillicName) ? latinName : String.join((CharSequence)" / ", latinName, cyrillicName));
            }

            private String getName(final boolean latin) {
                return TextUtil.buildFullName((PersonalName)new PersonalName(){

                    public void setMiddleName(String value) {
                    }

                    public void setLastName(String value) {
                    }

                    public void setFirstName(String value) {
                    }

                    public String getMiddleName() {
                        return (latin ? pane.getMiddleNameLatinNode() : pane.getMiddleNameCyrillicNode()).getValue();
                    }

                    public String getLastName() {
                        return (latin ? pane.getLastNameLatinNode() : pane.getLastNameCyrillicNode()).getValue();
                    }

                    public String getFirstName() {
                        return (latin ? pane.getFirstNameLatinNode() : pane.getFirstNameCyrillicNode()).getValue();
                    }
                });
            }
        });
    }
}

