/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.person.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.TripleValueWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.profile.PersonAlfaCodedRemarkVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonAlfaCodedRemarksMainPanelController;
import com.gridnine.xtrip.client.fx.model.profile.PersonAlfaCodedRemarksSubCategoryVM;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestCategory;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestDict;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionAir;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionCar;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionDelivery;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionEts;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionGroups;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionHotel;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionPayment;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionRail;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionSeatCode;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionTravel;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionVisa;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class PersonRemarksControllerInterceptor
extends ControllerInterceptor<PersonAlfaCodedRemarkVM, PersonAlfaCodedRemarksMainPanelController> {
    protected Class<PersonAlfaCodedRemarksMainPanelController> getControllerClass() {
        return PersonAlfaCodedRemarksMainPanelController.class;
    }

    protected void onCreate(PersonAlfaCodedRemarksMainPanelController controller) {
        controller.getView().getSubCategoryNode().setLive(true);
        PersonRemarksControllerInterceptor.configureValueCells(controller, true, false);
        controller.getView().getSubCategoryNode().setItemsSupplier((Supplier)new SubCategorySupplier(controller));
        controller.getView().getSubCategoryNode().valueProperty().addListener((obj, oldValue, newValue) -> {
            SabreProfileLineServiceType type = (SabreProfileLineServiceType)controller.getView().getCategoryNode().getValue();
            PersonAlfaCodedRemarksSubCategoryVM category = newValue;
            if (type == null || category == null || category.getValue() == null) {
                PersonRemarksControllerInterceptor.configureValueCells(controller, true, false);
                return;
            }
            switch (type) {
                case H: {
                    if (category.getValue().equals(SabreProfileLineSubsectionHotel.PREF_BOOK_CHANNEL.name()) || category.getValue().equals(SabreProfileLineSubsectionHotel.REASON_CODES.name())) {
                        PersonRemarksControllerInterceptor.configureValueCells(controller, true, true);
                        break;
                    }
                    PersonRemarksControllerInterceptor.configureValueCells(controller, true, false);
                    break;
                }
                case G: {
                    if (category.getValue().equals(SabreProfileLineSubsectionGroups.CONTRACT.name())) {
                        PersonRemarksControllerInterceptor.configureValueCells(controller, true, true);
                        break;
                    }
                    PersonRemarksControllerInterceptor.configureValueCells(controller, true, false);
                    break;
                }
                case T: {
                    if (category.getValue().equals(SabreProfileLineSubsectionTravel.SECURITY.name())) {
                        PersonRemarksControllerInterceptor.configureValueCells(controller, true, true);
                        break;
                    }
                    if (category.getValue().equals(SabreProfileLineSubsectionTravel.ATLAS.name())) {
                        PersonRemarksControllerInterceptor.configureValueCells(controller, false, true);
                        break;
                    }
                    PersonRemarksControllerInterceptor.configureValueCells(controller, true, false);
                    break;
                }
                case M: {
                    if (category.getValue() != null) {
                        PersonRemarksControllerInterceptor.configureValueCells(controller, false, false);
                        break;
                    }
                    PersonRemarksControllerInterceptor.configureValueCells(controller, true, false);
                    break;
                }
                case S: {
                    PersonRemarksControllerInterceptor.configureValueCells(controller, true, false);
                    break;
                }
                default: {
                    PersonRemarksControllerInterceptor.configureValueCells(controller, true, false);
                }
            }
        });
        controller.getView().getSubCategoryNode().setConverter((StringConverter)new StringConverter<PersonAlfaCodedRemarksSubCategoryVM>(){

            public String toString(PersonAlfaCodedRemarksSubCategoryVM object) {
                if (object != null) {
                    return object.getValue();
                }
                return UiUtil.NULL_TEXT;
            }

            public PersonAlfaCodedRemarksSubCategoryVM fromString(String string) {
                PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                category.setValue(string);
                return category;
            }
        });
        controller.getView().getCategoryNode().valueProperty().addListener((obj, oldValue, newValue) -> {
            if (newValue != null) {
                switch (newValue) {
                    case M: {
                        controller.getView().getSubCategoryNode().setValue(null);
                        controller.getView().getSubCategoryNode().setDisable(true);
                        Notifications.get().submitTask(() -> {
                            try {
                                List<PersonAlfaCodedRemarksSubCategoryVM> mealList = ((SubCategorySupplier)controller.getView().getSubCategoryNode().getItemsSupplier()).getMealList();
                                mealList.clear();
                                DictQuery query = new DictQuery();
                                ServiceInvocationContext sic = ServiceInvocationContext.get();
                                DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
                                query.getFields().add(SpecialServiceRequestDict.Property.category.name());
                                query.getFields().add(BaseDictionary.Property.translations.name());
                                query.getFields().add(BaseDictionary.Property.codeVariants.name());
                                List searchResult = dictService.search(sic, SpecialServiceRequestDict.class, query);
                                for (DictItem item : searchResult) {
                                    Map fields = item.getFields();
                                    SpecialServiceRequestCategory category = (SpecialServiceRequestCategory)fields.get(SpecialServiceRequestDict.Property.category.name());
                                    if (category != SpecialServiceRequestCategory.MEALS) continue;
                                    Map translations = (Map)fields.get(BaseDictionary.Property.translations.name());
                                    String code = (String)((Map)fields.get(BaseDictionary.Property.codeVariants.name())).get(CodeSystem.IATA.name());
                                    String translation = (String)translations.get(LocaleManager.get().getCurrentLocale());
                                    if (translation == null) {
                                        translation = (String)translations.get(Locale.ENGLISH);
                                    }
                                    PersonAlfaCodedRemarksSubCategoryVM category1 = new PersonAlfaCodedRemarksSubCategoryVM();
                                    if (code != null && translation != null) {
                                        category1.setValue(code + " - " + translation);
                                        mealList.add(category1);
                                        continue;
                                    }
                                    if (translation == null) continue;
                                    category1.setValue(translation);
                                    mealList.add(category1);
                                }
                                FxUtil.waitForFxThread(() -> controller.getView().getSubCategoryNode().setDisable(false));
                            }
                            catch (Exception e) {
                                ErrorHandler.handle((Throwable)e);
                            }
                        }, ObservableMutex.lookup((Node)controller.getView()));
                        break;
                    }
                    case V: {
                        controller.getView().getSubCategoryNode().setValue(null);
                        controller.getView().getSubCategoryNode().setDisable(true);
                        Notifications.get().submitTask(() -> {
                            List<PersonAlfaCodedRemarksSubCategoryVM> visasList = ((SubCategorySupplier)controller.getView().getSubCategoryNode().getItemsSupplier()).getVisasList();
                            visasList.clear();
                            try {
                                SabreProfileLineSubsectionVisa[] values;
                                for (SabreProfileLineSubsectionVisa visa : values = SabreProfileLineSubsectionVisa.values()) {
                                    PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                                    category.setValue(visa.toString());
                                    visasList.add(category);
                                }
                                DictQuery query = new DictQuery();
                                ServiceInvocationContext sic = ServiceInvocationContext.get();
                                DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
                                query.getFields().add(BaseDictionary.Property.translations.name());
                                List searchResult = dictService.search(sic, Country.class, query);
                                for (DictItem country : searchResult) {
                                    Map translations = (Map)country.getFields().get(BaseDictionary.Property.translations.name());
                                    String translation = (String)translations.get(LocaleManager.get().getCurrentLocale());
                                    if (translation == null) {
                                        translation = (String)translations.get(Locale.ENGLISH);
                                    }
                                    if (translation == null) continue;
                                    PersonAlfaCodedRemarksSubCategoryVM category1 = new PersonAlfaCodedRemarksSubCategoryVM();
                                    category1.setValue(translation);
                                    visasList.add(category1);
                                }
                                FxUtil.waitForFxThread(() -> controller.getView().getSubCategoryNode().setDisable(false));
                            }
                            catch (Exception e) {
                                ErrorHandler.handle((Throwable)e);
                            }
                        }, ObservableMutex.lookup((Node)controller.getView()));
                        break;
                    }
                    default: {
                        controller.getView().getSubCategoryNode().setValue(null);
                        break;
                    }
                }
            } else {
                controller.getView().getSubCategoryNode().setValue(null);
            }
        });
    }

    private static void configureValueCells(PersonAlfaCodedRemarksMainPanelController controller, boolean textEnabled, boolean booleanEnabled) {
        GridCell textValueCell = controller.getView().getTextValueCell();
        GridCell booleanValueCell = controller.getView().getBooleanValueCell();
        if (textEnabled && booleanEnabled) {
            textValueCell.setHidden(false);
            textValueCell.setColSpan(2);
            booleanValueCell.setColSpan(2);
            booleanValueCell.setHidden(false);
            return;
        }
        if (textEnabled) {
            booleanValueCell.setHidden(true);
            ((TripleValueWidget)booleanValueCell.getPayload()).setValue(null);
            textValueCell.setHidden(false);
            textValueCell.setColSpan(4);
            return;
        }
        if (booleanEnabled) {
            textValueCell.setHidden(true);
            ((TextFieldWidget)textValueCell.getPayload()).setValue(null);
            booleanValueCell.setHidden(false);
            booleanValueCell.setColSpan(4);
            return;
        }
        textValueCell.setHidden(true);
        ((TextFieldWidget)textValueCell.getPayload()).setValue(null);
        booleanValueCell.setHidden(true);
        ((TripleValueWidget)booleanValueCell.getPayload()).setValue(null);
    }

    static class SubCategorySupplier
    implements Supplier<List<PersonAlfaCodedRemarksSubCategoryVM>> {
        private final PersonAlfaCodedRemarksMainPanelController controller;
        final List<PersonAlfaCodedRemarksSubCategoryVM> mealList = new ArrayList<PersonAlfaCodedRemarksSubCategoryVM>();
        final List<PersonAlfaCodedRemarksSubCategoryVM> visasList = new ArrayList<PersonAlfaCodedRemarksSubCategoryVM>();

        public SubCategorySupplier(PersonAlfaCodedRemarksMainPanelController controller) {
            this.controller = controller;
        }

        @Override
        public List<PersonAlfaCodedRemarksSubCategoryVM> get() {
            if (this.controller.getView().getCategoryNode().getValue() != null) {
                ArrayList<PersonAlfaCodedRemarksSubCategoryVM> list = new ArrayList<PersonAlfaCodedRemarksSubCategoryVM>();
                switch ((SabreProfileLineServiceType)this.controller.getView().getCategoryNode().getValue()) {
                    case A: {
                        SabreProfileLineSubsectionAir[] values;
                        for (SabreProfileLineSubsectionAir air : values = SabreProfileLineSubsectionAir.values()) {
                            PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                            category.setValue(air.toString());
                            list.add(category);
                        }
                        break;
                    }
                    case C: {
                        SabreProfileLineSubsectionCar[] values;
                        for (SabreProfileLineSubsectionCar car : values = SabreProfileLineSubsectionCar.values()) {
                            PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                            category.setValue(car.toString());
                            list.add(category);
                        }
                        break;
                    }
                    case D: {
                        SabreProfileLineSubsectionDelivery[] values;
                        for (SabreProfileLineSubsectionDelivery delivery : values = SabreProfileLineSubsectionDelivery.values()) {
                            PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                            category.setValue(delivery.toString());
                            list.add(category);
                        }
                        break;
                    }
                    case E: {
                        SabreProfileLineSubsectionEts[] values;
                        for (SabreProfileLineSubsectionEts ets : values = SabreProfileLineSubsectionEts.values()) {
                            PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                            category.setValue(ets.toString());
                            list.add(category);
                        }
                        break;
                    }
                    case G: {
                        SabreProfileLineSubsectionGroups[] values;
                        for (SabreProfileLineSubsectionGroups groups : values = SabreProfileLineSubsectionGroups.values()) {
                            PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                            category.setValue(groups.toString());
                            list.add(category);
                        }
                        break;
                    }
                    case H: {
                        SabreProfileLineSubsectionHotel[] values;
                        for (SabreProfileLineSubsectionHotel hotel : values = SabreProfileLineSubsectionHotel.values()) {
                            PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                            category.setValue(hotel.toString());
                            list.add(category);
                        }
                        break;
                    }
                    case M: {
                        return this.getMealList();
                    }
                    case P: {
                        SabreProfileLineSubsectionPayment[] values;
                        for (SabreProfileLineSubsectionPayment payment : values = SabreProfileLineSubsectionPayment.values()) {
                            PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                            category.setValue(payment.toString());
                            list.add(category);
                        }
                        break;
                    }
                    case R: {
                        SabreProfileLineSubsectionRail[] values;
                        for (SabreProfileLineSubsectionRail rail : values = SabreProfileLineSubsectionRail.values()) {
                            PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                            category.setValue(rail.toString());
                            list.add(category);
                        }
                        break;
                    }
                    case S: {
                        SabreProfileLineSubsectionSeatCode[] values;
                        for (SabreProfileLineSubsectionSeatCode code : values = SabreProfileLineSubsectionSeatCode.values()) {
                            PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                            if (code.name().equals("NSSA")) {
                                category.setValue(code.toString() + " - AISLE");
                            } else if (code.name().equals("NSSW")) {
                                category.setValue(code.toString() + " - WINDOW");
                            }
                            list.add(category);
                        }
                        break;
                    }
                    case T: {
                        SabreProfileLineSubsectionTravel[] values;
                        for (SabreProfileLineSubsectionTravel travel : values = SabreProfileLineSubsectionTravel.values()) {
                            PersonAlfaCodedRemarksSubCategoryVM category = new PersonAlfaCodedRemarksSubCategoryVM();
                            category.setValue(travel.toString());
                            list.add(category);
                        }
                        break;
                    }
                    case V: {
                        return this.getVisasList();
                    }
                }
                return list;
            }
            return new ArrayList<PersonAlfaCodedRemarksSubCategoryVM>();
        }

        List<PersonAlfaCodedRemarksSubCategoryVM> getMealList() {
            return this.mealList;
        }

        List<PersonAlfaCodedRemarksSubCategoryVM> getVisasList() {
            return this.visasList;
        }
    }
}

