/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.qualityCheck;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.service.IndexListService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.model.qualityCheck.OrganizationQualityCheckRulesMainPanel;
import com.gridnine.xtrip.client.fx.model.qualityCheck.OrganizationQualityCheckRulesSpaceController;
import com.gridnine.xtrip.client.fx.model.qualityCheck.OrganizationQualityCheckRulesSpaceVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.client.fx.standard.rules.RulesWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.rules.StandardFilters;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckFilteringCategories;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.event.EventHandler;
import javafx.scene.Node;

class OrganizationQualityCheckRulesSpaceControllerInterceptor
extends ControllerInterceptor<OrganizationQualityCheckRulesSpaceVM, OrganizationQualityCheckRulesSpaceController> {
    OrganizationQualityCheckRulesSpaceControllerInterceptor() {
    }

    protected Class<OrganizationQualityCheckRulesSpaceController> getControllerClass() {
        return OrganizationQualityCheckRulesSpaceController.class;
    }

    protected void onCreate(OrganizationQualityCheckRulesSpaceController controller) {
        EventHandler handler = evt -> {
            DataTransferPackage dtp = Objects.requireNonNull(RootEntityPane.lookup((Node)controller.getView())).getData();
            if (dtp == null || dtp.getContainer() == null) {
                Notifications.get().showFlashNotification(Messages.Save_object, null);
                return;
            }
            EntityReference ref = dtp.getContainer().toReference();
            IndexListParameters params = new IndexListParameters();
            params.setIndexType(OrganizationIndex.class);
            params.getSearchCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.qualityCheckRulesUid.name(), (Object)ref.getUid()));
            TableColumnSettings filter = new TableColumnSettings();
            filter.setId(OrganizationIndex.Property.code.name());
            params.getFilters().add(filter);
            filter = new TableColumnSettings();
            filter.setId(OrganizationIndex.Property.shortName.name());
            params.getFilters().add(filter);
            TableColumnSettings col = new TableColumnSettings();
            col.setId(OrganizationIndex.Property.code.name());
            params.getColumns().add(col);
            col = new TableColumnSettings();
            col.setId(OrganizationIndex.Property.shortName.name());
            params.getColumns().add(col);
            Objects.requireNonNull(IndexListService.get()).open("organizations-for-" + ref.getUid(), L10nResourcesManager.getStr((String)Messages.OrganizationsUsingTheQualityCheckRule, (Object[])new Object[]{ref}), params);
        };
        ((OrganizationQualityCheckRulesMainPanel)controller.getView().getMainTile().getFullNode()).getOrganizationsUsingTheRuleNode().setOnAction(handler);
        RulesViewConfiguration config = new RulesViewConfiguration();
        config.getFilters().addAll(Arrays.asList(StandardFilters.values()));
        config.getCategories().add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_END_PNR_CATEGORY_WARNING);
        config.getCategories().add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_END_PNR_CATEGORY_MANDATORY);
        config.getCategories().add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_TICKETING_CATEGORY_WARNING);
        config.getCategories().add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_TICKETING_CATEGORY_MANDATORY);
        config.getCategories().add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_VOID_CATEGORY_MANDATORY);
        config.getCategories().add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_EXCHANGE_CATEGORY_MANDATORY);
        config.setActionsSupplier(target -> RulesEnvironment.get().getActions(target).stream().filter(action -> RulesEnvironment.get().getActions((RuleFilteringCategory)QualityCheckFilteringCategories.QC_END_PNR_CATEGORY_WARNING).contains(action) || RulesEnvironment.get().getActions((RuleFilteringCategory)QualityCheckFilteringCategories.QC_END_PNR_CATEGORY_MANDATORY).contains(action) || RulesEnvironment.get().getActions((RuleFilteringCategory)QualityCheckFilteringCategories.QC_TICKETING_CATEGORY_WARNING).contains(action) || RulesEnvironment.get().getActions((RuleFilteringCategory)QualityCheckFilteringCategories.QC_TICKETING_CATEGORY_MANDATORY).contains(action) || RulesEnvironment.get().getActions((RuleFilteringCategory)QualityCheckFilteringCategories.QC_VOID_CATEGORY_MANDATORY).contains(action) || RulesEnvironment.get().getActions((RuleFilteringCategory)QualityCheckFilteringCategories.QC_EXCHANGE_CATEGORY_MANDATORY).contains(action)).collect(Collectors.toList()));
        config.setCollapsible(false);
        RulesWidgetHelper.initTile((Tile<Node, CustomWidget<RuleSet>>)controller.getView().getQualityCheckRulesTile(), config);
    }
}

