/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.receipt;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.ReceiptLogsContainerTableDetailsPartVM;
import com.gridnine.xtrip.client.fx.model.booking.ReceiptLogsContainerTableVM;
import com.gridnine.xtrip.client.fx.model.fiscal.ReceiptMainContainerVM;
import com.gridnine.xtrip.client.fx.model.fiscal.ReceiptMainPanelVM;
import com.gridnine.xtrip.client.fx.model.fiscal.ReceiptMessagesContainerTableVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.receipt.ReceiptHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.receipt.ReceiptLogsControllerInterceptor;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class StandardReceiptHandlerConfigurator
implements ReceiptHandlerConfigurator {
    @Override
    public void configureController(List<BiConsumer<DataTransferPackage<Receipt, Void>, ReceiptMainPanelVM>> toVM, List<BiConsumer<ReceiptMainPanelVM, DataTransferPackage<Receipt, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new ReceiptLogsControllerInterceptor());
        toVM.add((dtp, vm) -> {
            Receipt model = (Receipt)dtp.getContainer().getEntity();
            ReceiptMainContainerVM mainVM = vm.getMain();
            mainVM.setNumber(TextUtil.buildFullNumber((CompositeNumber)model));
            mainVM.setServiceType(model.getServiceType());
            mainVM.setStatus(model.getStatus());
            if (model.getOwner() != null && model.getOwner().getType() == BookingFile.class) {
                mainVM.setOwner(model.getOwner());
            }
            mainVM.setDescription(model.getDescription());
            mainVM.setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
            mainVM.setUpdated(DateUtils.asLocalDate((Date)model.getUpdated()));
            mainVM.setDocument(model.getDocument());
            mainVM.setPreviousReceipt(model.getPreviousReceipt());
            mainVM.setNextReceipt(model.getNextReceipt());
            List logsVM = vm.getLogs();
            logsVM.clear();
            logsVM.addAll(model.getLogs().stream().map(el -> {
                ReceiptLogsContainerTableVM tableVM = new ReceiptLogsContainerTableVM();
                tableVM.setName(el.getName());
                tableVM.setCreated(DateUtils.asLocalDate((Date)el.getCreated()));
                List detailsVM = tableVM.getDetails().getDetails();
                el.getParts().forEach(part -> {
                    ReceiptLogsContainerTableDetailsPartVM partVM = new ReceiptLogsContainerTableDetailsPartVM();
                    partVM.setName(part.getName());
                    partVM.setGlobaldata(part.getGlobalData());
                    detailsVM.add(partVM);
                });
                return tableVM;
            }).collect(Collectors.toList()));
            List messagesVM = vm.getMessages();
            messagesVM.clear();
            messagesVM.addAll(model.getMessages().stream().map(el -> {
                ReceiptMessagesContainerTableVM tableVM = new ReceiptMessagesContainerTableVM();
                tableVM.setMessage(this.messagesConverter((Message)el));
                tableVM.getDetails().setDetails(el.getDetails());
                return tableVM;
            }).collect(Collectors.toList()));
        });
        fromVM.add((vm, dtp) -> {
            Receipt model = (Receipt)dtp.getContainer().getEntity();
            ReceiptMainContainerVM mainVM = vm.getMain();
            model.setServiceType(mainVM.getServiceType());
            model.setStatus(mainVM.getStatus());
            model.setDescription(mainVM.getDescription());
        });
    }

    private String messagesConverter(Message el) {
        return el.getMessage().toString();
    }
}

