/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint;

import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointValidatorsTableItemVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

final class SalesPointValidatorsTileHelper {
    private SalesPointValidatorsTileHelper() {
    }

    static void toVM(SalesPoint model, List<SalesPointValidatorsTableItemVM> full) {
        VMHelper.transfer(model.getValidators(), full, validator -> new SalesPointValidatorsTableItemVM(), (validator, vm) -> {
            vm.getFullData().setNumber(validator.getNumber());
            Pcc pcc = validator.getPCC();
            if (pcc == null) {
                vm.getFullData().setPccRef(null);
            } else {
                vm.getFullData().setPccRef(new EntityReference(pcc.getUid(), Pcc.class, pcc.getCode()));
            }
            vm.getFullData().setBlankOwner(validator.getBlankOwner());
            vm.getFullData().setSupplier(validator.getSupplier());
            vm.getFullData().setAgency(validator.getAgency());
            vm.getFullData().setStartDate(DateUtils.asLocalDate((Date)validator.getOpened()));
            vm.getFullData().setEndDate(DateUtils.asLocalDate((Date)validator.getClosed()));
            vm.getFullData().setComment(validator.getNotes());
            vm.setNumber(validator.getNumber());
            vm.setPcc(validator.getPCC() == null ? null : validator.getPCC().getCode());
            vm.setBlankOwner(validator.getBlankOwner() == null ? null : validator.getBlankOwner().getCaption());
            vm.setSupplier(validator.getSupplier() == null ? null : validator.getSupplier().getCaption());
            vm.setAgency(validator.getAgency() == null ? null : validator.getAgency().getCaption());
            vm.setStartDate((String)StandardRenderers.DATE.apply((Object)validator.getOpened()));
            vm.setEndDate((String)StandardRenderers.DATE.apply((Object)validator.getClosed()));
        });
    }

    static void fromVM(List<SalesPointValidatorsTableItemVM> full, SalesPoint model) {
        VMHelper.transfer(full, model.getValidators(), vm -> new Validator(), (vm, validator) -> {
            validator.setNumber(vm.getFullData().getNumber());
            validator.setPCC(vm.getFullData().getPccRef() == null ? null : (Pcc)CollectionUtil.find((Iterable)model.getPccs(), (String)vm.getFullData().getPccRef().getUid()));
            validator.setBlankOwner(vm.getFullData().getBlankOwner());
            validator.setSupplier(vm.getFullData().getSupplier());
            validator.setAgency(vm.getFullData().getAgency());
            validator.setOpened(DateUtils.asDate((LocalDate)vm.getFullData().getStartDate()));
            validator.setClosed(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)vm.getFullData().getEndDate())));
            validator.setNotes(vm.getFullData().getComment());
        });
    }
}

